/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.groups;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.commands.SimpleConfigurableCommand;
import dev.ftb.mods.ftbessentials.commands.impl.chat.MuteCommand;
import dev.ftb.mods.ftbessentials.commands.impl.chat.NicknameCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftblibrary.util.PlayerDisplayNameUtil;
import java.util.List;
import net.minecraft.ChatFormatting;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class ChatCommands {
    public static final List<FTBCommand> COMMANDS = List.of(new MuteCommand(), new NicknameCommand(), new SimpleConfigurableCommand(FTBEConfig.REC, (LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal((String)"recording").executes(context -> ChatCommands.recording(((CommandSourceStack)context.getSource()).getPlayerOrException())))), new SimpleConfigurableCommand(FTBEConfig.REC, (LiteralArgumentBuilder<CommandSourceStack>)((LiteralArgumentBuilder)Commands.literal((String)"streaming").executes(context -> ChatCommands.streaming(((CommandSourceStack)context.getSource()).getPlayerOrException())))));

    public static int recording(ServerPlayer player) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            data.setRecording(data.getRecording() == FTBEPlayerData.RecordingStatus.RECORDING ? FTBEPlayerData.RecordingStatus.NONE : FTBEPlayerData.RecordingStatus.RECORDING);
            PlayerDisplayNameUtil.refreshDisplayName((Player)player);
            if (data.getRecording() == FTBEPlayerData.RecordingStatus.RECORDING) {
                player.server.getPlayerList().broadcastSystemMessage((Component)player.getDisplayName().copy().withStyle(ChatFormatting.YELLOW).append(" ").append((Component)Component.translatable((String)"ftbessentials.chat.status.start_record")), false);
            } else {
                player.server.getPlayerList().broadcastSystemMessage((Component)player.getDisplayName().copy().withStyle(ChatFormatting.YELLOW).append(" ").append((Component)Component.translatable((String)"ftbessentials.chat.status.stop_record")), false);
            }
            data.sendTabName(player.server);
            return 1;
        }).orElse(0);
    }

    public static int streaming(ServerPlayer player) {
        return FTBEPlayerData.getOrCreate((Player)player).map(data -> {
            data.setRecording(data.getRecording() == FTBEPlayerData.RecordingStatus.STREAMING ? FTBEPlayerData.RecordingStatus.NONE : FTBEPlayerData.RecordingStatus.STREAMING);
            PlayerDisplayNameUtil.refreshDisplayName((Player)player);
            if (data.getRecording() == FTBEPlayerData.RecordingStatus.STREAMING) {
                player.server.getPlayerList().broadcastSystemMessage((Component)player.getDisplayName().copy().withStyle(ChatFormatting.YELLOW).append(" ").append((Component)Component.translatable((String)"ftbessentials.chat.status.start_stream")), false);
            } else {
                player.server.getPlayerList().broadcastSystemMessage((Component)player.getDisplayName().copy().withStyle(ChatFormatting.YELLOW).append(" ").append((Component)Component.translatable((String)"ftbessentials.chat.status.stop_stream")), false);
            }
            data.sendTabName(player.server);
            return 1;
        }).orElse(0);
    }
}

