/*
 * Decompiled with CFR 0.152.
 */
package snownee.kiwi.customization.block.behavior;

import java.util.Objects;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.BlockTags;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Display;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.CollisionGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BedBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CarpetBlock;
import net.minecraft.world.level.block.SlabBlock;
import net.minecraft.world.level.block.StairBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.entity.EntityTypeTest;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;
import snownee.kiwi.customization.CustomFeatureTags;
import snownee.kiwi.customization.block.KBlockSettings;
import snownee.kiwi.customization.block.KBlockUtils;
import snownee.kiwi.customization.block.behavior.KSitCommonConfig;
import snownee.kiwi.customization.block.component.KBlockComponent;

public class SitManager {
    public static final Component ENTITY_NAME = Component.literal((String)"Seat from Kiwi");
    public static final double VERTICAL_OFFSET = 0.23;

    public static void tick(Display.BlockDisplay display) {
        if (display.tickCount < 7) {
            return;
        }
        if (!display.isVehicle()) {
            display.discard();
        }
        BlockPos pos = BlockPos.containing((double)display.getX(), (double)(display.getY() + 0.23), (double)display.getZ());
        BlockState blockState = display.level().getBlockState(pos);
        if (!blockState.is(display.getBlockState().getBlock())) {
            display.discard();
        }
    }

    public static boolean sit(Player player, BlockHitResult hitResult) {
        BlockPos pos;
        if (hitResult.getDirection() == Direction.DOWN || player.isSecondaryUseActive()) {
            return false;
        }
        Level level = player.level();
        BlockState blockState = level.getBlockState(pos = hitResult.getBlockPos());
        if (!blockState.is(CustomFeatureTags.SITTABLE)) {
            return false;
        }
        Block block = blockState.getBlock();
        if (block instanceof BedBlock) {
            ServerPlayer serverPlayer;
            if (((Boolean)blockState.getValue((Property)BedBlock.OCCUPIED)).booleanValue() || !BedBlock.canSetSpawn((Level)level)) {
                return false;
            }
            Direction direction = (Direction)blockState.getValue((Property)BedBlock.FACING);
            if (player instanceof ServerPlayer && (serverPlayer = (ServerPlayer)player).bedInRange(pos, direction)) {
                return false;
            }
        } else if (player.getEyePosition().distanceToSqr(hitResult.getLocation()) > 12.0) {
            return false;
        }
        if (!player.getMainHandItem().isEmpty() && player.getMainHandItem().is(block.asItem())) {
            return false;
        }
        if (!KSitCommonConfig.sitOnStairs && block instanceof StairBlock) {
            return false;
        }
        if (!KSitCommonConfig.sitOnSlab && block instanceof SlabBlock) {
            return false;
        }
        if (!KSitCommonConfig.sitOnCarpet && block instanceof CarpetBlock) {
            return false;
        }
        if (!KSitCommonConfig.sitOnBed && block instanceof BedBlock) {
            return false;
        }
        if (!level.getEntities((EntityTypeTest)EntityType.BLOCK_DISPLAY, new AABB(pos).expandTowards(0.0, 1.0, 0.0), SitManager::isSeatEntity).isEmpty()) {
            return false;
        }
        if (!level.isClientSide) {
            Display.BlockDisplay display = new Display.BlockDisplay(EntityType.BLOCK_DISPLAY, level);
            display.setCustomName(ENTITY_NAME);
            display.setBlockState(blockState);
            VoxelShape shape = blockState.getShape((BlockGetter)level, pos, CollisionContext.of((Entity)player));
            Vec3 seatPos = null;
            Direction facing = SitManager.guessBlockFacing(blockState, player);
            if (!shape.isEmpty()) {
                Vec3 traceEnd;
                Vec3 traceStart;
                BlockHitResult hit;
                AABB bounds = shape.bounds();
                double x = (bounds.minX + bounds.maxX) / 2.0;
                double y = bounds.maxX + 0.1;
                double z = (bounds.minZ + bounds.maxZ) / 2.0;
                if (facing != null) {
                    x += (double)facing.getStepX() * 0.1;
                    z += (double)facing.getStepZ() * 0.1;
                }
                if ((hit = shape.clip(traceStart = new Vec3((double)pos.getX() + x, (double)pos.getY() + y, (double)pos.getZ() + z), traceEnd = traceStart.add(0.0, -2.0, 0.0), pos)) != null && hit.getType() == HitResult.Type.BLOCK) {
                    seatPos = hit.getLocation();
                }
            }
            if (facing != null) {
                float yRot = facing.toYRot();
                display.setYRot(yRot);
                display.setNoGravity(true);
            }
            if (seatPos == null) {
                seatPos = Vec3.atCenterOf((Vec3i)pos);
            }
            double clampedY = Mth.clamp((double)seatPos.y, (double)pos.getY(), (double)((double)pos.getY() + 0.999));
            display.setPos(seatPos.x, clampedY - 0.23, seatPos.z);
            if (level.addFreshEntity((Entity)display)) {
                player.startRiding((Entity)display, true);
            }
        }
        return true;
    }

    @Nullable
    public static Direction guessBlockFacing(BlockState blockState, @Nullable Player player) {
        Direction direction;
        Direction.Axis axis;
        if (blockState.is(BlockTags.BEDS)) {
            return null;
        }
        KBlockSettings settings = KBlockSettings.of(blockState.getBlock());
        if (settings != null) {
            for (KBlockComponent component : settings.components.values()) {
                Direction facing = component.getHorizontalFacing(blockState);
                if (facing == null) continue;
                return facing;
            }
        }
        boolean oppose = false;
        try {
            String shape = KBlockUtils.getValueString(blockState, "shape");
            if (!"straight".equals(shape)) {
                return null;
            }
            oppose = blockState.getBlock() instanceof StairBlock;
        }
        catch (Throwable shape) {
            // empty catch block
        }
        if (blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_FACING)) {
            Direction direction2 = (Direction)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_FACING);
            return oppose ? direction2.getOpposite() : direction2;
        }
        if (player != null && blockState.hasProperty((Property)BlockStateProperties.HORIZONTAL_AXIS) && (axis = (Direction.Axis)blockState.getValue((Property)BlockStateProperties.HORIZONTAL_AXIS)).test(direction = player.getDirection())) {
            return direction;
        }
        return null;
    }

    public static boolean isSeatEntity(@Nullable Entity entity) {
        if (entity == null || entity.getType() != EntityType.BLOCK_DISPLAY) {
            return false;
        }
        Component customName = entity.getCustomName();
        return customName != null && Objects.equals(customName.getString(), ENTITY_NAME.getString());
    }

    public static void clampRotation(Player player, Entity seat) {
        if (!seat.isNoGravity()) {
            return;
        }
        float seatRot = Mth.wrapDegrees((float)seat.getYRot());
        float f = Mth.wrapDegrees((float)(player.getYRot() - seatRot));
        float f1 = Mth.clamp((float)f, (float)-105.0f, (float)105.0f);
        player.yRotO += f1 - f;
        player.setYRot(player.getYRot() + f1 - f);
        player.setYHeadRot(player.getYRot());
        player.setYBodyRot(seatRot);
        f = Mth.wrapDegrees((float)player.getXRot());
        f1 = Math.max(f, -45.0f);
        player.setXRot(f1);
    }

    public static Vec3 dismount(Entity display, LivingEntity passenger) {
        Direction direction = display.isNoGravity() ? display.getDirection() : passenger.getDirection();
        BlockPos pos = BlockPos.containing((double)display.getX(), (double)(display.getY() + 0.23), (double)display.getZ());
        Optional vec3 = BedBlock.findStandUpPosition((EntityType)passenger.getType(), (CollisionGetter)passenger.level(), (BlockPos)pos, (Direction)direction, (float)passenger.getYRot());
        return vec3.orElseGet(() -> Vec3.atBottomCenterOf((Vec3i)pos.above()));
    }
}

