/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.furnace.FurnaceFuelBurnTimeEvent;

public class FuelHandler {
    public static FuelHandler INSTANCE = new FuelHandler();
    private Map<Item, Integer> FUEL_MAP = new HashMap<Item, Integer>();

    public ItemStack registerFuel(Block fuel, int burnTime) {
        if (fuel == null) {
            return ItemStack.EMPTY;
        }
        return this.registerFuel(fuel.asItem(), burnTime);
    }

    public ItemStack registerFuel(Item fuel, int burnTime) {
        if (fuel == null) {
            return ItemStack.EMPTY;
        }
        this.FUEL_MAP.put(fuel, burnTime);
        return new ItemStack((ItemLike)fuel);
    }

    public int getBurnTime(ItemStack fuel) {
        return this.FUEL_MAP.containsKey(fuel.getItem()) ? this.FUEL_MAP.get(fuel.getItem()) : 0;
    }

    @SubscribeEvent
    public void BurnTimeEvent(FurnaceFuelBurnTimeEvent event) {
        int burnTime = this.getBurnTime(event.getItemStack());
        if (burnTime > 0) {
            event.setBurnTime(burnTime);
        }
    }
}

