/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.item;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Supplier;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.HoeItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.PickaxeItem;
import net.minecraft.world.item.ShovelItem;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.neoforged.bus.api.IEventBus;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.neoforge.event.BuildCreativeModeTabContentsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;

public class ToolSet {
    final String name;
    final Tier material;
    protected final Supplier<CreativeModeTab> toolTab;
    protected final Supplier<CreativeModeTab> weaponTab;
    Map<ToolType, DeferredHolder<Item, Item>> tools = Maps.newHashMap();

    public ToolSet(String name, Tier material, Supplier<CreativeModeTab> tab, DeferredRegister<Item> registry, IEventBus modBus) {
        this(name, material, tab, tab, registry, modBus);
    }

    public ToolSet(String name, Tier material, Supplier<CreativeModeTab> toolTab, Supplier<CreativeModeTab> weaponTab, DeferredRegister<Item> registry, IEventBus modBus) {
        this.name = name;
        this.material = material;
        this.toolTab = toolTab;
        this.weaponTab = weaponTab;
        for (ToolType type : ToolType.values()) {
            DeferredHolder<Item, Item> item = type.createItem(name, material, registry);
            if (item == null) continue;
            this.tools.put(type, item);
        }
        modBus.register((Object)this);
    }

    @SubscribeEvent
    public void addCreative(BuildCreativeModeTabContentsEvent event) {
        if (event.getTab() == this.toolTab.get()) {
            for (Map.Entry<ToolType, DeferredHolder<Item, Item>> entry : this.tools.entrySet()) {
                if (entry.getKey().isWeapon) continue;
                event.accept((ItemLike)entry.getValue().get());
            }
        }
        if (event.getTab() == this.weaponTab.get()) {
            for (Map.Entry<ToolType, DeferredHolder<Item, Item>> entry : this.tools.entrySet()) {
                if (!entry.getKey().isWeapon) continue;
                event.accept((ItemLike)entry.getValue().get());
            }
        }
    }

    public String getName() {
        return this.name;
    }

    public Tier getMaterial() {
        return this.material;
    }

    public Item getItem(ToolType type) {
        return (Item)this.tools.get(type).get();
    }

    public Collection<Item> getItems() {
        return this.tools.values().stream().map(item -> (Item)item.get()).toList();
    }

    public static class ToolType {
        static Set<ToolType> REGISTERED_TYPES = new HashSet<ToolType>();
        public static ToolType SWORD = ToolType.register("sword", (material, properties) -> new SwordItem(material, properties), true);
        public static ToolType HOE = ToolType.register("hoe", (material, properties) -> new HoeItem(material, properties));
        public static ToolType PICKAXE = ToolType.register("pickaxe", (material, properties) -> new PickaxeItem(material, properties));
        public static ToolType AXE = ToolType.register("axe", (material, properties) -> new AxeItem(material, properties));
        public static ToolType SHOVEL = ToolType.register("shovel", (material, properties) -> new ShovelItem(material, properties));
        protected final String name;
        protected final BiFunction<Tier, Item.Properties, TieredItem> function;
        protected final boolean isWeapon;

        ToolType(String name, BiFunction<Tier, Item.Properties, TieredItem> function, boolean isWeapon) {
            this.name = name;
            this.function = function;
            this.isWeapon = isWeapon;
        }

        public static Set<ToolType> values() {
            return REGISTERED_TYPES;
        }

        public static ToolType register(String name, BiFunction<Tier, Item.Properties, TieredItem> function) {
            return ToolType.register(name, function, false);
        }

        public static ToolType register(String name, BiFunction<Tier, Item.Properties, TieredItem> function, boolean isWeapon) {
            ToolType type = new ToolType(name, function, isWeapon);
            REGISTERED_TYPES.add(type);
            return type;
        }

        public boolean isWeapon() {
            return this.isWeapon;
        }

        public String getName() {
            return this.name;
        }

        public DeferredHolder<Item, Item> createItem(String name, Tier material, DeferredRegister<Item> registry) {
            return registry.register(name + "_" + this.name, () -> (Item)this.function.apply(material, new Item.Properties()));
        }
    }
}

