/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.util;

import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Position;
import net.minecraft.core.Vec3i;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LightLayer;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.EntityHitResult;
import net.minecraft.world.phys.HitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;

public class VecMath {
    public static HitResult entityRayTrace(Level level, Entity entity, float reach) {
        Vec3 eye = entity.getEyePosition();
        Vec3 angle = entity.getLookAngle();
        Vec3 last = eye.add(angle);
        Vec3 end = eye.add(angle.x * (double)reach, angle.y * (double)reach, angle.z * (double)reach);
        ClipContext context = new ClipContext(eye, end, ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, CollisionContext.of((Entity)entity));
        BlockHitResult blockRay = level.clip(context);
        int x = 0;
        while ((float)x < 16.0f * reach) {
            float segment = (float)x / 16.0f;
            Vec3 vec = eye.add(angle.x * (double)segment, angle.y * (double)segment, angle.z * (double)segment);
            if (blockRay == null || blockRay.getLocation() == null) {
                return new BlockHitResult(angle, Direction.getNearest((Vec3)angle), null, false);
            }
            if (blockRay.getLocation().distanceTo(eye) < vec.distanceTo(eye)) break;
            AABB aabb = new AABB(last.x, last.y, last.z, vec.x, vec.y, vec.z);
            List entities = level.getEntities(entity, aabb);
            if (!entities.isEmpty()) {
                return new EntityHitResult((Entity)entities.get(0), angle);
            }
            last = vec;
            ++x;
        }
        return blockRay;
    }

    public static Direction randomDirXZ(RandomSource rand) {
        return VecMath.xzFromMeta(rand.nextInt(4));
    }

    public static Direction xzFromMeta(int direction) {
        switch (direction) {
            case 1: {
                return Direction.SOUTH;
            }
            case 2: {
                return Direction.EAST;
            }
            case 3: {
                return Direction.WEST;
            }
        }
        return Direction.NORTH;
    }

    public static int metaFromXZ(Direction facing) {
        return facing == Direction.UP || facing == Direction.DOWN ? facing.ordinal() + 4 : facing.ordinal() - 2;
    }

    public static Vec3 directionXZ(Vec3i start, Vec3i end) {
        return VecMath.directionXZ(new Vec3((double)start.getX(), (double)start.getY(), (double)start.getZ()), new Vec3((double)end.getX(), (double)end.getY(), (double)end.getZ()));
    }

    public static Vec3 directionXZ(Vec3 start, Vec3 end) {
        return VecMath.directionXZ(Math.atan2(end.x - start.x, end.z - start.z));
    }

    public static Vec3 directionXZ(Entity start, Entity end) {
        return VecMath.directionXZ(start.position(), end.position());
    }

    public static Vec3 directionXZDegrees(double angle) {
        return VecMath.directionXZ(Math.toRadians(angle));
    }

    public static Vec3 directionXZ(double angle) {
        return new Vec3(Math.cos(angle), 0.0, Math.sin(angle));
    }

    public static Vec3 randomXZVec(RandomSource rand) {
        return VecMath.directionXZDegrees(rand.nextInt(360));
    }

    public static Vec3 direction(Entity start, Entity end) {
        return VecMath.direction(start.position(), end.position());
    }

    public static Vec3 direction(Vec3i startpos, Vec3i endpos) {
        return VecMath.direction(new Vec3((double)startpos.getX(), (double)startpos.getY(), (double)startpos.getZ()), new Vec3((double)endpos.getX(), (double)endpos.getY(), (double)endpos.getZ()));
    }

    public static Vec3 direction(Vec3 startpos, Vec3 endpos) {
        if (startpos.equals((Object)endpos)) {
            return new Vec3(0.0, 0.0, 0.0);
        }
        double dx = endpos.x - startpos.x;
        double dy = endpos.y - startpos.y;
        double dz = endpos.z - startpos.z;
        double magnitude = Math.sqrt(Math.pow(dx, 2.0) + Math.pow(dy, 2.0) + Math.pow(dz, 2.0));
        return new Vec3(dx / magnitude, dy / magnitude, dz / magnitude);
    }

    public static BlockPos closestLoadedPos(Level level, BlockPos basepos, Vec3 direction, double radius) {
        return VecMath.closestLoadedPos(level, basepos, direction, radius, Heightmap.Types.WORLD_SURFACE_WG);
    }

    public static BlockPos closestLoadedPos(Level level, BlockPos basepos, Vec3 direction, double radius, Heightmap.Types type) {
        BlockPos pos = level.getHeightmapPos(type, basepos.offset((int)(direction.x * radius), 0, (int)(direction.z * radius)));
        while (!level.hasChunk(pos.getX() / 16, pos.getZ() / 16)) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = level.getHeightmapPos(type, basepos.offset((int)(direction.x * (radius -= 1.0)), 0, (int)(direction.z * radius)));
        }
        return pos;
    }

    public static BlockPos closestLoadedPos(Level level, BlockPos basepos, Vec3 direction, double radius, int maxlight, int minlight) {
        return VecMath.closestLoadedPos(level, basepos, direction, radius, maxlight, minlight, Heightmap.Types.WORLD_SURFACE_WG);
    }

    public static BlockPos closestLoadedPos(Level level, BlockPos basepos, Vec3 direction, double radius, int maxlight, int minlight, Heightmap.Types type) {
        BlockPos pos = level.getHeightmapPos(type, basepos.offset((int)(direction.x * radius), 0, (int)(direction.z * radius)));
        while (!level.hasChunk(pos.getX() / 16, pos.getZ() / 16) || !VecMath.isBrightnessAllowed(level, pos, maxlight, minlight)) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = level.getHeightmapPos(type, basepos.offset((int)(direction.x * (radius -= 1.0)), 0, (int)(direction.z * radius)));
        }
        return pos;
    }

    public static Vec3 closestLoadedPos(Level level, Vec3 basepos, Vec3 direction, double radius) {
        return VecMath.closestLoadedPos(level, basepos, direction, radius, Heightmap.Types.WORLD_SURFACE_WG);
    }

    public static Vec3 closestLoadedPos(Level level, Vec3 basepos, Vec3 direction, double radius, Heightmap.Types type) {
        Vec3 pos = basepos.add(direction.x * radius, 0.0, direction.z * radius);
        pos = pos.add(0.0, (double)level.getHeight(type, (int)pos.x, (int)pos.z) - pos.y, 0.0);
        while (!level.hasChunk((int)pos.x / 16, (int)pos.z / 16)) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = basepos.add(direction.x * (radius -= 1.0), 0.0, direction.z * radius).add(0.0, (double)level.getHeight(type, (int)pos.x, (int)pos.z) - pos.y, 0.0);
        }
        return pos;
    }

    public static Vec3 closestLoadedPos(Level level, Vec3 basepos, Vec3 direction, double radius, int maxlight, int minlight) {
        return VecMath.closestLoadedPos(level, basepos, direction, radius, maxlight, minlight, Heightmap.Types.WORLD_SURFACE_WG);
    }

    public static Vec3 closestLoadedPos(Level level, Vec3 basepos, Vec3 direction, double radius, int maxlight, int minlight, Heightmap.Types type) {
        Vec3 pos = basepos.add(direction.x * radius, 0.0, direction.z * radius);
        pos = pos.add(0.0, (double)level.getHeight(type, (int)pos.x, (int)pos.z) - pos.y, 0.0);
        while (!level.hasChunk((int)pos.x / 16, (int)pos.z / 16) || !VecMath.isBrightnessAllowed(level, BlockPos.containing((Position)pos), maxlight, minlight)) {
            if (radius == 0.0) {
                return basepos;
            }
            pos = basepos.add(direction.x * (radius -= 1.0), 0.0, direction.z * radius);
            pos = pos.add(0.0, (double)level.getHeight(type, (int)pos.x, (int)pos.z) - pos.y, 0.0);
        }
        return pos;
    }

    public static boolean isBrightnessAllowed(Level level, BlockPos pos, int maxlight, int minlight) {
        int blocklight = level.getBrightness(LightLayer.BLOCK, pos);
        if (blocklight > maxlight) {
            return false;
        }
        return blocklight >= minlight;
    }
}

