/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.atlas.api.util;

import com.google.common.collect.Lists;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import net.minecraft.util.RandomSource;

public class WeightedOutputs<T> {
    protected final List<Map.Entry<T, Integer>> entries = new ArrayList<Map.Entry<T, Integer>>();
    protected int defaultTries;

    public WeightedOutputs(Map<T, Integer> entries) {
        this(1, new ArrayList<Map.Entry<T, Integer>>(entries.entrySet()));
    }

    public WeightedOutputs(int defaultTries, Map<T, Integer> entries) {
        this(defaultTries, entries.entrySet());
    }

    public WeightedOutputs(int defaultTries, Collection<Map.Entry<T, Integer>> entries) {
        this.defaultTries = defaultTries;
        this.entries.addAll(entries);
    }

    public int getAmount() {
        return this.defaultTries;
    }

    public List<Map.Entry<T, Integer>> getTable() {
        return this.entries;
    }

    public boolean isEmpty() {
        return this.entries.isEmpty();
    }

    public T getResult(RandomSource rand) {
        return this.getResults(rand, 1).get(0);
    }

    public List<T> getResults(RandomSource rand) {
        return this.getResults(rand, 1);
    }

    public void clear() {
        this.entries.clear();
    }

    public int getWeight(T t) {
        for (Map.Entry<T, Integer> entry : this.entries) {
            if (entry.getKey() != t) continue;
            return entry.getValue();
        }
        return 0;
    }

    public boolean removeEntry(T t) {
        boolean result = false;
        for (Map.Entry<T, Integer> entry : this.entries) {
            if (entry.getKey() != t) continue;
            this.entries.remove(entry);
            result = true;
        }
        return result;
    }

    public void setDefaultTries(int value) {
        this.defaultTries = value;
    }

    public void addEntry(T t, int weight) {
        this.entries.add(new AbstractMap.SimpleEntry<T, Integer>(t, weight));
    }

    public void addEntries(Collection<Map.Entry<T, Integer>> entries) {
        this.entries.addAll(entries);
    }

    public void addEntries(Map<T, Integer> entries) {
        this.entries.addAll(entries.entrySet());
    }

    public List<T> getResults(RandomSource rand, int tries) {
        ArrayList list = new ArrayList();
        ArrayList mappedEntries = Lists.newArrayList();
        int max = 0;
        for (Map.Entry<T, Integer> entry : this.entries) {
            mappedEntries.add(new AbstractMap.SimpleEntry<T, Integer>(entry.getKey(), max));
            max += entry.getValue().intValue();
        }
        if (max > 0) {
            Collections.reverse(mappedEntries);
            block1: for (int i = 0; i < tries * this.defaultTries; ++i) {
                int result = rand.nextInt(max);
                for (Map.Entry entry : mappedEntries) {
                    if (result < (Integer)entry.getValue()) continue;
                    list.add(entry.getKey());
                    continue block1;
                }
            }
        }
        return list;
    }
}

