/*
 * Decompiled with CFR 0.152.
 */
package com.mrh0.createaddition.datagen.TagProvider;

import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.tags.ItemTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.material.Fluid;

public class CATagRegister {

    public static class Fluids {
        public static final TagKey<Fluid> BIOFUEL = Fluids.commonTags("biofuel");
        public static final TagKey<Fluid> CREOSOTE = Fluids.commonTags("creosote");
        public static final TagKey<Fluid> CRUDE_OIL = Fluids.commonTags("crude_oil");
        public static final TagKey<Fluid> PLANTOIL = Fluids.commonTags("plantoil");
        public static final TagKey<Fluid> ETHANOL = Fluids.commonTags("ethanol");
        public static final TagKey<Fluid> GASOLINE = Fluids.commonTags("gasoline");
        public static final TagKey<Fluid> DIESEL = Fluids.commonTags("diesel");
        public static final TagKey<Fluid> BIODIESEL = Fluids.commonTags("biodiesel");

        public static TagKey<Fluid> commonTags(String folder, String name) {
            return FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)String.format("%s/%s", folder, name)));
        }

        public static TagKey<Fluid> commonTags(String name) {
            return FluidTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }
    }

    public static class Blocks {
        public static final TagKey<Block> STORAGE_BLOCKS = Blocks.commonTags("storage_blocks");
        public static final TagKey<Block> STORAGE_BLOCKS_BIOMASS = Blocks.commonTags("storage_blocks", "biomass");
        public static final TagKey<Block> STORAGE_BLOCKS_BIO = Blocks.commonTags("storage_blocks", "bio");
        public static final TagKey<Block> STORAGE_BLOCKS_ELECTRUM = Blocks.commonTags("storage_blocks", "electrum");
        public static final TagKey<Block> FARMERSDELIGHT_MINEABLE_KNIFE = Blocks.modTags("farmersdelight", "mineable", "knife");

        public static TagKey<Block> commonTags(String folder, String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)String.format("%s/%s", folder, name)));
        }

        public static TagKey<Block> commonTags(String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        public static TagKey<Block> modTags(String mod, String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)mod, (String)name));
        }

        public static TagKey<Block> modTags(String mod, String folder, String name) {
            return BlockTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)mod, (String)String.format("%s/%s", folder, name)));
        }
    }

    public static class Items {
        public static final TagKey<Item> DIAMOND_DUSTS = Items.commonTags("dusts", "diamond");
        public static final TagKey<Item> OBSIDIAN_DUSTS = Items.commonTags("dusts", "obsidian");
        public static final TagKey<Item> BIO_FUELS = Items.commonTags("fuels", "bio");
        public static final TagKey<Item> ELECTRUM_BLOCKS = Items.commonTags("blocks", "electrum");
        public static final TagKey<Item> ELECTRUM_INGOTS = Items.commonTags("ingots", "electrum");
        public static final TagKey<Item> ELECTRUM_NUGGETS = Items.commonTags("nuggets", "electrum");
        public static final TagKey<Item> ELECTRUM_PLATES = Items.commonTags("plates", "electrum");
        public static final TagKey<Item> ZINC_PLATES = Items.commonTags("plates", "zinc");
        public static final TagKey<Item> ZINC_INGOTS = Items.commonTags("ingots", "zinc");
        public static final TagKey<Item> ALL_METAL_RODS = Items.commonTags("rods", "all_metal");
        public static final TagKey<Item> BRASS_RODS = Items.commonTags("rods", "brass");
        public static final TagKey<Item> COPPER_RODS = Items.commonTags("rods", "copper");
        public static final TagKey<Item> ELECTRUM_RODS = Items.commonTags("rods", "electrum");
        public static final TagKey<Item> GOLD_RODS = Items.commonTags("rods", "gold");
        public static final TagKey<Item> IRON_RODS = Items.commonTags("rods", "iron");
        public static final TagKey<Item> ALL_METAL_WIRES = Items.commonTags("wires", "all_metal");
        public static final TagKey<Item> COPPER_WIRES = Items.commonTags("wires", "copper");
        public static final TagKey<Item> ELECTRUM_WIRES = Items.commonTags("wires", "electrum");
        public static final TagKey<Item> GOLD_WIRES = Items.commonTags("wires", "gold");
        public static final TagKey<Item> IRON_WIRES = Items.commonTags("wires", "iron");
        public static final TagKey<Item> DUSTS = Items.commonTags("dusts");
        public static final TagKey<Item> FUELS = Items.commonTags("fuels");
        public static final TagKey<Item> INGOTS = Items.commonTags("ingots");
        public static final TagKey<Item> NUGGETS = Items.commonTags("nuggets");
        public static final TagKey<Item> PLATES = Items.commonTags("plates");
        public static final TagKey<Item> RODS = Items.commonTags("rods");
        public static final TagKey<Item> WIRES = Items.commonTags("wires");
        public static final TagKey<Item> FOODS = Items.commonTags("foods");
        public static final TagKey<Item> FOODS_EDIBLE = Items.commonTags("foods", "edible_when_placed");
        public static final TagKey<Item> STORAGE_BLOCKS_BIOMASS = Items.commonTags("storage_blocks", "biomass");
        public static final TagKey<Item> STORAGE_BLOCKS_BIO = Items.commonTags("storage_blocks", "bio");
        public static final TagKey<Item> STORAGE_BLOCKS_ELECTRUM = Items.commonTags("storage_blocks", "electrum");
        public static final TagKey<Item> PLANT_FOODS = Items.createAdditionsTags("plant_foods");
        public static final TagKey<Item> PLANTS = Items.createAdditionsTags("plants");
        public static final TagKey<Item> SPOOLS = Items.createAdditionsTags("spools");
        public static final TagKey<Item> LARGE_CONNECTOR_USABLE_RODS = Items.createAdditionsTags("large_connector_usable_rods");
        public static final TagKey<Item> MODULAR_ACCUMULATOR_USABLE_WIRES = Items.createAdditionsTags("modular_accumulator_usable_wires");

        public static TagKey<Item> commonTags(String folder, String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)String.format("%s/%s", folder, name)));
        }

        public static TagKey<Item> commonTags(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"c", (String)name));
        }

        public static TagKey<Item> createAdditionsTags(String folder, String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)String.format("%s/%s", folder, name)));
        }

        public static TagKey<Item> createAdditionsTags(String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)"createaddition", (String)name));
        }

        public static TagKey<Item> modTags(String mod, String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)mod, (String)name));
        }

        public static TagKey<Item> modTags(String mod, String folder, String name) {
            return ItemTags.create((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)mod, (String)String.format("%s/%s", folder, name)));
        }
    }
}

