/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import cpw.mods.inventorysorter.Config;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventorySorter;
import cpw.mods.inventorysorter.Network;
import cpw.mods.inventorysorter.ScrollWheelHandler;
import cpw.mods.inventorysorter.SortingHandler;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.world.inventory.Slot;
import net.neoforged.neoforge.common.ModConfigSpec;

public enum Action {
    SORT(SortingHandler.INSTANCE, "key.inventorysorter.sort", 2, Config.ClientConfig.CONFIG.sortingModule, ModConfigSpec.ConfigValue::get),
    ONEITEMIN(ScrollWheelHandler.ONEITEMIN, "key.inventorysorter.itemin", 99, Config.ClientConfig.CONFIG.wheelmoveModule, cf -> (Boolean)cf.get() != false && InventorySorter.INSTANCE.dontDodgeMouseTweaks()),
    ONEITEMOUT(ScrollWheelHandler.ONEITEMOUT, "key.inventorysorter.itemout", 101, Config.ClientConfig.CONFIG.wheelmoveModule, cf -> (Boolean)cf.get() != false && InventorySorter.INSTANCE.dontDodgeMouseTweaks());

    private final Consumer<ContainerContext> worker;
    private final String keyBindingName;
    private final int defaultKeyCode;
    private final ModConfigSpec.ConfigValue<Boolean> configValue;
    private final Predicate<ModConfigSpec.ConfigValue<Boolean>> configPredicate;

    private Action(Consumer<ContainerContext> worker, String keyBindingName, int defaultKeyCode, ModConfigSpec.ConfigValue<Boolean> configValue, Predicate<ModConfigSpec.ConfigValue<Boolean>> configPredicate) {
        this.worker = worker;
        this.keyBindingName = keyBindingName;
        this.defaultKeyCode = defaultKeyCode;
        this.configValue = configValue;
        this.configPredicate = configPredicate;
    }

    public String getKeyBindingName() {
        return this.keyBindingName;
    }

    public Network.ActionMessage message(Slot slot) {
        return new Network.ActionMessage(this, slot.index);
    }

    void execute(ContainerContext context) {
        this.worker.accept(context);
    }

    public boolean isActive() {
        return this.configPredicate.test(this.configValue);
    }

    public int getDefaultKeyCode() {
        return this.defaultKeyCode;
    }
}

