/*
 * Decompiled with CFR 0.152.
 */
package cpw.mods.inventorysorter;

import com.google.common.collect.ImmutableMultiset;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.TreeMultiset;
import com.google.common.collect.UnmodifiableIterator;
import cpw.mods.inventorysorter.ContainerContext;
import cpw.mods.inventorysorter.InventoryHandler;
import cpw.mods.inventorysorter.InventorySorter;
import cpw.mods.inventorysorter.ItemStackHolder;
import java.util.Comparator;
import java.util.function.Consumer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.CraftingContainer;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.util.Supplier;

public enum SortingHandler implements Consumer<ContainerContext>
{
    INSTANCE;


    @Override
    public void accept(ContainerContext context) {
        if (context == null) {
            throw new NullPointerException("WHUT");
        }
        if (context.slotMapping == null) {
            return;
        }
        Multiset<ItemStackHolder> itemcounts = InventoryHandler.INSTANCE.getInventoryContent(context);
        if (context.slot.container instanceof CraftingContainer) {
            this.distributeInventory(context, itemcounts);
        } else if (!context.slotMapping.markAsHeterogeneous) {
            this.compactInventory(context, itemcounts);
        }
    }

    private static ItemStack getStackInRowAndColumn(CraftingContainer inventory, int x, int y) {
        return inventory.getItem(y * inventory.getWidth() + x);
    }

    private void distributeInventory(ContainerContext context, Multiset<ItemStackHolder> itemcounts) {
        ItemStackHolder ish;
        ItemStack is;
        int x;
        CraftingContainer ic = (CraftingContainer)context.slot.container;
        TreeMultiset slotCounts = TreeMultiset.create((Comparator)new InventoryHandler.ItemStackComparator());
        for (int x2 = 0; x2 < ic.getWidth(); ++x2) {
            for (int y = 0; y < ic.getHeight(); ++y) {
                ItemStack is2 = SortingHandler.getStackInRowAndColumn(ic, x2, y);
                if (is2.isEmpty()) continue;
                slotCounts.add((Object)new ItemStackHolder(is2));
            }
        }
        ImmutableMultiset staticcounts = ImmutableMultiset.copyOf(itemcounts);
        for (x = 0; x < ic.getWidth(); ++x) {
            for (int y = 0; y < ic.getHeight(); ++y) {
                is = SortingHandler.getStackInRowAndColumn(ic, x, y);
                if (is.isEmpty()) continue;
                ish = new ItemStackHolder(is);
                int count = staticcounts.count((Object)ish);
                int slotNum = slotCounts.count((Object)ish);
                int occurrences = count / slotNum;
                itemcounts.remove((Object)ish, occurrences);
                is.setCount(occurrences);
            }
        }
        for (x = 0; x < ic.getWidth(); ++x) {
            for (int y = 0; y < ic.getHeight(); ++y) {
                is = SortingHandler.getStackInRowAndColumn(ic, x, y);
                if (is.isEmpty() || itemcounts.count((Object)(ish = new ItemStackHolder(is))) <= 0) continue;
                is.grow(itemcounts.setCount((Object)ish, 0));
            }
        }
        for (int slot = context.slotMapping.begin; slot < context.slotMapping.end + 1; ++slot) {
            context.player.containerMenu.getSlot(slot).setChanged();
        }
    }

    private void compactInventory(ContainerContext context, Multiset<ItemStackHolder> itemcounts) {
        UnmodifiableIterator itemsIterator;
        ResourceLocation containerTypeName;
        InventorySorter.INSTANCE.lastContainerType = containerTypeName = InventoryHandler.lookupContainerTypeName(context.slotMapping.container);
        if (InventorySorter.INSTANCE.isContainerBlacklisted(containerTypeName)) {
            InventorySorter.INSTANCE.debugLog("Container {} blacklisted", () -> new String[]{containerTypeName.toString()});
            return;
        }
        InventorySorter.INSTANCE.debugLog("Container \"{}\" being sorted", () -> new String[]{containerTypeName.toString()});
        try {
            itemsIterator = Multisets.copyHighestCountFirst(itemcounts).entrySet().iterator();
        }
        catch (Exception e) {
            InventorySorter.LOGGER.warn("Weird, the sorting didn't quite work!", (Throwable)e);
            return;
        }
        int slotLow = context.slotMapping.begin;
        int slotHigh = context.slotMapping.end + 1;
        Multiset.Entry stackHolder = itemsIterator.hasNext() ? (Multiset.Entry)itemsIterator.next() : null;
        int itemCount = stackHolder != null ? stackHolder.getCount() : 0;
        for (int i = slotLow; i < slotHigh; ++i) {
            Slot slot = context.player.containerMenu.getSlot(i);
            if (!slot.mayPickup((Player)context.player) && slot.hasItem()) {
                InventorySorter.LOGGER.log(Level.DEBUG, "Slot {} of container {} disallows canTakeStack", new Supplier[]{() -> slot.index, () -> containerTypeName});
                continue;
            }
            slot.set(ItemStack.EMPTY);
            ItemStack target = ItemStack.EMPTY;
            if (itemCount > 0 && stackHolder != null) {
                target = ((ItemStackHolder)stackHolder.getElement()).is.copy();
                target.setCount(Math.min(itemCount, slot.getMaxStackSize(target)));
            }
            if (!target.isEmpty() && !slot.mayPlace(target)) {
                ItemStack trg = target;
                InventorySorter.LOGGER.log(Level.DEBUG, "Item {} is not valid in slot {} of container {}", new Supplier[]{() -> trg, () -> slot.index, () -> containerTypeName});
                continue;
            }
            slot.set(target.isEmpty() ? ItemStack.EMPTY : target);
            if ((itemCount -= !target.isEmpty() ? target.getCount() : 0) != 0) continue;
            stackHolder = itemsIterator.hasNext() ? (Multiset.Entry)itemsIterator.next() : null;
            itemCount = stackHolder != null ? stackHolder.getCount() : 0;
        }
    }
}

