/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.ai;

import java.util.EnumSet;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.level.pathfinder.PathType;
import net.smileycorp.hordes.config.HordeEventConfig;

public class HordeTrackPlayerGoal
extends Goal {
    protected final Mob entity;
    protected final Entity target;
    protected final double speed;
    protected PathNavigation pather;
    protected int timeToRecalcPath;
    protected float waterCost;

    public HordeTrackPlayerGoal(Mob entity, Entity target, double speed) {
        this.timeToRecalcPath = entity.getRandom().nextInt(((Integer)HordeEventConfig.hordePathingInterval.get()).intValue());
        this.entity = entity;
        this.target = target;
        this.speed = speed;
        this.pather = entity.getNavigation();
        this.setFlags(EnumSet.of(Goal.Flag.LOOK, Goal.Flag.MOVE));
    }

    public boolean canUse() {
        return this.target != null && this.target.isAlive() && this.entity.getTarget() == null;
    }

    public void start() {
        this.waterCost = this.entity.getPathfindingMalus(PathType.WATER);
        this.entity.setPathfindingMalus(PathType.WATER, 0.0f);
    }

    public boolean canContinueToUse() {
        return true;
    }

    public void stop() {
        this.pather.stop();
        this.entity.setPathfindingMalus(PathType.WATER, this.waterCost);
    }

    public void tick() {
        if (this.timeToRecalcPath-- > 0) {
            return;
        }
        this.timeToRecalcPath = (Integer)HordeEventConfig.hordePathingInterval.get();
        this.pather = this.entity.getNavigation();
        this.pather.moveTo(this.target, this.speed);
    }
}

