/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.capability;

import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.player.Player;
import net.neoforged.bus.api.Event;
import net.neoforged.neoforge.common.NeoForge;
import net.smileycorp.hordes.common.entities.HordesEntities;
import net.smileycorp.hordes.common.entities.PlayerZombie;
import net.smileycorp.hordes.common.event.SpawnZombiePlayerEvent;

public interface ZombifyPlayer {
    public PlayerZombie createZombie();

    public PlayerZombie getZombie();

    public void clearZombie();

    public boolean wasZombified();

    public static class Impl
    implements ZombifyPlayer {
        private final Player player;
        private PlayerZombie zombie = null;

        public Impl(Player player) {
            this.player = player;
        }

        @Override
        public PlayerZombie createZombie() {
            HordesEntities.ZOMBIE_PLAYER.get();
            SpawnZombiePlayerEvent event = new SpawnZombiePlayerEvent(this.player, (EntityType<? extends PlayerZombie>)((EntityType)HordesEntities.ZOMBIE_PLAYER.get()));
            NeoForge.EVENT_BUS.post((Event)event);
            if (event.isCanceled()) {
                return null;
            }
            EntityType<? extends PlayerZombie> type = event.getEntityType();
            this.zombie = (PlayerZombie)type.create(this.player.level());
            this.zombie.setPlayer(this.player);
            this.zombie.asEntity().setPos(this.player.getX(), this.player.getY(), this.player.getZ());
            ((Mob)this.zombie.asEntity()).yBodyRotO = this.player.yBodyRotO;
            return this.zombie;
        }

        @Override
        public PlayerZombie getZombie() {
            return this.zombie;
        }

        @Override
        public void clearZombie() {
            this.zombie = null;
        }

        @Override
        public boolean wasZombified() {
            return this.zombie != null;
        }
    }
}

