/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.command;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.arguments.coordinates.Vec3Argument;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.server.command.EnumArgument;
import net.smileycorp.hordes.common.entities.HordesEntities;
import net.smileycorp.hordes.common.entities.PlayerZombie;

public class CommandSpawnZombie {
    public static void register(LiteralArgumentBuilder<CommandSourceStack> command) {
        command.then(((LiteralArgumentBuilder)Commands.literal((String)"spawnZombie").requires(commandSource -> commandSource.hasPermission(1))).then(Commands.argument((String)"username", (ArgumentType)StringArgumentType.string()).then(((RequiredArgumentBuilder)Commands.argument((String)"pos", (ArgumentType)Vec3Argument.vec3()).executes(CommandSpawnZombie::execute)).then(Commands.argument((String)"type", (ArgumentType)EnumArgument.enumArgument(Type.class)).executes(CommandSpawnZombie::execute)))));
    }

    public static int execute(CommandContext<CommandSourceStack> ctx) throws CommandSyntaxException {
        ServerLevel level = ((CommandSourceStack)ctx.getSource()).getLevel();
        String player = StringArgumentType.getString(ctx, (String)"username");
        Vec3 pos = Vec3Argument.getVec3(ctx, (String)"pos");
        Type type = Type.ZOMBIE;
        try {
            type = (Type)((Object)ctx.getArgument("type", Type.class));
        }
        catch (Exception exception) {
            // empty catch block
        }
        PlayerZombie zombie = type.create(level);
        zombie.setPlayer(player);
        zombie.asEntity().setPos(pos);
        level.addFreshEntity(zombie.asEntity());
        return 1;
    }

    private static enum Type {
        ZOMBIE((EntityType<? extends PlayerZombie>)((EntityType)HordesEntities.ZOMBIE_PLAYER.get())),
        DROWNED((EntityType<? extends PlayerZombie>)((EntityType)HordesEntities.DROWNED_PLAYER.get())),
        HUSK((EntityType<? extends PlayerZombie>)((EntityType)HordesEntities.HUSK_PLAYER.get()));

        private final EntityType<? extends PlayerZombie> type;

        private Type(EntityType<? extends PlayerZombie> type) {
            this.type = type;
        }

        private PlayerZombie create(ServerLevel level) {
            return (PlayerZombie)this.type.create((Level)level);
        }
    }
}

