/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.common.entities;

import com.mojang.authlib.GameProfile;
import java.util.Collection;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.core.HolderLookup;
import net.minecraft.core.NonNullList;
import net.minecraft.core.component.DataComponentType;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.ComponentContents;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.contents.PlainTextContents;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.Difficulty;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Drowned;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.enchantment.EnchantmentEffectComponents;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.Level;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;
import net.neoforged.neoforge.server.ServerLifecycleHooks;
import net.smileycorp.hordes.common.entities.HordesEntities;
import net.smileycorp.hordes.common.entities.PlayerZombie;
import net.smileycorp.hordes.config.ZombiePlayersConfig;

public class DrownedPlayer
extends Drowned
implements PlayerZombie<DrownedPlayer> {
    protected static final EntityDataAccessor<Optional<UUID>> PLAYER = SynchedEntityData.defineId(DrownedPlayer.class, (EntityDataSerializer)EntityDataSerializers.OPTIONAL_UUID);
    protected static final EntityDataAccessor<Boolean> SHOW_CAPE = SynchedEntityData.defineId(DrownedPlayer.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    protected NonNullList<ItemStack> playerItems = NonNullList.create();
    public double xCloakO;
    public double yCloakO;
    public double zCloakO;
    public double xCloak;
    public double yCloak;
    public double zCloak;

    public DrownedPlayer(EntityType<? extends DrownedPlayer> type, Level level) {
        super(type, level);
    }

    public DrownedPlayer(Level level) {
        this((EntityType<? extends DrownedPlayer>)((EntityType)HordesEntities.DROWNED_PLAYER.get()), level);
    }

    public DrownedPlayer(Player player) {
        this(player.level());
        this.setPlayer(player);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(PLAYER, Optional.empty());
        builder.define(SHOW_CAPE, (Object)true);
    }

    @Override
    public void setPlayer(Player player) {
        if (player == null) {
            return;
        }
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = slot.getType() == EquipmentSlot.Type.HUMANOID_ARMOR ? (ItemStack)player.getInventory().armor.get(slot.getIndex()) : (slot == EquipmentSlot.MAINHAND ? player.getMainHandItem() : player.getOffhandItem());
            this.setItemSlot(slot, stack);
        }
        this.setPlayer(player.getGameProfile());
    }

    @Override
    public void setPlayer(String username) {
        Optional optional = ServerLifecycleHooks.getCurrentServer().getProfileCache().get(username);
        if (optional.isPresent()) {
            this.setPlayer((GameProfile)optional.get());
        }
    }

    @Override
    public void setPlayer(UUID uuid) {
        Optional optional = ServerLifecycleHooks.getCurrentServer().getProfileCache().get(uuid);
        if (optional.isPresent()) {
            this.setPlayer((GameProfile)optional.get());
        }
    }

    @Override
    public void setPlayer(GameProfile profile) {
        if (profile == null) {
            return;
        }
        if (profile.getName() == null) {
            this.setCustomName((Component)MutableComponent.create((ComponentContents)new PlainTextContents.LiteralContents(profile.getName())));
        }
        this.entityData.set(PLAYER, Optional.of(profile.getId()));
    }

    @Override
    public Optional<UUID> getPlayerUUID() {
        return (Optional)this.entityData.get(PLAYER);
    }

    @Override
    public void storeDrops(Collection<ItemEntity> list) {
        this.playerItems.clear();
        for (ItemEntity item : list) {
            ItemStack stack = item.getItem();
            item.remove(Entity.RemovalReason.DISCARDED);
            if (stack == null) continue;
            this.playerItems.add((Object)stack.copy());
        }
    }

    @Override
    public void setInventory(NonNullList<ItemStack> list) {
        this.playerItems.clear();
        this.playerItems.addAll(list);
    }

    @Override
    public NonNullList<ItemStack> getInventory() {
        return this.playerItems;
    }

    protected void dropCustomDeathLoot(ServerLevel level, DamageSource source, boolean recentlyHitIn) {
        for (ItemStack stack : this.playerItems) {
            if (!(!stack.isEmpty() & !EnchantmentHelper.has((ItemStack)stack, (DataComponentType)EnchantmentEffectComponents.PREVENT_EQUIPMENT_DROP))) continue;
            this.spawnAtLocation(stack, 0.0f);
        }
    }

    public void remove(Entity.RemovalReason reason) {
        if (reason == Entity.RemovalReason.DISCARDED && this.level() instanceof ServerLevel && this.level().getDifficulty() == Difficulty.PEACEFUL && this.shouldDespawnInPeaceful()) {
            this.dropCustomDeathLoot((ServerLevel)this.level(), null, false);
        }
        super.remove(reason);
    }

    public boolean shouldDespawnInPeaceful() {
        return this.playerItems.isEmpty() || (Boolean)ZombiePlayersConfig.zombiePlayersDespawnPeaceful.get() != false;
    }

    public boolean isSunSensitive() {
        return (Boolean)ZombiePlayersConfig.zombiePlayersBurn.get();
    }

    public boolean fireImmune() {
        return (Boolean)ZombiePlayersConfig.zombiePlayersFireImmune.get();
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        Optional optional = (Optional)this.entityData.get(PLAYER);
        if (optional.isPresent()) {
            compound.putUUID("player", (UUID)optional.get());
        }
        ContainerHelper.saveAllItems((CompoundTag)compound, this.playerItems, (HolderLookup.Provider)this.level().registryAccess());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("player")) {
            this.entityData.set(PLAYER, Optional.of(compound.getUUID("player")));
        }
        NonNullList read = NonNullList.withSize((int)compound.getList("Items", 10).size(), (Object)ItemStack.EMPTY);
        ContainerHelper.loadAllItems((CompoundTag)compound, (NonNullList)read, (HolderLookup.Provider)this.level().registryAccess());
        this.playerItems = read;
    }

    public MutableComponent getDisplayName() {
        MutableComponent component = PlayerTeam.formatNameForTeam((Team)this.getTeam(), (Component)Component.translatable((String)"entity.hordes.DrownedPlayer.chat", (Object[])new Object[]{this.getCustomName()}));
        component.getStyle().withHoverEvent(this.createHoverEvent());
        component.getStyle().withInsertion(this.getEncodeId());
        return component;
    }

    @Override
    public void copyFrom(PlayerZombie entity) {
        Optional<UUID> optional = entity.getPlayerUUID();
        if (optional.isPresent()) {
            this.setPlayer(optional.get());
        }
        this.setInventory(entity.getInventory());
        for (EquipmentSlot slot : EquipmentSlot.values()) {
            ItemStack stack = ((Mob)entity).getItemBySlot(slot);
            this.setItemSlot(slot, stack);
        }
        this.entityData.set(SHOW_CAPE, (Object)entity.displayCape());
    }

    public void tick() {
        super.tick();
        this.moveCloak((Zombie)this);
    }

    @Override
    public boolean displayCape() {
        return (Boolean)this.entityData.get(SHOW_CAPE);
    }

    @Override
    public void setDisplayCape(boolean display) {
        this.entityData.set(SHOW_CAPE, (Object)display);
    }

    @Override
    public double getXCloakO() {
        return this.xCloakO;
    }

    @Override
    public double getYCloakO() {
        return this.yCloakO;
    }

    @Override
    public double getZCloakO() {
        return this.zCloakO;
    }

    @Override
    public double getXCloak() {
        return this.xCloak;
    }

    @Override
    public double getYCloak() {
        return this.yCloak;
    }

    @Override
    public double getZCloak() {
        return this.zCloak;
    }

    @Override
    public void setXCloakO(double value) {
        this.xCloakO = value;
    }

    @Override
    public void setYCloakO(double value) {
        this.yCloakO = value;
    }

    @Override
    public void setZCloakO(double value) {
        this.zCloakO = value;
    }

    @Override
    public void setXCloak(double value) {
        this.xCloak = value;
    }

    @Override
    public void setYCloak(double value) {
        this.yCloak = value;
    }

    @Override
    public void setZCloak(double value) {
        this.zCloak = value;
    }
}

