/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.data.values;

import com.google.gson.JsonObject;
import net.smileycorp.atlas.api.data.BinaryOperation;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.hordeevent.data.values.ValueGetter;

public class BinaryOperationValueGetter<T extends Number>
implements ValueGetter<T> {
    private final BinaryOperation operation;
    private final ValueGetter<T> value1;
    private final ValueGetter<T> value2;

    private BinaryOperationValueGetter(BinaryOperation operation, ValueGetter<T> value1, ValueGetter<T> value2) {
        this.operation = operation;
        this.value1 = value1;
        this.value2 = value2;
    }

    @Override
    public T get(HordePlayerEvent event) {
        return (T)this.operation.apply(this.value1.get(event), this.value2.get(event));
    }

    public static <T extends Number> BinaryOperationValueGetter deserialize(BinaryOperation operation, DataType<T> type, JsonObject element) {
        ValueGetter<T> getter1 = ValueGetter.readValue(type, element.get("value1"));
        ValueGetter<T> getter2 = ValueGetter.readValue(type, element.get("value2"));
        if (getter1 == null || getter2 == null | !type.isNumber()) {
            HordesLogger.logError("invalid values for hordes:" + operation.getName(), new NullPointerException());
            return null;
        }
        return new BinaryOperationValueGetter<T>(operation, getter1, getter2);
    }
}

