/*
 * Decompiled with CFR 0.152.
 */
package net.smileycorp.hordes.hordeevent.data.values;

import com.google.gson.JsonObject;
import net.smileycorp.atlas.api.data.DataType;
import net.smileycorp.atlas.api.data.UnaryOperation;
import net.smileycorp.hordes.common.HordesLogger;
import net.smileycorp.hordes.common.event.HordePlayerEvent;
import net.smileycorp.hordes.hordeevent.data.values.ValueGetter;

public class UnaryOperationValueGetter<T extends Number>
implements ValueGetter<T> {
    private final UnaryOperation operation;
    private final ValueGetter<T> value;

    private UnaryOperationValueGetter(UnaryOperation operation, ValueGetter<T> value) {
        this.operation = operation;
        this.value = value;
    }

    @Override
    public T get(HordePlayerEvent event) {
        return (T)this.operation.apply(this.value.get(event));
    }

    public static <T extends Number> UnaryOperationValueGetter deserialize(UnaryOperation operation, DataType<T> type, JsonObject element) {
        ValueGetter<T> getter = ValueGetter.readValue(type, element.get("value"));
        if (getter == null | !type.isNumber()) {
            HordesLogger.logError("invalid value for hordes:" + operation.getName(), new NullPointerException());
            return null;
        }
        return new UnaryOperationValueGetter<T>(operation, getter);
    }
}

