/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.lang.reflect.Method;
import net.arphex.entity.SpiderLarvaeTinyEntity;
import net.arphex.entity.layer.SpiderLarvaeTinyLayer;
import net.arphex.entity.model.SpiderLarvaeTinyModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.phys.Vec3;
import org.joml.Matrix3f;
import org.joml.Matrix3fc;
import org.joml.Quaternionf;
import org.joml.Vector3f;
import org.joml.Vector3fc;
import software.bernie.geckolib.cache.object.BakedGeoModel;
import software.bernie.geckolib.model.GeoModel;
import software.bernie.geckolib.renderer.GeoEntityRenderer;
import software.bernie.geckolib.renderer.GeoRenderer;

public class SpiderLarvaeTinyRenderer
extends GeoEntityRenderer<SpiderLarvaeTinyEntity> {
    private static final float MODEL_FORWARD_YAW_OFFSET = 90.0f;
    private static Boolean isNyfsSpidersLoaded = null;
    private static Class<?> iClimberEntityClass;
    private static Class<?> orientationClass;
    private static Method getRenderOrientationMethod;
    private static Method getOrientationMethod;
    private float debugYaw = 0.0f;

    public SpiderLarvaeTinyRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager, (GeoModel)new SpiderLarvaeTinyModel());
        this.shadowRadius = 0.1f;
        this.addRenderLayer(new SpiderLarvaeTinyLayer((GeoRenderer<SpiderLarvaeTinyEntity>)this));
    }

    public RenderType getRenderType(SpiderLarvaeTinyEntity animatable, ResourceLocation texture, MultiBufferSource bufferSource, float partialTick) {
        return RenderType.entityTranslucent((ResourceLocation)this.getTextureLocation((Entity)animatable));
    }

    protected void applyRotations(SpiderLarvaeTinyEntity entity, PoseStack poseStack, float ageInTicks, float rotationYaw, float partialTick) {
    }

    public void preRender(PoseStack poseStack, SpiderLarvaeTinyEntity entity, BakedGeoModel model, MultiBufferSource bufferSource, VertexConsumer buffer, boolean isReRender, float partialTick, int packedLight, int packedOverlay, int color) {
        float scale;
        this.scaleHeight = scale = 0.6f;
        this.scaleWidth = scale;
        if (!isReRender && isNyfsSpidersLoaded.booleanValue()) {
            this.tryNyfsRotation(entity, poseStack, partialTick);
        }
        super.preRender(poseStack, (Entity)entity, model, bufferSource, buffer, isReRender, partialTick, packedLight, packedOverlay, color);
    }

    private boolean isOnCeiling(Vec3 normal) {
        return normal.y < (double)-0.92f;
    }

    private boolean tryNyfsRotation(SpiderLarvaeTinyEntity entity, PoseStack poseStack, float partialTick) {
        try {
            if (!iClimberEntityClass.isInstance((Object)entity)) {
                return false;
            }
            Object climberEntity = iClimberEntityClass.cast((Object)entity);
            Object orientationObj = this.getOrientationObject(climberEntity);
            if (orientationObj == null) {
                return false;
            }
            Vec3 normal = (Vec3)orientationClass.getField("normal").get(orientationObj);
            boolean onCeiling = this.isOnCeiling(normal);
            float entityYaw = Mth.lerp((float)partialTick, (float)entity.yRotO, (float)entity.getYRot());
            float pitch = Mth.lerp((float)partialTick, (float)entity.xRotO, (float)entity.getXRot());
            this.debugYaw = 0.0f;
            if (onCeiling) {
                this.debugYaw += 180.0f;
            }
            Vec3 head = Vec3.directionFromRotation((float)pitch, (float)this.debugYaw);
            Vector3f up = new Vector3f((float)normal.x, (float)normal.y, (float)normal.z).normalize();
            Vector3f forward = new Vector3f((float)head.x, (float)head.y, (float)head.z).normalize();
            boolean isNorthSouthWall = Math.abs(normal.z) > Math.max(Math.abs(normal.x), Math.abs(normal.y));
            Quaternionf wallAdjustment = new Quaternionf();
            if (isNorthSouthWall) {
                wallAdjustment.rotateY((float)Math.toRadians(-90.0));
                wallAdjustment.transform(forward);
                wallAdjustment.identity();
            }
            Vector3f right = new Vector3f();
            up.cross((Vector3fc)forward, right);
            right.normalize();
            up.cross((Vector3fc)right, forward);
            forward.normalize();
            if (isNorthSouthWall) {
                Quaternionf compensation = new Quaternionf().rotateAxis((float)Math.toRadians(90.0), (Vector3fc)new Vector3f(up.x, up.y, up.z));
                compensation.transform(right);
                compensation.transform(forward);
            }
            Matrix3f rotMatrix = new Matrix3f(right.x, right.y, right.z, up.x, up.y, up.z, -forward.x, -forward.y, -forward.z);
            Quaternionf finalRotation = new Quaternionf().setFromNormalized((Matrix3fc)rotMatrix);
            float visualScale = 0.6f;
            float halfVisualHeight = visualScale / 2.0f;
            float inverseScale = 1.0f / visualScale;
            float WALL_OFFSET_MULTIPLIER = 0.45f;
            float CEILING_OFFSET_BOOST = 1.2f;
            float offsetAmount = visualScale * 0.45f;
            if (this.isOnCeiling(normal)) {
                offsetAmount *= 1.2f;
            }
            poseStack.translate(normal.x * (double)offsetAmount, normal.y * (double)offsetAmount + (double)(halfVisualHeight * inverseScale), normal.z * (double)offsetAmount);
            poseStack.mulPose(finalRotation);
            poseStack.translate(-normal.x * (double)offsetAmount, -(normal.y * (double)offsetAmount) - (double)(halfVisualHeight * inverseScale), -normal.z * (double)offsetAmount);
            return true;
        }
        catch (Exception e) {
            System.err.println("Nyf's Spiders: Error applying rotation: " + e.getMessage());
            e.printStackTrace();
            return false;
        }
    }

    private Object getOrientationObject(Object climberEntity) throws Exception {
        if (getOrientationMethod != null) {
            return getOrientationMethod.invoke(climberEntity, new Object[0]);
        }
        return null;
    }

    static {
        try {
            iClimberEntityClass = Class.forName("com.nyfaria.nyfsspiders.common.entity.mob.IClimberEntity");
            orientationClass = Class.forName("com.nyfaria.nyfsspiders.common.entity.mob.Orientation");
            isNyfsSpidersLoaded = true;
            try {
                getRenderOrientationMethod = iClimberEntityClass.getMethod("getRenderOrientation", new Class[0]);
                System.out.println("Nyf's Spiders: getRenderOrientation method found.");
            }
            catch (NoSuchMethodException e) {
                System.out.println("Nyf's Spiders: getRenderOrientation method not found. Will fall back to normal vector calculation.");
            }
            try {
                getOrientationMethod = iClimberEntityClass.getMethod("getOrientation", new Class[0]);
                System.out.println("Nyf's Spiders: getOrientation method found.");
            }
            catch (NoSuchMethodException e) {
                System.out.println("Nyf's Spiders: getOrientation method not found. Cannot retrieve orientation data.");
            }
        }
        catch (ClassNotFoundException e) {
            isNyfsSpidersLoaded = false;
            System.out.println("Nyf's Spiders mod not found. Skipping Nyf's specific rendering.");
        }
    }
}

