/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.entity;

import net.arphex.procedures.ConstrictingUpwardsProcedure;
import net.arphex.procedures.CrabConstrictorEntityDiesProcedure;
import net.arphex.procedures.CrabConstrictorOnEntityTickUpdateProcedure;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.damagesource.DamageTypes;
import net.minecraft.world.entity.AreaEffectCloud;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityDimensions;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.LookAtPlayerGoal;
import net.minecraft.world.entity.ai.goal.MeleeAttackGoal;
import net.minecraft.world.entity.ai.goal.RandomStrollGoal;
import net.minecraft.world.entity.ai.goal.RandomSwimmingGoal;
import net.minecraft.world.entity.ai.goal.TryFindWaterGoal;
import net.minecraft.world.entity.ai.goal.target.HurtByTargetGoal;
import net.minecraft.world.entity.ai.goal.target.NearestAttackableTargetGoal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.projectile.ThrownPotion;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.neoforge.common.NeoForgeMod;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class CrabConstrictorEntity
extends Monster
implements GeoEntity {
    public static final EntityDataAccessor<Boolean> SHOOT = SynchedEntityData.defineId(CrabConstrictorEntity.class, (EntityDataSerializer)EntityDataSerializers.BOOLEAN);
    public static final EntityDataAccessor<String> ANIMATION = SynchedEntityData.defineId(CrabConstrictorEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<String> TEXTURE = SynchedEntityData.defineId(CrabConstrictorEntity.class, (EntityDataSerializer)EntityDataSerializers.STRING);
    public static final EntityDataAccessor<Integer> DATA_grabbingtime = SynchedEntityData.defineId(CrabConstrictorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    public static final EntityDataAccessor<Integer> DATA_grabwait = SynchedEntityData.defineId(CrabConstrictorEntity.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private boolean swinging;
    private boolean lastloop;
    private long lastSwing;
    public String animationprocedure = "empty";
    String prevAnim = "empty";

    public CrabConstrictorEntity(EntityType<CrabConstrictorEntity> type, Level world) {
        super(type, world);
        this.xpReward = 3;
        this.setNoAi(false);
        this.setPersistenceRequired();
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        super.defineSynchedData(builder);
        builder.define(SHOOT, (Object)false);
        builder.define(ANIMATION, (Object)"undefined");
        builder.define(TEXTURE, (Object)"crabconstrictor");
        builder.define(DATA_grabbingtime, (Object)0);
        builder.define(DATA_grabwait, (Object)0);
    }

    public void setTexture(String texture) {
        this.entityData.set(TEXTURE, (Object)texture);
    }

    public String getTexture() {
        return (String)this.entityData.get(TEXTURE);
    }

    protected void registerGoals() {
        super.registerGoals();
        this.goalSelector.addGoal(1, (Goal)new MeleeAttackGoal((PathfinderMob)this, 0.5, false){

            protected boolean canPerformAttack(LivingEntity entity) {
                return this.isTimeToAttack() && this.mob.distanceToSqr((Entity)entity) < 169.0 && this.mob.getSensing().hasLineOfSight((Entity)entity);
            }

            public boolean canUse() {
                double x = CrabConstrictorEntity.this.getX();
                double y = CrabConstrictorEntity.this.getY();
                double z = CrabConstrictorEntity.this.getZ();
                CrabConstrictorEntity entity = CrabConstrictorEntity.this;
                Level world = CrabConstrictorEntity.this.level();
                return super.canUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrabConstrictorEntity.this.getX();
                double y = CrabConstrictorEntity.this.getY();
                double z = CrabConstrictorEntity.this.getZ();
                CrabConstrictorEntity entity = CrabConstrictorEntity.this;
                Level world = CrabConstrictorEntity.this.level();
                return super.canContinueToUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }
        });
        this.targetSelector.addGoal(2, (Goal)new NearestAttackableTargetGoal((Mob)this, Player.class, false, false));
        this.targetSelector.addGoal(3, (Goal)new HurtByTargetGoal((PathfinderMob)this, new Class[0]){

            public boolean canUse() {
                double x = CrabConstrictorEntity.this.getX();
                double y = CrabConstrictorEntity.this.getY();
                double z = CrabConstrictorEntity.this.getZ();
                CrabConstrictorEntity entity = CrabConstrictorEntity.this;
                Level world = CrabConstrictorEntity.this.level();
                return super.canUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrabConstrictorEntity.this.getX();
                double y = CrabConstrictorEntity.this.getY();
                double z = CrabConstrictorEntity.this.getZ();
                CrabConstrictorEntity entity = CrabConstrictorEntity.this;
                Level world = CrabConstrictorEntity.this.level();
                return super.canContinueToUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }
        }.setAlertOthers(new Class[0]));
        this.goalSelector.addGoal(4, (Goal)new LookAtPlayerGoal((Mob)this, Player.class, 60.0f));
        this.goalSelector.addGoal(5, (Goal)new RandomSwimmingGoal((PathfinderMob)this, 2.0, 40){

            public boolean canUse() {
                double x = CrabConstrictorEntity.this.getX();
                double y = CrabConstrictorEntity.this.getY();
                double z = CrabConstrictorEntity.this.getZ();
                CrabConstrictorEntity entity = CrabConstrictorEntity.this;
                Level world = CrabConstrictorEntity.this.level();
                return super.canUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrabConstrictorEntity.this.getX();
                double y = CrabConstrictorEntity.this.getY();
                double z = CrabConstrictorEntity.this.getZ();
                CrabConstrictorEntity entity = CrabConstrictorEntity.this;
                Level world = CrabConstrictorEntity.this.level();
                return super.canContinueToUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(6, (Goal)new RandomStrollGoal((PathfinderMob)this, 1.0){

            public boolean canUse() {
                double x = CrabConstrictorEntity.this.getX();
                double y = CrabConstrictorEntity.this.getY();
                double z = CrabConstrictorEntity.this.getZ();
                CrabConstrictorEntity entity = CrabConstrictorEntity.this;
                Level world = CrabConstrictorEntity.this.level();
                return super.canUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }

            public boolean canContinueToUse() {
                double x = CrabConstrictorEntity.this.getX();
                double y = CrabConstrictorEntity.this.getY();
                double z = CrabConstrictorEntity.this.getZ();
                CrabConstrictorEntity entity = CrabConstrictorEntity.this;
                Level world = CrabConstrictorEntity.this.level();
                return super.canContinueToUse() && ConstrictingUpwardsProcedure.execute((Entity)entity);
            }
        });
        this.goalSelector.addGoal(7, (Goal)new TryFindWaterGoal((PathfinderMob)this));
    }

    public boolean removeWhenFarAway(double distanceToClosestPlayer) {
        return false;
    }

    public SoundEvent getHurtSound(DamageSource ds) {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"arphex:creepy_arthropod_large"));
    }

    public SoundEvent getDeathSound() {
        return (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"arphex:creepy_arthropod_large"));
    }

    public boolean hurt(DamageSource source, float amount) {
        if (source.is(DamageTypes.IN_FIRE)) {
            return false;
        }
        if (source.getDirectEntity() instanceof ThrownPotion || source.getDirectEntity() instanceof AreaEffectCloud || source.typeHolder().is(NeoForgeMod.POISON_DAMAGE)) {
            return false;
        }
        if (source.is(DamageTypes.FALL)) {
            return false;
        }
        if (source.is(DamageTypes.CACTUS)) {
            return false;
        }
        if (source.is(DamageTypes.DROWN)) {
            return false;
        }
        if (source.is(DamageTypes.EXPLOSION) || source.is(DamageTypes.PLAYER_EXPLOSION)) {
            return false;
        }
        if (source.is(DamageTypes.WITHER) || source.is(DamageTypes.WITHER_SKULL)) {
            return false;
        }
        return super.hurt(source, amount);
    }

    public boolean ignoreExplosion(Explosion explosion) {
        return true;
    }

    public boolean fireImmune() {
        return true;
    }

    public void die(DamageSource source) {
        super.die(source);
        CrabConstrictorEntityDiesProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ());
    }

    public void addAdditionalSaveData(CompoundTag compound) {
        super.addAdditionalSaveData(compound);
        compound.putString("Texture", this.getTexture());
        compound.putInt("Datagrabbingtime", ((Integer)this.entityData.get(DATA_grabbingtime)).intValue());
        compound.putInt("Datagrabwait", ((Integer)this.entityData.get(DATA_grabwait)).intValue());
    }

    public void readAdditionalSaveData(CompoundTag compound) {
        super.readAdditionalSaveData(compound);
        if (compound.contains("Texture")) {
            this.setTexture(compound.getString("Texture"));
        }
        if (compound.contains("Datagrabbingtime")) {
            this.entityData.set(DATA_grabbingtime, (Object)compound.getInt("Datagrabbingtime"));
        }
        if (compound.contains("Datagrabwait")) {
            this.entityData.set(DATA_grabwait, (Object)compound.getInt("Datagrabwait"));
        }
    }

    public void baseTick() {
        super.baseTick();
        CrabConstrictorOnEntityTickUpdateProcedure.execute((LevelAccessor)this.level(), this.getX(), this.getY(), this.getZ(), (Entity)this);
        this.refreshDimensions();
    }

    public EntityDimensions getDefaultDimensions(Pose pose) {
        return super.getDefaultDimensions(pose).scale(1.99f);
    }

    public static void init(RegisterSpawnPlacementsEvent event) {
    }

    public static AttributeSupplier.Builder createAttributes() {
        AttributeSupplier.Builder builder = Mob.createMobAttributes();
        builder = builder.add(Attributes.MOVEMENT_SPEED, 0.5);
        builder = builder.add(Attributes.MAX_HEALTH, 300.0);
        builder = builder.add(Attributes.ARMOR, 20.0);
        builder = builder.add(Attributes.ATTACK_DAMAGE, 16.0);
        builder = builder.add(Attributes.FOLLOW_RANGE, 150.0);
        builder = builder.add(Attributes.STEP_HEIGHT, 0.6);
        builder = builder.add(Attributes.KNOCKBACK_RESISTANCE, 1.0);
        builder = builder.add(Attributes.ATTACK_KNOCKBACK, 0.2);
        return builder;
    }

    private PlayState movementPredicate(AnimationState event) {
        if (this.animationprocedure.equals("empty")) {
            if (!(!event.isMoving() && event.getLimbSwingAmount() > -0.15f && event.getLimbSwingAmount() < 0.15f || this.isSprinting())) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.crabconstrictor.scurrying"));
            }
            if (this.isDeadOrDying()) {
                return event.setAndContinue(RawAnimation.begin().thenPlay("animation.crabconstrictor.death"));
            }
            if (this.isShiftKeyDown()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.crabconstrictor.grabbing"));
            }
            if (this.isSprinting()) {
                return event.setAndContinue(RawAnimation.begin().thenLoop("animation.crabconstrictor.grabbingup"));
            }
            return event.setAndContinue(RawAnimation.begin().thenLoop("animation.crabconstrictor.idle"));
        }
        return PlayState.STOP;
    }

    private PlayState attackingPredicate(AnimationState event) {
        double d1 = this.getX() - this.xOld;
        double d0 = this.getZ() - this.zOld;
        float velocity = (float)Math.sqrt(d1 * d1 + d0 * d0);
        if (this.getAttackAnim(event.getPartialTick()) > 0.0f && !this.swinging) {
            this.swinging = true;
            this.lastSwing = this.level().getGameTime();
        }
        if (this.swinging && this.lastSwing + 7L <= this.level().getGameTime()) {
            this.swinging = false;
        }
        if (this.swinging && event.getController().getAnimationState() == AnimationController.State.STOPPED) {
            event.getController().forceAnimationReset();
            return event.setAndContinue(RawAnimation.begin().thenPlay("animation.crabconstrictor.attack"));
        }
        return PlayState.CONTINUE;
    }

    private PlayState procedurePredicate(AnimationState event) {
        if (!this.animationprocedure.equals("empty") && event.getController().getAnimationState() == AnimationController.State.STOPPED || !this.animationprocedure.equals(this.prevAnim) && !this.animationprocedure.equals("empty")) {
            if (!this.animationprocedure.equals(this.prevAnim)) {
                event.getController().forceAnimationReset();
            }
            event.getController().setAnimation(RawAnimation.begin().thenPlay(this.animationprocedure));
            if (event.getController().getAnimationState() == AnimationController.State.STOPPED) {
                this.animationprocedure = "empty";
                event.getController().forceAnimationReset();
            }
        } else if (this.animationprocedure.equals("empty")) {
            this.prevAnim = "empty";
            return PlayState.STOP;
        }
        this.prevAnim = this.animationprocedure;
        return PlayState.CONTINUE;
    }

    protected void tickDeath() {
        ++this.deathTime;
        if (this.deathTime == 90) {
            this.remove(Entity.RemovalReason.KILLED);
            this.dropExperience((Entity)this);
        }
    }

    public String getSyncedAnimation() {
        return (String)this.entityData.get(ANIMATION);
    }

    public void setAnimation(String animation) {
        this.entityData.set(ANIMATION, (Object)animation);
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar data) {
        data.add(new AnimationController((GeoAnimatable)this, "movement", 20, this::movementPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "attacking", 20, this::attackingPredicate));
        data.add(new AnimationController((GeoAnimatable)this, "procedure", 20, this::procedurePredicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }
}

