/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.init;

import net.arphex.network.PowerBindMessage;
import net.arphex.network.SpacePressMessage;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.entity.player.Player;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.ClientTickEvent;
import net.neoforged.neoforge.client.event.RegisterKeyMappingsEvent;
import net.neoforged.neoforge.network.PacketDistributor;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD, value={Dist.CLIENT})
public class ArphexModKeyMappings {
    public static final KeyMapping SPACE_PRESS = new KeyMapping("key.arphex.space_press", 32, "key.categories.movement"){
        private boolean isDownOld = false;

        public void setDown(boolean isDown) {
            super.setDown(isDown);
            if (this.isDownOld != isDown && isDown) {
                PacketDistributor.sendToServer((CustomPacketPayload)new SpacePressMessage(0, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                SpacePressMessage.pressAction((Player)Minecraft.getInstance().player, 0, 0);
                SPACE_PRESS_LASTPRESS = System.currentTimeMillis();
            } else if (this.isDownOld != isDown && !isDown) {
                int dt = (int)(System.currentTimeMillis() - SPACE_PRESS_LASTPRESS);
                PacketDistributor.sendToServer((CustomPacketPayload)new SpacePressMessage(1, dt), (CustomPacketPayload[])new CustomPacketPayload[0]);
                SpacePressMessage.pressAction((Player)Minecraft.getInstance().player, 1, dt);
            }
            this.isDownOld = isDown;
        }
    };
    public static final KeyMapping POWER_BIND = new KeyMapping("key.arphex.power_bind", 67, "key.categories.misc"){
        private boolean isDownOld = false;

        public void setDown(boolean isDown) {
            super.setDown(isDown);
            if (this.isDownOld != isDown && isDown) {
                PacketDistributor.sendToServer((CustomPacketPayload)new PowerBindMessage(0, 0), (CustomPacketPayload[])new CustomPacketPayload[0]);
                PowerBindMessage.pressAction((Player)Minecraft.getInstance().player, 0, 0);
            }
            this.isDownOld = isDown;
        }
    };
    private static long SPACE_PRESS_LASTPRESS = 0L;

    @SubscribeEvent
    public static void registerKeyMappings(RegisterKeyMappingsEvent event) {
        event.register(SPACE_PRESS);
        event.register(POWER_BIND);
    }

    @EventBusSubscriber(value={Dist.CLIENT})
    public static class KeyEventListener {
        @SubscribeEvent
        public static void onClientTick(ClientTickEvent.Post event) {
            if (Minecraft.getInstance().screen == null) {
                SPACE_PRESS.consumeClick();
                POWER_BIND.consumeClick();
            }
        }
    }
}

