/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.item;

import java.util.List;
import net.arphex.procedures.AbyssAscendantEntitySwingsItemProcedure;
import net.arphex.procedures.AbyssAscendantItemInHandTickProcedure;
import net.arphex.procedures.AbyssAscendantItemInInventoryTickProcedure;
import net.arphex.procedures.AbyssAscendantItemIsCraftedsmeltedProcedure;
import net.arphex.procedures.AbyssAscendantRightclickedProcedure;
import net.arphex.procedures.AbyssalBladeHasItemGlowingEffectProcedure;
import net.arphex.procedures.AbyssalBladeLivingEntityIsHitWithItemProcedure;
import net.arphex.procedures.RequiredForAnimProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AbyssAscendantItem
extends Item {
    public AbyssAscendantItem() {
        super(new Item.Properties().stacksTo(1).fireResistant().rarity(Rarity.EPIC).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 27.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public boolean hasCraftingRemainingItem(ItemStack stack) {
        return true;
    }

    public ItemStack getCraftingRemainingItem(ItemStack itemstack) {
        return new ItemStack((ItemLike)this);
    }

    public int getEnchantmentValue() {
        return 30;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 1200;
    }

    public float getDestroySpeed(ItemStack itemstack, BlockState state) {
        return 2.5f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        LocalPlayer entity = Minecraft.getInstance().player;
        return AbyssalBladeHasItemGlowingEffectProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"\u00a74An incredibly powerful weapon beyond the abyssal blade"));
        list.add((Component)Component.literal((String)"- \u00a7cSwings that don't hit an entity or block will fire a projectile"));
        list.add((Component)Component.literal((String)"\u00a77\u00a7lStrongest abilities require at least 1 Tormentor kill"));
        list.add((Component)Component.literal((String)"- \u00a76Provides temporary flight (post-activation) + unlimited low hover powers when held (double jump, sprint)"));
        list.add((Component)Component.literal((String)"- \u00a7ePowerful damage-blocking right-click abilities that slow nearby attackers (post-activation) or power elytra flight"));
        list.add((Component)Component.literal((String)"- \u00a7dGlows when you are being targeted"));
        list.add((Component)Component.literal((String)"Bonus: If dual-wielded, activated flight is unlimited, attacks are stronger, and blocking arc widens"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        AbyssAscendantRightclickedProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity);
        return ar;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        AbyssalBladeLivingEntityIsHitWithItemProcedure.execute((Entity)sourceentity);
        return retval;
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        AbyssAscendantEntitySwingsItemProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
        return retval;
    }

    public void onCraftedBy(ItemStack itemstack, Level world, Player entity) {
        super.onCraftedBy(itemstack, world, entity);
        AbyssAscendantItemIsCraftedsmeltedProcedure.execute((LevelAccessor)world, itemstack);
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            AbyssAscendantItemInHandTickProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity);
        }
        AbyssAscendantItemInInventoryTickProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity, itemstack);
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        RequiredForAnimProcedure.execute();
    }
}

