/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.item;

import java.util.List;
import net.arphex.init.ArphexModItems;
import net.arphex.procedures.AbyssalAxeHeldProcedure;
import net.arphex.procedures.AbyssalAxeRightClickProcedure;
import net.arphex.procedures.AbyssalAxeToolInInventoryTickProcedure;
import net.arphex.procedures.AbyssalBladeHasItemGlowingEffectProcedure;
import net.arphex.procedures.AbyssalPickaxeItemIsCraftedsmeltedProcedure;
import net.arphex.procedures.BlockBroken3Procedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.AxeItem;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.ModifyDefaultComponentsEvent;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class AbyssalAxeItem
extends AxeItem {
    private static final Tier TOOL_TIER = new Tier(){

        public int getUses() {
            return 0;
        }

        public float getSpeed() {
            return 36.0f;
        }

        public float getAttackDamageBonus() {
            return 0.0f;
        }

        public TagKey<Block> getIncorrectBlocksForDrops() {
            return BlockTags.INCORRECT_FOR_NETHERITE_TOOL;
        }

        public int getEnchantmentValue() {
            return 1;
        }

        public Ingredient getRepairIngredient() {
            return Ingredient.of();
        }
    };

    public AbyssalAxeItem() {
        super(TOOL_TIER, new Item.Properties().attributes(DiggerItem.createAttributes((Tier)TOOL_TIER, (float)18.0f, (float)-3.7f)).fireResistant());
    }

    @SubscribeEvent
    public static void handleToolDamage(ModifyDefaultComponentsEvent event) {
        event.modify((ItemLike)ArphexModItems.ABYSSAL_AXE.get(), builder -> builder.remove(DataComponents.MAX_DAMAGE));
    }

    public boolean mineBlock(ItemStack itemstack, Level world, BlockState blockstate, BlockPos pos, LivingEntity entity) {
        boolean retval = super.mineBlock(itemstack, world, blockstate, pos, entity);
        BlockBroken3Procedure.execute((LevelAccessor)world, pos.getX(), pos.getY(), pos.getZ(), (Entity)entity, itemstack);
        return retval;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        AbyssalAxeRightClickProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, itemstack);
        return retval;
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        AbyssalAxeRightClickProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (ItemStack)ar.getObject());
        return ar;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"\u00a75A powerful tool for destroying enemies and blocks"));
        list.add((Component)Component.literal((String)"- Right click to activate double-break ability for 10 seconds"));
        list.add((Component)Component.literal((String)"- \u00a7ePowerful critical hit abilities: Slow, wither, and knock down enemies, along with lifestealing and resetting fall damage - Fall height increases critical hit damage and adds larger AoE withering radius to nearby entities"));
        list.add((Component)Component.literal((String)"- \u00a7dGlows when you are being targeted"));
        list.add((Component)Component.literal((String)"Bonus: Night vision if you have a bane of the darkness and use double-break ability"));
    }

    public void onCraftedBy(ItemStack itemstack, Level world, Player entity) {
        super.onCraftedBy(itemstack, world, entity);
        AbyssalPickaxeItemIsCraftedsmeltedProcedure.execute((LevelAccessor)world, itemstack);
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            AbyssalAxeHeldProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity, itemstack);
        }
        AbyssalAxeToolInInventoryTickProcedure.execute(entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        LocalPlayer entity = Minecraft.getInstance().player;
        return AbyssalBladeHasItemGlowingEffectProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
    }
}

