/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.item;

import java.util.List;
import net.arphex.procedures.AbyssBladeRightClickProcedure;
import net.arphex.procedures.AbyssalBladeEntitySwingsItemProcedure;
import net.arphex.procedures.AbyssalBladeHasItemGlowingEffectProcedure;
import net.arphex.procedures.AbyssalBladeItemInHandTickProcedure;
import net.arphex.procedures.AbyssalBladeItemIsCraftedsmeltedProcedure;
import net.arphex.procedures.AbyssalBladeLivingEntityIsHitWithItemProcedure;
import net.arphex.procedures.AbyssalBladePlayerFinishesUsingItemProcedure;
import net.arphex.procedures.RequiredForAnimProcedure;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class AbyssalBladeItem
extends Item {
    public AbyssalBladeItem() {
        super(new Item.Properties().stacksTo(1).fireResistant().rarity(Rarity.EPIC).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 14.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getEnchantmentValue() {
        return 25;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 1200;
    }

    public float getDestroySpeed(ItemStack itemstack, BlockState state) {
        return 1.5f;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        LocalPlayer entity = Minecraft.getInstance().player;
        return AbyssalBladeHasItemGlowingEffectProcedure.execute((LevelAccessor)entity.level(), entity.getX(), entity.getY(), entity.getZ());
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"\u00a75A sword forged from the darkest depths of the abyss, imbued with the power to combat the nightmarish horrors that lurk beneath the surface"));
        list.add((Component)Component.literal((String)"- \u00a7eAttacks weaken and wither enemies"));
        list.add((Component)Component.literal((String)"- Right click to dodge/block damage and fire a lifesteal projectile, or left click immediately afterward to lunge forwards"));
        list.add((Component)Component.literal((String)"- \u00a7dGlows when you are being targeted"));
        list.add((Component)Component.literal((String)"Bonus: Try combining with other powerful items in offhand for additional powers"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        AbyssBladeRightClickProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), (Entity)entity, (ItemStack)ar.getObject());
        return ar;
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        AbyssalBladePlayerFinishesUsingItemProcedure.execute((Entity)entity);
        return retval;
    }

    public boolean hurtEnemy(ItemStack itemstack, LivingEntity entity, LivingEntity sourceentity) {
        boolean retval = super.hurtEnemy(itemstack, entity, sourceentity);
        AbyssalBladeLivingEntityIsHitWithItemProcedure.execute((Entity)sourceentity);
        return retval;
    }

    public boolean onEntitySwing(ItemStack itemstack, LivingEntity entity, InteractionHand hand) {
        boolean retval = super.onEntitySwing(itemstack, entity, hand);
        AbyssalBladeEntitySwingsItemProcedure.execute((Entity)entity, itemstack);
        return retval;
    }

    public void onCraftedBy(ItemStack itemstack, Level world, Player entity) {
        super.onCraftedBy(itemstack, world, entity);
        AbyssalBladeItemIsCraftedsmeltedProcedure.execute((LevelAccessor)world, itemstack);
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            AbyssalBladeItemInHandTickProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity, itemstack);
        }
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        RequiredForAnimProcedure.execute();
    }
}

