/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.item;

import java.util.List;
import net.arphex.procedures.InfiniteTormentItemInHandTickProcedure;
import net.arphex.procedures.RequiredForAnimProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.state.BlockState;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class InfiniteTormentItem
extends Item {
    public InfiniteTormentItem() {
        super(new Item.Properties().stacksTo(1).fireResistant().rarity(Rarity.EPIC));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 128000;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        return true;
    }

    public boolean isCorrectToolForDrops(ItemStack itemstack, BlockState state) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"\u00a7dAttempts to instantly kill any mob you hit with it, no matter how strong"));
        list.add((Component)Component.literal((String)"- \u00a7aCrouch while hitting to despawn them instead"));
        list.add((Component)Component.literal((String)"- \u00a74Hold right mouse button for AoE percentage-based damage output"));
        list.add((Component)Component.literal((String)"- \u00a76Extreme attack reach"));
        list.add((Component)Component.literal((String)"- \u00a7eInvincible while holding"));
        list.add((Component)Component.literal((String)"\u00a7l\u00a7fObtainable in creative mode only"));
        list.add((Component)Component.literal((String)"\u00a7c\u00a7lINFINITE ATTACK DAMAGE"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        return ar;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            InfiniteTormentItemInHandTickProcedure.execute((LevelAccessor)world, entity.getX(), entity.getY(), entity.getZ(), entity);
        }
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        RequiredForAnimProcedure.execute();
    }
}

