/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.item;

import io.netty.buffer.Unpooled;
import java.util.List;
import net.arphex.procedures.WarpWayfinderItemInHandTickProcedure;
import net.arphex.procedures.WarpWayfinderRightclickedOnBlockProcedure;
import net.arphex.world.inventory.WayfinderMenu;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class WarpWayfinderItem
extends Item {
    public WarpWayfinderItem() {
        super(new Item.Properties().stacksTo(1).rarity(Rarity.EPIC));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"\u00a7dWarp Wayfinder enables you to keep track of up to three positions in the world, and teleport to them when in the same dimension"));
        list.add((Component)Component.literal((String)"- \u00a7aCrouch+Right click a block to add a waypoint at that position"));
        list.add((Component)Component.literal((String)"- \u00a73While held, you will see markers representing the positions of the waypoints"));
        list.add((Component)Component.literal((String)"- \u00a7bRight click in the air to open a menu where you can teleport to markers (10 minute cooldown), label them with items, or delete them"));
        list.add((Component)Component.literal((String)"- While standing still, you can see the item labels assigned to markers"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, final Player entity, final InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        if (entity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            serverPlayer.openMenu(new MenuProvider(){

                public Component getDisplayName() {
                    return Component.literal((String)"Warp Wayfinder");
                }

                public AbstractContainerMenu createMenu(int id, Inventory inventory, Player player) {
                    FriendlyByteBuf packetBuffer = new FriendlyByteBuf(Unpooled.buffer());
                    packetBuffer.writeBlockPos(entity.blockPosition());
                    packetBuffer.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
                    return new WayfinderMenu(id, inventory, packetBuffer);
                }
            }, buf -> {
                buf.writeBlockPos(entity.blockPosition());
                buf.writeByte(hand == InteractionHand.MAIN_HAND ? 0 : 1);
            });
        }
        return ar;
    }

    public InteractionResult useOn(UseOnContext context) {
        super.useOn(context);
        WarpWayfinderRightclickedOnBlockProcedure.execute((LevelAccessor)context.getLevel(), context.getClickedPos().getX(), context.getClickedPos().getY(), context.getClickedPos().getZ(), (Entity)context.getPlayer(), context.getItemInHand());
        return InteractionResult.SUCCESS;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        if (selected) {
            WarpWayfinderItemInHandTickProcedure.execute(entity);
        }
    }
}

