/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.item;

import java.util.List;
import net.arphex.procedures.PlaceholderWarpProcedure;
import net.minecraft.network.chat.Component;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;

public class WarpWayfinderPlaceholderItem
extends Item {
    public WarpWayfinderPlaceholderItem() {
        super(new Item.Properties().stacksTo(64).rarity(Rarity.EPIC));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        return true;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"\u00a7dWarp Wayfinder enables you to keep track of up to three positions in the world, and teleport to them when in the same dimension"));
        list.add((Component)Component.literal((String)"- \u00a7aCrouch+Right click a block to add a waypoint at that position"));
        list.add((Component)Component.literal((String)"- \u00a73While held, you will see markers representing the positions of the waypoints"));
        list.add((Component)Component.literal((String)"- \u00a7bRight click in the air to open a menu where you can teleport to markers (10 minute cooldown), label them with items, or delete them"));
        list.add((Component)Component.literal((String)"- While standing still, you can see the item labels assigned to markers"));
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        PlaceholderWarpProcedure.execute(entity);
    }
}

