/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.network;

import java.util.HashMap;
import net.arphex.ArphexMod;
import net.arphex.procedures.Coord1deleteProcedure;
import net.arphex.procedures.Coord1tpProcedure;
import net.arphex.procedures.Coord2deleteProcedure;
import net.arphex.procedures.Coord2tpProcedure;
import net.arphex.procedures.Coord3deleteProcedure;
import net.arphex.procedures.Coord3tpProcedure;
import net.arphex.world.inventory.WayfinderMenu;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.PacketFlow;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.fml.event.lifecycle.FMLCommonSetupEvent;
import net.neoforged.neoforge.network.handling.IPayloadContext;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public record WayfinderButtonMessage(int buttonID, int x, int y, int z) implements CustomPacketPayload
{
    public static final CustomPacketPayload.Type<WayfinderButtonMessage> TYPE = new CustomPacketPayload.Type(ResourceLocation.fromNamespaceAndPath((String)"arphex", (String)"wayfinder_buttons"));
    public static final StreamCodec<RegistryFriendlyByteBuf, WayfinderButtonMessage> STREAM_CODEC = StreamCodec.of((buffer, message) -> {
        buffer.writeInt(message.buttonID);
        buffer.writeInt(message.x);
        buffer.writeInt(message.y);
        buffer.writeInt(message.z);
    }, buffer -> new WayfinderButtonMessage(buffer.readInt(), buffer.readInt(), buffer.readInt(), buffer.readInt()));

    public CustomPacketPayload.Type<WayfinderButtonMessage> type() {
        return TYPE;
    }

    public static void handleData(WayfinderButtonMessage message, IPayloadContext context) {
        if (context.flow() == PacketFlow.SERVERBOUND) {
            context.enqueueWork(() -> {
                Player entity = context.player();
                int buttonID = message.buttonID;
                int x = message.x;
                int y = message.y;
                int z = message.z;
                WayfinderButtonMessage.handleButtonAction(entity, buttonID, x, y, z);
            }).exceptionally(e -> {
                context.connection().disconnect((Component)Component.literal((String)e.getMessage()));
                return null;
            });
        }
    }

    public static void handleButtonAction(Player entity, int buttonID, int x, int y, int z) {
        Level world = entity.level();
        HashMap<String, Object> guistate = WayfinderMenu.guistate;
        if (!world.hasChunkAt(new BlockPos(x, y, z))) {
            return;
        }
        if (buttonID == 0) {
            Coord1tpProcedure.execute((Entity)entity);
        }
        if (buttonID == 1) {
            Coord1deleteProcedure.execute((Entity)entity);
        }
        if (buttonID == 2) {
            Coord2tpProcedure.execute((Entity)entity);
        }
        if (buttonID == 3) {
            Coord2deleteProcedure.execute((Entity)entity);
        }
        if (buttonID == 4) {
            Coord3tpProcedure.execute((Entity)entity);
        }
        if (buttonID == 5) {
            Coord3deleteProcedure.execute((Entity)entity);
        }
    }

    @SubscribeEvent
    public static void registerMessage(FMLCommonSetupEvent event) {
        ArphexMod.addNetworkMessage(TYPE, STREAM_CODEC, WayfinderButtonMessage::handleData);
    }
}

