/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.procedures;

import net.arphex.init.ArphexModEntities;
import net.minecraft.core.BlockPos;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class HornetHailstormOnPlayerStoppedUsingProcedure {
    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity, ItemStack itemstack) {
        if (entity == null) {
            return;
        }
        if (entity.getPersistentData().getString("hornetlock_uuids").length() > 4) {
            if (entity instanceof Player) {
                Player _player = (Player)entity;
                _player.getCooldowns().addCooldown(itemstack.getItem(), 100);
            }
            if (world instanceof Level) {
                Level _level = (Level)world;
                if (!_level.isClientSide()) {
                    _level.playSound(null, BlockPos.containing((double)x, (double)y, (double)z), (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"arphex:hornetbuzzlong")), SoundSource.NEUTRAL, 1.0f, 0.5f);
                } else {
                    _level.playLocalSound(x, y, z, (SoundEvent)BuiltInRegistries.SOUND_EVENT.get(ResourceLocation.parse((String)"arphex:hornetbuzzlong")), SoundSource.NEUTRAL, 1.0f, 0.5f, false);
                }
            }
            for (int index0 = 0; index0 < 8; ++index0) {
                if (!(world instanceof ServerLevel)) continue;
                ServerLevel _level = (ServerLevel)world;
                Entity entityToSpawn = ((EntityType)ArphexModEntities.HORNET_PROJECTILE.get()).spawn(_level, BlockPos.containing((double)x, (double)y, (double)z), MobSpawnType.MOB_SUMMONED);
                if (entityToSpawn == null) continue;
                entityToSpawn.setYRot(entity.getYRot());
                entityToSpawn.setYBodyRot(entity.getYRot());
                entityToSpawn.setYHeadRot(entity.getYRot());
                entityToSpawn.setXRot(entity.getXRot());
                entityToSpawn.setDeltaMovement(entity.getLookAngle().x * 2.0, entity.getLookAngle().y * 2.0, entity.getLookAngle().z * 2.0);
            }
        } else {
            Player _player;
            if (entity instanceof Player && !(_player = (Player)entity).level().isClientSide()) {
                _player.displayClientMessage((Component)Component.literal((String)"No targets were locked"), true);
            }
            if (entity instanceof Player) {
                _player = (Player)entity;
                _player.getCooldowns().addCooldown(itemstack.getItem(), 5);
            }
        }
    }
}

