/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.procedures;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.arphex.entity.AscendSphereAnimEntity;
import net.arphex.entity.ChronoShotEntity;
import net.arphex.entity.SphereAnimEntity;
import net.arphex.entity.TormentorMothSummonEntity;
import net.arphex.entity.TormentorScorpioidSummonEntity;
import net.arphex.entity.TormentorVoidlasherSummonEntity;
import net.arphex.init.ArphexModItems;
import net.arphex.init.ArphexModMobEffects;
import net.arphex.network.ArphexModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.component.DataComponents;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class RenderTest6Procedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f modelViewMatrix = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.ZERO;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(float x, float y, float z, int color) {
        RenderTest6Procedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(float x, float y, float z, float u, float v, int color) {
        if (bufferBuilder == null) {
            return;
        }
        if (format == DefaultVertexFormat.POSITION_COLOR) {
            bufferBuilder.addVertex(x, y, z).setColor(color);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            bufferBuilder.addVertex(x, y, z).setUv(u, v).setColor(color);
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null) {
            if (update) {
                RenderTest6Procedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.POSITION_COLOR) {
                    RenderTest6Procedure.mode = mode;
                    RenderTest6Procedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_COLOR);
                    return true;
                }
                if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
                    RenderTest6Procedure.mode = mode;
                    RenderTest6Procedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_TEX_COLOR);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        MeshData meshData;
        if (bufferBuilder == null) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        if ((meshData = bufferBuilder.build()) == null) {
            vertexBuffer = null;
            bufferBuilder = null;
        } else {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vertexBuffer.bind();
            vertexBuffer.upload(meshData);
            VertexBuffer.unbind();
            bufferBuilder = null;
        }
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        RenderTest6Procedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            RenderTest6Procedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            i = (float)(x - pos.x());
            j = (float)(y - pos.y());
            k = (float)(z - pos.z());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        poseStack.translate(i, j, k);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(xScale, yScale, zScale);
        poseStack.translate(offset.x(), offset.y(), offset.z());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, vertexBuffer.getFormat().hasUV(0) ? GameRenderer.getPositionTexColorShader() : GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            poseStack = new PoseStack();
            RenderSystem.depthMask((boolean)false);
            RenderTest6Procedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            poseStack = event.getPoseStack();
            RenderSystem.depthMask((boolean)true);
            RenderTest6Procedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (level != null && entity != null) {
            modelViewMatrix = event.getModelViewMatrix();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.getPosition(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderTest6Procedure.execute((Event)event, (LevelAccessor)level, pos.x(), pos.y(), pos.z(), entity);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        RenderTest6Procedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        block177: {
            List<Entity> _entfound;
            Vec3 _center;
            LivingEntity _livEnt;
            LivingEntity _livEnt2;
            LivingEntity _livEnt3;
            double max_entities;
            double amplify;
            double distance;
            double opacity;
            double rotation_from_tormentor;
            double tormentor_distance;
            double col_b;
            double col_g;
            double col_r;
            double spheresize;
            double l;
            double k;
            double j;
            double i;
            block176: {
                Object _wgl;
                Level _lvl;
                ItemStack itemStack;
                double dists;
                double zcalc;
                double ycalc;
                double dist_to_rendered;
                double xcalc;
                ItemStack warp_wayfinder;
                block175: {
                    ItemStack itemStack2;
                    ItemStack itemStack3;
                    if (entity == null) {
                        return;
                    }
                    warp_wayfinder = ItemStack.EMPTY;
                    i = 0.0;
                    j = 0.0;
                    k = 0.0;
                    l = 0.0;
                    spheresize = 0.0;
                    col_r = 0.0;
                    col_g = 0.0;
                    col_b = 0.0;
                    tormentor_distance = 0.0;
                    double pitch_variance = 0.0;
                    double distance_scaling_factor = 0.0;
                    double yaw_variance = 0.0;
                    rotation_from_tormentor = 0.0;
                    opacity = 0.0;
                    distance = 0.0;
                    amplify = 0.0;
                    max_entities = 0.0;
                    xcalc = 0.0;
                    dist_to_rendered = 0.0;
                    ycalc = 0.0;
                    double colg = 0.0;
                    zcalc = 0.0;
                    double colr = 0.0;
                    double colb = 0.0;
                    double max_mobs = 0.0;
                    dists = 0.0;
                    double size_grow_distance = 0.0;
                    if (entity instanceof LivingEntity) {
                        _livEnt3 = (LivingEntity)entity;
                        itemStack3 = _livEnt3.getMainHandItem();
                    } else {
                        itemStack3 = ItemStack.EMPTY;
                    }
                    if (itemStack3.getItem() == ArphexModItems.WARP_WAYFINDER.get()) break block175;
                    if (entity instanceof LivingEntity) {
                        _livEnt2 = (LivingEntity)entity;
                        itemStack2 = _livEnt2.getOffhandItem();
                    } else {
                        itemStack2 = ItemStack.EMPTY;
                    }
                    if (itemStack2.getItem() != ArphexModItems.WARP_WAYFINDER.get()) break block176;
                }
                if (entity instanceof LivingEntity) {
                    _livEnt = (LivingEntity)entity;
                    itemStack = _livEnt.getMainHandItem();
                } else {
                    itemStack = ItemStack.EMPTY;
                }
                if (itemStack.getItem() == ArphexModItems.WARP_WAYFINDER.get()) {
                    ItemStack itemStack4;
                    if (entity instanceof LivingEntity) {
                        _livEnt = (LivingEntity)entity;
                        itemStack4 = _livEnt.getMainHandItem();
                    } else {
                        itemStack4 = ItemStack.EMPTY;
                    }
                    warp_wayfinder = itemStack4;
                } else {
                    ItemStack itemStack5;
                    if (entity instanceof LivingEntity) {
                        _livEnt = (LivingEntity)entity;
                        itemStack5 = _livEnt.getOffhandItem();
                    } else {
                        itemStack5 = ItemStack.EMPTY;
                    }
                    warp_wayfinder = itemStack5;
                }
                RenderTest6Procedure.system(true);
                if (RenderTest6Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, true)) {
                    for (int index0 = 0; index0 < 90; ++index0) {
                        for (int index1 = 0; index1 < 45; ++index1) {
                            k = 255.0 - j / 180.0 * 95.0;
                            l = 255.0 - (j + 4.0) / 180.0 * 95.0;
                            RenderTest6Procedure.add((float)(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5), 0xFF000000 | (int)k << 16 | (int)k << 8 | (int)k);
                            RenderTest6Procedure.add((float)(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), 0xFF000000 | (int)l << 16 | (int)l << 8 | (int)l);
                            RenderTest6Procedure.add((float)(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), 0xFF000000 | (int)l << 16 | (int)l << 8 | (int)l);
                            RenderTest6Procedure.add((float)(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5), 0xFF000000 | (int)k << 16 | (int)k << 8 | (int)k);
                            j += 4.0;
                        }
                        j = 0.0;
                        i += 4.0;
                    }
                    i = 0.0;
                    RenderTest6Procedure.end();
                }
                RenderSystem.disableCull();
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                if (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_x") != 0.0 || ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_y") != 0.0 || ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_z") != 0.0) {
                    ResourceKey resourceKey;
                    String string = ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("target_1_dimension");
                    if (world instanceof Level) {
                        _lvl = (Level)world;
                        resourceKey = _lvl.dimension();
                    } else if (world instanceof WorldGenLevel) {
                        _wgl = (WorldGenLevel)world;
                        resourceKey = _wgl.getLevel().dimension();
                    } else {
                        resourceKey = Level.OVERWORLD;
                    }
                    if (string.equals(String.valueOf(resourceKey))) {
                        dists = Math.sqrt((entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_x")) * (entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_x")) + (entity.getY() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_y")) * (entity.getY() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_y")) + (entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_z")) * (entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_z")));
                        xcalc = x + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_x") - x) / dists * (double)(Minecraft.getInstance().gameRenderer.getRenderDistance() + 100.0f);
                        ycalc = y + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_y") - y) / dists * (double)(Minecraft.getInstance().gameRenderer.getRenderDistance() + 100.0f);
                        zcalc = z + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_z") - z) / dists * (double)(Minecraft.getInstance().gameRenderer.getRenderDistance() + 100.0f);
                        dist_to_rendered = Math.sqrt((entity.getX() - xcalc) * (entity.getX() - xcalc) + (entity.getY() - ycalc) * (entity.getY() - ycalc) + (entity.getZ() - zcalc) * (entity.getZ() - zcalc));
                        if (dist_to_rendered > dists) {
                            if (RenderTest6Procedure.target(2)) {
                                RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_x") + 0.5, ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_y") + 0.5, ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_z") + 0.5, 0.0f, 0.0f, 0.0f, 1.0f, 200.0f, 1.0f, 1694121020);
                                RenderTest6Procedure.release();
                            }
                        } else if (RenderTest6Procedure.target(2)) {
                            RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), xcalc + 0.5, ycalc + 0.5, zcalc + 0.5, 0.0f, 0.0f, 0.0f, 1.0f, 200.0f, 1.0f, 1694121020);
                            RenderTest6Procedure.release();
                        }
                    }
                }
                if (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_x") != 0.0 || ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_y") != 0.0 || ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_z") != 0.0) {
                    ResourceKey resourceKey;
                    String string = ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("target_2_dimension");
                    if (world instanceof Level) {
                        _lvl = (Level)world;
                        resourceKey = _lvl.dimension();
                    } else if (world instanceof WorldGenLevel) {
                        _wgl = (WorldGenLevel)world;
                        resourceKey = _wgl.getLevel().dimension();
                    } else {
                        resourceKey = Level.OVERWORLD;
                    }
                    if (string.equals(String.valueOf(resourceKey))) {
                        dists = Math.sqrt((entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_x")) * (entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_x")) + (entity.getY() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_y")) * (entity.getY() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_y")) + (entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_z")) * (entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_z")));
                        xcalc = x + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_x") - x) / dists * (double)(Minecraft.getInstance().gameRenderer.getRenderDistance() + 100.0f);
                        ycalc = y + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_y") - y) / dists * (double)(Minecraft.getInstance().gameRenderer.getRenderDistance() + 100.0f);
                        zcalc = z + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_z") - z) / dists * (double)(Minecraft.getInstance().gameRenderer.getRenderDistance() + 100.0f);
                        dist_to_rendered = Math.sqrt((entity.getX() - xcalc) * (entity.getX() - xcalc) + (entity.getY() - ycalc) * (entity.getY() - ycalc) + (entity.getZ() - zcalc) * (entity.getZ() - zcalc));
                        if (dist_to_rendered > dists) {
                            if (RenderTest6Procedure.target(2)) {
                                RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_x") + 0.5, ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_y") + 0.5, ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_z") + 0.5, 0.0f, 0.0f, 0.0f, 1.0f, 200.0f, 1.0f, 1681717820);
                                RenderTest6Procedure.release();
                            }
                        } else if (RenderTest6Procedure.target(2)) {
                            RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), xcalc + 0.5, ycalc + 0.5, zcalc + 0.5, 0.0f, 0.0f, 0.0f, 1.0f, 200.0f, 1.0f, 1681717820);
                            RenderTest6Procedure.release();
                        }
                    }
                }
                if (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_x") != 0.0 || ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_y") != 0.0 || ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_z") != 0.0) {
                    ResourceKey resourceKey;
                    String string = ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("target_3_dimension");
                    if (world instanceof Level) {
                        _lvl = (Level)world;
                        resourceKey = _lvl.dimension();
                    } else if (world instanceof WorldGenLevel) {
                        _wgl = (WorldGenLevel)world;
                        resourceKey = _wgl.getLevel().dimension();
                    } else {
                        resourceKey = Level.OVERWORLD;
                    }
                    if (string.equals(String.valueOf(resourceKey))) {
                        dists = Math.sqrt((entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_x")) * (entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_x")) + (entity.getY() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_y")) * (entity.getY() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_y")) + (entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_z")) * (entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_z")));
                        xcalc = x + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_x") - x) / dists * (double)(Minecraft.getInstance().gameRenderer.getRenderDistance() + 100.0f);
                        ycalc = y + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_y") - y) / dists * (double)(Minecraft.getInstance().gameRenderer.getRenderDistance() + 100.0f);
                        zcalc = z + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_z") - z) / dists * (double)(Minecraft.getInstance().gameRenderer.getRenderDistance() + 100.0f);
                        dist_to_rendered = Math.sqrt((entity.getX() - xcalc) * (entity.getX() - xcalc) + (entity.getY() - ycalc) * (entity.getY() - ycalc) + (entity.getZ() - zcalc) * (entity.getZ() - zcalc));
                        if (dist_to_rendered > dists) {
                            if (RenderTest6Procedure.target(2)) {
                                RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_x") + 0.5, ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_y") + 0.5, ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_z") + 0.5, 0.0f, 0.0f, 0.0f, 1.0f, 200.0f, 1.0f, 1681669370);
                                RenderTest6Procedure.release();
                            }
                        } else if (RenderTest6Procedure.target(2)) {
                            RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), xcalc + 0.5, ycalc + 0.5, zcalc + 0.5, 0.0f, 0.0f, 0.0f, 1.0f, 200.0f, 1.0f, 1681669370);
                            RenderTest6Procedure.release();
                        }
                    }
                }
            }
            if (!(ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_health > 0.0 || ((ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES)).tormentorjustdiednearby > 0.0 || ((ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES)).sphere_near > 0.0) && (entity instanceof LivingEntity && (_livEnt3 = (LivingEntity)entity).hasEffect(ArphexModMobEffects.ETERNAL_EVASION) ? _livEnt3.getEffect(ArphexModMobEffects.ETERNAL_EVASION).getAmplifier() : 0) != 9) break block177;
            RenderTest6Procedure.system(true);
            if (RenderTest6Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, true)) {
                for (int index2 = 0; index2 < 90; ++index2) {
                    for (int index3 = 0; index3 < 45; ++index3) {
                        k = 255.0 - j / 180.0 * 95.0;
                        l = 255.0 - (j + 4.0) / 180.0 * 95.0;
                        RenderTest6Procedure.add((float)(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j)) * 0.5), 0xFF000000 | (int)k << 16 | (int)k << 8 | (int)k);
                        RenderTest6Procedure.add((float)(Math.sin(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(i)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), 0xFF000000 | (int)l << 16 | (int)l << 8 | (int)l);
                        RenderTest6Procedure.add((float)(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(j + 4.0)) * 0.5), (float)(Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j + 4.0)) * 0.5), 0xFF000000 | (int)l << 16 | (int)l << 8 | (int)l);
                        RenderTest6Procedure.add((float)(Math.sin(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(j)) * 0.5), (float)(Math.cos(Math.toRadians(i + 4.0)) * Math.sin(Math.toRadians(j)) * 0.5), 0xFF000000 | (int)k << 16 | (int)k << 8 | (int)k);
                        j += 4.0;
                    }
                    j = 0.0;
                    i += 4.0;
                }
                i = 0.0;
                RenderTest6Procedure.end();
            }
            if (((ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES)).tormentorjustdiednearby > 0.0) {
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                _center = new Vec3(x, y, z);
                _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(100.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                for (Entity entityiterator : _entfound) {
                    ItemStack itemStack;
                    if (!(entityiterator instanceof ItemEntity)) continue;
                    if (entityiterator instanceof ItemEntity) {
                        ItemEntity _itemEnt = (ItemEntity)entityiterator;
                        itemStack = _itemEnt.getItem();
                    } else {
                        itemStack = ItemStack.EMPTY;
                    }
                    if (itemStack.getItem() != ArphexModItems.CORE_OF_ETERNAL_SUFFERING.get() || !RenderTest6Procedure.target(2)) continue;
                    RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY(), entityiterator.getZ(), 0.0f, 0.0f, 0.0f, 6.0f, 6.0f, 6.0f, (int)(100.0 - rotation_from_tormentor * 0.86) << 24 | 0xFF0000 | 0x3200 | 0x32);
                    RenderTest6Procedure.release();
                }
            }
            if (ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_health > 0.0 && !(((ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES)).tormentor_render > 0.0)) {
                tormentor_distance = Math.sqrt((entity.getX() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x) * (entity.getX() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x) + (entity.getY() + 1.0 - (ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_y + 4.0)) * (entity.getY() + 1.0 - (ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_y + 4.0)) + (entity.getZ() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z) * (entity.getZ() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z));
                RenderSystem.disableDepthTest();
                RenderSystem.depthMask((boolean)false);
                if (tormentor_distance < 1000.0 && RenderTest6Procedure.target(2)) {
                    _center = new Vec3(x, y, z);
                    _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(125.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                    for (Entity entityiterator : _entfound) {
                        if (entityiterator instanceof TormentorMothSummonEntity) {
                            RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY() + 4.0, entityiterator.getZ(), 0.0f, 0.0f, 0.0f, 10.0f, 10.0f, 10.0f, 1681666650);
                        }
                        if (entityiterator instanceof TormentorScorpioidSummonEntity) {
                            RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY() + 2.0, entityiterator.getZ(), 0.0f, 0.0f, 0.0f, 5.0f, 5.0f, 5.0f, 1684288050);
                        }
                        if (!(entityiterator instanceof TormentorVoidlasherSummonEntity)) continue;
                        RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY() + 2.0, entityiterator.getZ(), 0.0f, 0.0f, 0.0f, 5.0f, 5.0f, 5.0f, 1685586040);
                    }
                    RenderTest6Procedure.release();
                }
                if (ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_entity_loaded > 0.0 && tormentor_distance < 400.0 && (rotation_from_tormentor = Math.min(Math.abs((Math.toDegrees(Math.atan2(ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z - entity.getZ(), ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x - entity.getX())) - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_rotation + 360.0) % 360.0 - 270.0), 360.0 - Math.abs((Math.toDegrees(Math.atan2(ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z - entity.getZ(), ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x - entity.getX())) - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_rotation + 360.0) % 360.0 - 270.0))) < 115.0) {
                    spheresize = 10.0;
                    if (RenderTest6Procedure.target(2)) {
                        RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x, ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_y + 4.0, ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z, 0.0f, 0.0f, 0.0f, (float)spheresize, (float)spheresize, (float)spheresize, (int)(100.0 - rotation_from_tormentor * 0.86) << 24 | 0xFF0000 | 0x3200 | 0x32);
                        if (spheresize / 2.0 > tormentor_distance) {
                            ArphexModVariables.PlayerVariables _vars = (ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES);
                            _vars.overlay_red = 5.0;
                            _vars.syncPlayerVariables(entity);
                        }
                        RenderTest6Procedure.release();
                    }
                }
            }
            if (!(((ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES)).sphere_near > 0.0) && (entity instanceof LivingEntity && (_livEnt2 = (LivingEntity)entity).hasEffect(ArphexModMobEffects.ETERNAL_EVASION) ? _livEnt2.getEffect(ArphexModMobEffects.ETERNAL_EVASION).getAmplifier() : 0) != 9) break block177;
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
            amplify = 400.0;
            if ((entity instanceof LivingEntity && (_livEnt = (LivingEntity)entity).hasEffect(ArphexModMobEffects.ETERNAL_EVASION) ? _livEnt.getEffect(ArphexModMobEffects.ETERNAL_EVASION).getAmplifier() : 0) == 9) {
                amplify = 1500.0;
            }
            max_entities = 100.0;
            Vec3 _center2 = new Vec3(x, y, z);
            List<Entity> _entfound2 = world.getEntitiesOfClass(Entity.class, new AABB(_center2, _center2).inflate(amplify / 2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center2))).toList();
            for (Entity entityiterator : _entfound2) {
                SphereAnimEntity _datEntS;
                Monster _datEntS2;
                block181: {
                    ItemStack itemStack;
                    LivingEntity _entGetArmor;
                    block182: {
                        float f;
                        float f2;
                        Player _plrCldCheck267;
                        Player _plrCldCheck266;
                        block178: {
                            block180: {
                                ItemStack itemStack6;
                                ItemStack itemStack7;
                                ItemStack itemStack8;
                                ItemStack itemStack9;
                                block179: {
                                    ItemStack itemStack10;
                                    ItemStack itemStack11;
                                    ItemStack itemStack12;
                                    ItemStack itemStack13;
                                    if (entity.getPersistentData().getString("hornetlock_uuids").contains(entityiterator.getStringUUID())) {
                                        RenderSystem.depthMask((boolean)false);
                                        RenderSystem.disableDepthTest();
                                        if (RenderTest6Procedure.target(2)) {
                                            RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY(), entityiterator.getZ(), 0.0f, 0.0f, 0.0f, 0.7f, 0.7f, 0.7f, -1761607936);
                                            RenderTest6Procedure.release();
                                        }
                                    }
                                    if (entityiterator instanceof ChronoShotEntity) {
                                        RenderSystem.depthMask((boolean)true);
                                        RenderSystem.enableDepthTest();
                                        if (RenderTest6Procedure.target(2)) {
                                            RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY(), entityiterator.getZ(), 0.0f, 0.0f, 0.0f, 1.4f, 1.4f, 1.4f, -1778319616);
                                            RenderTest6Procedure.release();
                                        }
                                    }
                                    if (!(entityiterator instanceof LivingEntity)) continue;
                                    if (!(max_entities > 0.0) || !entity.isShiftKeyDown() || entity == entityiterator) break block178;
                                    if (entity instanceof LivingEntity) {
                                        LivingEntity _entGetArmor2 = (LivingEntity)entity;
                                        itemStack13 = _entGetArmor2.getItemBySlot(EquipmentSlot.HEAD);
                                    } else {
                                        itemStack13 = ItemStack.EMPTY;
                                    }
                                    if (itemStack13.getItem() != ArphexModItems.SPACETIME_HELMET.get()) break block179;
                                    if (entity instanceof LivingEntity) {
                                        LivingEntity _entGetArmor3 = (LivingEntity)entity;
                                        itemStack12 = _entGetArmor3.getItemBySlot(EquipmentSlot.CHEST);
                                    } else {
                                        itemStack12 = ItemStack.EMPTY;
                                    }
                                    if (itemStack12.getItem() != ArphexModItems.SPACETIME_CHESTPLATE.get()) break block179;
                                    if (entity instanceof LivingEntity) {
                                        LivingEntity _entGetArmor4 = (LivingEntity)entity;
                                        itemStack11 = _entGetArmor4.getItemBySlot(EquipmentSlot.LEGS);
                                    } else {
                                        itemStack11 = ItemStack.EMPTY;
                                    }
                                    if (itemStack11.getItem() != ArphexModItems.SPACETIME_LEGGINGS.get()) break block179;
                                    if (entity instanceof LivingEntity) {
                                        LivingEntity _entGetArmor5 = (LivingEntity)entity;
                                        itemStack10 = _entGetArmor5.getItemBySlot(EquipmentSlot.FEET);
                                    } else {
                                        itemStack10 = ItemStack.EMPTY;
                                    }
                                    if (itemStack10.getItem() == ArphexModItems.SPACETIME_BOOTS.get()) break block180;
                                }
                                if (entity instanceof LivingEntity) {
                                    _entGetArmor = (LivingEntity)entity;
                                    itemStack9 = _entGetArmor.getItemBySlot(EquipmentSlot.HEAD);
                                } else {
                                    itemStack9 = ItemStack.EMPTY;
                                }
                                if (itemStack9.getItem() != ArphexModItems.IMMORTAL_HELMET.get()) break block178;
                                if (entity instanceof LivingEntity) {
                                    LivingEntity _entGetArmor6 = (LivingEntity)entity;
                                    itemStack8 = _entGetArmor6.getItemBySlot(EquipmentSlot.CHEST);
                                } else {
                                    itemStack8 = ItemStack.EMPTY;
                                }
                                if (itemStack8.getItem() != ArphexModItems.IMMORTAL_CHESTPLATE.get()) break block178;
                                if (entity instanceof LivingEntity) {
                                    LivingEntity _entGetArmor7 = (LivingEntity)entity;
                                    itemStack7 = _entGetArmor7.getItemBySlot(EquipmentSlot.LEGS);
                                } else {
                                    itemStack7 = ItemStack.EMPTY;
                                }
                                if (itemStack7.getItem() != ArphexModItems.IMMORTAL_LEGGINGS.get()) break block178;
                                if (entity instanceof LivingEntity) {
                                    LivingEntity _entGetArmor8 = (LivingEntity)entity;
                                    itemStack6 = _entGetArmor8.getItemBySlot(EquipmentSlot.FEET);
                                } else {
                                    itemStack6 = ItemStack.EMPTY;
                                }
                                if (itemStack6.getItem() != ArphexModItems.IMMORTAL_BOOTS.get()) break block178;
                            }
                            col_r = 255.0;
                            col_g = 255.0;
                            col_b = 255.0;
                            if (entityiterator instanceof Monster) {
                                col_r = 255.0;
                                col_g = 0.0;
                                col_b = 0.0;
                            }
                            if (entityiterator instanceof TamableAnimal) {
                                LivingEntity _livEnt4;
                                TamableAnimal _tamIsTamedBy = (TamableAnimal)entityiterator;
                                if (entity instanceof LivingEntity && _tamIsTamedBy.isOwnedBy(_livEnt4 = (LivingEntity)entity)) {
                                    col_r = 0.0;
                                    col_g = 255.0;
                                    col_b = 0.0;
                                }
                            }
                            if (entityiterator instanceof Player) {
                                col_r = 0.0;
                                col_g = 0.0;
                                col_b = 255.0;
                            }
                            RenderSystem.depthMask((boolean)false);
                            RenderSystem.disableDepthTest();
                            max_entities -= 1.0;
                            if (RenderTest6Procedure.target(2)) {
                                RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY() + 1.0, entityiterator.getZ(), 0.0f, 0.0f, 0.0f, (float)((double)entityiterator.getBbHeight() * 0.65), (float)((double)entityiterator.getBbHeight() * 0.65), (float)((double)entityiterator.getBbHeight() * 0.65), 0x96000000 | (int)col_r << 16 | (int)col_g << 8 | (int)col_b);
                                RenderTest6Procedure.release();
                            }
                        }
                        RenderSystem.depthMask((boolean)true);
                        RenderSystem.enableDepthTest();
                        if (!(entityiterator instanceof Player) || (!(entityiterator instanceof Player) || !(_plrCldCheck266 = (Player)entityiterator).getCooldowns().isOnCooldown((Item)ArphexModItems.SPACETIME_CHESTPLATE.get())) && (!(entityiterator instanceof Player) || !(_plrCldCheck267 = (Player)entityiterator).getCooldowns().isOnCooldown((Item)ArphexModItems.IMMORTAL_CHESTPLATE.get()))) break block181;
                        if (entityiterator instanceof Player) {
                            Player _plrCldRem268 = (Player)entityiterator;
                            f2 = _plrCldRem268.getCooldowns().getCooldownPercent((Item)ArphexModItems.SPACETIME_CHESTPLATE.get(), 0.0f) * 100.0f;
                        } else {
                            f2 = 0.0f;
                        }
                        if (f2 >= 75.0f) break block182;
                        if (entityiterator instanceof Player) {
                            Player _plrCldRem269 = (Player)entityiterator;
                            f = _plrCldRem269.getCooldowns().getCooldownPercent((Item)ArphexModItems.IMMORTAL_CHESTPLATE.get(), 0.0f) * 100.0f;
                        } else {
                            f = 0.0f;
                        }
                        if (!(f >= 75.0f)) break block181;
                    }
                    if (entity instanceof LivingEntity) {
                        _entGetArmor = (LivingEntity)entity;
                        itemStack = _entGetArmor.getItemBySlot(EquipmentSlot.CHEST);
                    } else {
                        itemStack = ItemStack.EMPTY;
                    }
                    if (itemStack.getItem() == ArphexModItems.IMMORTAL_CHESTPLATE.get()) {
                        float f;
                        if (entityiterator instanceof Player) {
                            Player _plrCldRem272 = (Player)entityiterator;
                            f = _plrCldRem272.getCooldowns().getCooldownPercent((Item)ArphexModItems.IMMORTAL_CHESTPLATE.get(), 0.0f) * 100.0f;
                        } else {
                            f = 0.0f;
                        }
                        spheresize = Math.min(50.0f - Math.abs(50.0f - Math.abs((75.0f - f) * 4.0f)), 10.0f);
                    } else {
                        float f;
                        if (entityiterator instanceof Player) {
                            Player _plrCldRem273 = (Player)entityiterator;
                            f = _plrCldRem273.getCooldowns().getCooldownPercent((Item)ArphexModItems.SPACETIME_CHESTPLATE.get(), 0.0f) * 100.0f;
                        } else {
                            f = 0.0f;
                        }
                        spheresize = Math.min(50.0f - Math.abs(50.0f - Math.abs((75.0f - f) * 4.0f)), 10.0f);
                    }
                    opacity = 140.0;
                    col_r = 50.0;
                    col_g = 50.0;
                    col_b = 170.0;
                    RenderSystem.disableCull();
                    RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    if (RenderTest6Procedure.target(2)) {
                        RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY() + 1.0, entityiterator.getZ(), 0.0f, 0.0f, 0.0f, (float)spheresize, (float)spheresize, (float)spheresize, (int)opacity << 24 | (int)col_r << 16 | (int)col_g << 8 | (int)col_b);
                        if (entityiterator instanceof SphereAnimEntity && spheresize / 2.0 > distance) {
                            String string;
                            if (entityiterator instanceof SphereAnimEntity) {
                                _datEntS2 = (SphereAnimEntity)entityiterator;
                                string = (String)_datEntS2.getEntityData().get(SphereAnimEntity.DATA_color);
                            } else {
                                string = "";
                            }
                            if (string.equals("white")) {
                                _vars = (ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES);
                                _vars.overlay_white = 5.0;
                                _vars.syncPlayerVariables(entity);
                            } else {
                                _vars = (ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES);
                                _vars.overlay_black = 5.0;
                                _vars.syncPlayerVariables(entity);
                            }
                        }
                        RenderTest6Procedure.release();
                    }
                }
                if (!(entityiterator instanceof SphereAnimEntity) && !(entityiterator instanceof AscendSphereAnimEntity)) continue;
                distance = Math.sqrt((entity.getX() - entityiterator.getX()) * (entity.getX() - entityiterator.getX()) + (entity.getY() + 1.0 - entityiterator.getY()) * (entity.getY() + 1.0 - entityiterator.getY()) + (entity.getZ() - entityiterator.getZ()) * (entity.getZ() - entityiterator.getZ()));
                if (entityiterator instanceof SphereAnimEntity) {
                    String string;
                    int n;
                    if (entityiterator instanceof SphereAnimEntity) {
                        _datEntI = (SphereAnimEntity)entityiterator;
                        n = (Integer)_datEntI.getEntityData().get(SphereAnimEntity.DATA_sphere_size);
                    } else {
                        n = 0;
                    }
                    spheresize = n / 10;
                    opacity = 140.0;
                    if (entityiterator instanceof SphereAnimEntity) {
                        _datEntS = (SphereAnimEntity)entityiterator;
                        string = (String)_datEntS.getEntityData().get(SphereAnimEntity.DATA_color);
                    } else {
                        string = "";
                    }
                    if (string.equals("red")) {
                        col_r = 255.0;
                        col_g = 0.0;
                        col_b = 0.0;
                    } else {
                        String string2;
                        if (entityiterator instanceof SphereAnimEntity) {
                            _datEntS = (SphereAnimEntity)entityiterator;
                            string2 = (String)_datEntS.getEntityData().get(SphereAnimEntity.DATA_color);
                        } else {
                            string2 = "";
                        }
                        if (string2.equals("white")) {
                            col_r = 255.0;
                            col_g = 255.0;
                            col_b = 255.0;
                        } else {
                            String string3;
                            if (entityiterator instanceof SphereAnimEntity) {
                                _datEntS = (SphereAnimEntity)entityiterator;
                                string3 = (String)_datEntS.getEntityData().get(SphereAnimEntity.DATA_color);
                            } else {
                                string3 = "";
                            }
                            if (string3.equals("purple")) {
                                col_r = 141.0;
                                col_g = 21.0;
                                col_b = 161.0;
                            } else {
                                String string4;
                                if (entityiterator instanceof SphereAnimEntity) {
                                    _datEntS = (SphereAnimEntity)entityiterator;
                                    string4 = (String)_datEntS.getEntityData().get(SphereAnimEntity.DATA_color);
                                } else {
                                    string4 = "";
                                }
                                if (string4.equals("green")) {
                                    col_r = 0.0;
                                    col_g = 200.0;
                                    col_b = 0.0;
                                } else {
                                    col_r = 0.0;
                                    col_g = 0.0;
                                    col_b = 0.0;
                                }
                            }
                        }
                    }
                } else {
                    int n;
                    RenderSystem.disableCull();
                    RenderSystem.defaultBlendFunc();
                    spheresize = 200.0;
                    if (entityiterator instanceof AscendSphereAnimEntity) {
                        _datEntI = (AscendSphereAnimEntity)entityiterator;
                        n = (Integer)_datEntI.getEntityData().get(AscendSphereAnimEntity.DATA_barriermode);
                    } else {
                        n = 0;
                    }
                    if (n > 0) {
                        col_r = 255.0;
                        col_g = 255.0;
                        col_b = 255.0;
                    } else {
                        String string;
                        if (entityiterator instanceof AscendSphereAnimEntity) {
                            _datEntS = (AscendSphereAnimEntity)entityiterator;
                            string = (String)_datEntS.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                        } else {
                            string = "";
                        }
                        if (string.equals("green")) {
                            col_r = 120.0;
                            col_g = 255.0;
                            col_b = 120.0;
                        } else {
                            String string5;
                            if (entityiterator instanceof AscendSphereAnimEntity) {
                                _datEntS = (AscendSphereAnimEntity)entityiterator;
                                string5 = (String)_datEntS.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                            } else {
                                string5 = "";
                            }
                            if (string5.equals("blue")) {
                                col_r = 120.0;
                                col_g = 120.0;
                                col_b = 255.0;
                            } else {
                                String string6;
                                if (entityiterator instanceof AscendSphereAnimEntity) {
                                    _datEntS = (AscendSphereAnimEntity)entityiterator;
                                    string6 = (String)_datEntS.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                                } else {
                                    string6 = "";
                                }
                                if (string6.equals("yellow")) {
                                    col_r = 240.0;
                                    col_g = 240.0;
                                    col_b = 100.0;
                                } else {
                                    String string7;
                                    if (entityiterator instanceof AscendSphereAnimEntity) {
                                        _datEntS2 = (AscendSphereAnimEntity)entityiterator;
                                        string7 = (String)_datEntS2.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                                    } else {
                                        string7 = "";
                                    }
                                    if (string7.equals("orange")) {
                                        col_r = 255.0;
                                        col_g = 160.0;
                                        col_b = 100.0;
                                    } else {
                                        String string8;
                                        if (entityiterator instanceof AscendSphereAnimEntity) {
                                            AscendSphereAnimEntity _datEntS3 = (AscendSphereAnimEntity)entityiterator;
                                            string8 = (String)_datEntS3.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                                        } else {
                                            string8 = "";
                                        }
                                        if (string8.equals("purple")) {
                                            col_r = 180.0;
                                            col_g = 120.0;
                                            col_b = 255.0;
                                        } else {
                                            String string9;
                                            if (entityiterator instanceof AscendSphereAnimEntity) {
                                                AscendSphereAnimEntity _datEntS4 = (AscendSphereAnimEntity)entityiterator;
                                                string9 = (String)_datEntS4.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                                            } else {
                                                string9 = "";
                                            }
                                            if (string9.equals("pink")) {
                                                col_r = 255.0;
                                                col_g = 120.0;
                                                col_b = 180.0;
                                            } else {
                                                String string10;
                                                if (entityiterator instanceof AscendSphereAnimEntity) {
                                                    AscendSphereAnimEntity _datEntS5 = (AscendSphereAnimEntity)entityiterator;
                                                    string10 = (String)_datEntS5.getEntityData().get(AscendSphereAnimEntity.DATA_color);
                                                } else {
                                                    string10 = "";
                                                }
                                                if (string10.equals("invisible")) {
                                                    opacity = 999.0;
                                                } else {
                                                    col_r = 255.0;
                                                    col_g = 120.0;
                                                    col_b = 120.0;
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                    if (opacity != 999.0) {
                        opacity = distance < 200.0 ? (distance < 100.0 ? 100.0 : (double)Math.round(100.0 * (1.0 - (distance - 100.0) / 100.0))) : 0.0;
                    }
                }
                if (opacity == 999.0 || !RenderTest6Procedure.target(2)) continue;
                RenderTest6Procedure.renderShape(RenderTest6Procedure.shape(), entityiterator.getX(), entityiterator.getY() + 1.0, entityiterator.getZ(), 0.0f, 0.0f, 0.0f, (float)spheresize, (float)spheresize, (float)spheresize, (int)opacity << 24 | (int)col_r << 16 | (int)col_g << 8 | (int)col_b);
                if (entityiterator instanceof SphereAnimEntity && spheresize / 2.0 > distance) {
                    String string;
                    if (entityiterator instanceof SphereAnimEntity) {
                        _datEntS = (SphereAnimEntity)entityiterator;
                        string = (String)_datEntS.getEntityData().get(SphereAnimEntity.DATA_color);
                    } else {
                        string = "";
                    }
                    if (string.equals("white")) {
                        _vars = (ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES);
                        _vars.overlay_white = 5.0;
                        _vars.syncPlayerVariables(entity);
                    } else {
                        _vars = (ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES);
                        _vars.overlay_black = 5.0;
                        _vars.syncPlayerVariables(entity);
                    }
                }
                RenderTest6Procedure.release();
            }
        }
    }
}

