/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.procedures;

import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.MeshData;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexBuffer;
import com.mojang.blaze3d.vertex.VertexFormat;
import com.mojang.math.Axis;
import java.util.Comparator;
import java.util.List;
import javax.annotation.Nullable;
import net.arphex.entity.SlowLookTestEntity;
import net.arphex.entity.TormentorLaserEntity;
import net.arphex.init.ArphexModItems;
import net.arphex.network.ArphexModVariables;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import org.joml.Matrix4f;

@EventBusSubscriber(value={Dist.CLIENT})
public class RenderTest7Procedure {
    private static BufferBuilder bufferBuilder = null;
    private static VertexBuffer vertexBuffer = null;
    private static VertexFormat.Mode mode = null;
    private static VertexFormat format = null;
    private static PoseStack poseStack = null;
    private static Matrix4f modelViewMatrix = null;
    private static Matrix4f projectionMatrix = null;
    private static boolean worldCoordinate = true;
    private static Vec3 offset = Vec3.ZERO;
    private static int currentStage = 0;
    private static int targetStage = 0;

    private static void add(float x, float y, float z, int color) {
        RenderTest7Procedure.add(x, y, z, 0.0f, 0.0f, color);
    }

    private static void add(float x, float y, float z, float u, float v, int color) {
        if (bufferBuilder == null) {
            return;
        }
        if (format == DefaultVertexFormat.POSITION_COLOR) {
            bufferBuilder.addVertex(x, y, z).setColor(color);
        } else if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
            bufferBuilder.addVertex(x, y, z).setUv(u, v).setColor(color);
        }
    }

    private static boolean begin(VertexFormat.Mode mode, VertexFormat format, boolean update) {
        if (bufferBuilder == null) {
            if (update) {
                RenderTest7Procedure.clear();
            }
            if (vertexBuffer == null) {
                if (format == DefaultVertexFormat.POSITION_COLOR) {
                    RenderTest7Procedure.mode = mode;
                    RenderTest7Procedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_COLOR);
                    return true;
                }
                if (format == DefaultVertexFormat.POSITION_TEX_COLOR) {
                    RenderTest7Procedure.mode = mode;
                    RenderTest7Procedure.format = format;
                    bufferBuilder = Tesselator.getInstance().begin(mode, DefaultVertexFormat.POSITION_TEX_COLOR);
                    return true;
                }
            }
        }
        return false;
    }

    private static void clear() {
        if (vertexBuffer != null) {
            vertexBuffer.close();
            vertexBuffer = null;
        }
    }

    private static void end() {
        MeshData meshData;
        if (bufferBuilder == null) {
            return;
        }
        if (vertexBuffer != null) {
            vertexBuffer.close();
        }
        if ((meshData = bufferBuilder.build()) == null) {
            vertexBuffer = null;
            bufferBuilder = null;
        } else {
            vertexBuffer = new VertexBuffer(VertexBuffer.Usage.STATIC);
            vertexBuffer.bind();
            vertexBuffer.upload(meshData);
            VertexBuffer.unbind();
            bufferBuilder = null;
        }
    }

    private static void offset(double x, double y, double z) {
        offset = new Vec3(x, y, z);
    }

    private static void release() {
        targetStage = 0;
    }

    private static VertexBuffer shape() {
        return vertexBuffer;
    }

    private static void system(boolean worldCoordinate) {
        RenderTest7Procedure.worldCoordinate = worldCoordinate;
    }

    private static boolean target(int targetStage) {
        if (targetStage == currentStage) {
            RenderTest7Procedure.targetStage = targetStage;
            return true;
        }
        return false;
    }

    private static void renderShape(VertexBuffer vertexBuffer, double x, double y, double z, float yaw, float pitch, float roll, float xScale, float yScale, float zScale, int color) {
        float k;
        float j;
        float i;
        if (currentStage == 0 || currentStage != targetStage) {
            return;
        }
        if (poseStack == null || projectionMatrix == null) {
            return;
        }
        if (vertexBuffer == null) {
            return;
        }
        if (worldCoordinate) {
            Vec3 pos = Minecraft.getInstance().gameRenderer.getMainCamera().getPosition();
            i = (float)(x - pos.x());
            j = (float)(y - pos.y());
            k = (float)(z - pos.z());
        } else {
            i = (float)x;
            j = (float)y;
            k = (float)z;
        }
        poseStack.pushPose();
        poseStack.mulPose(modelViewMatrix);
        poseStack.translate(i, j, k);
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(xScale, yScale, zScale);
        poseStack.translate(offset.x(), offset.y(), offset.z());
        RenderSystem.setShaderColor((float)((float)(color >> 16 & 0xFF) / 255.0f), (float)((float)(color >> 8 & 0xFF) / 255.0f), (float)((float)(color & 0xFF) / 255.0f), (float)((float)(color >>> 24) / 255.0f));
        vertexBuffer.bind();
        vertexBuffer.drawWithShader(poseStack.last().pose(), projectionMatrix, vertexBuffer.getFormat().hasUV(0) ? GameRenderer.getPositionTexColorShader() : GameRenderer.getPositionColorShader());
        VertexBuffer.unbind();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderLevel(RenderLevelStageEvent event) {
        if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_SKY) {
            currentStage = 1;
            poseStack = new PoseStack();
            RenderSystem.depthMask((boolean)false);
            RenderTest7Procedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        } else if (event.getStage() == RenderLevelStageEvent.Stage.AFTER_PARTICLES) {
            currentStage = 2;
            poseStack = event.getPoseStack();
            RenderSystem.depthMask((boolean)true);
            RenderTest7Procedure.renderShapes(event);
            RenderSystem.enableCull();
            RenderSystem.depthMask((boolean)true);
            currentStage = 0;
        }
    }

    private static void renderShapes(RenderLevelStageEvent event) {
        Minecraft minecraft = Minecraft.getInstance();
        ClientLevel level = minecraft.level;
        Entity entity = minecraft.gameRenderer.getMainCamera().getEntity();
        if (level != null && entity != null) {
            modelViewMatrix = event.getModelViewMatrix();
            projectionMatrix = event.getProjectionMatrix();
            Vec3 pos = entity.getPosition(event.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.enableBlend();
            RenderSystem.defaultBlendFunc();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderTest7Procedure.execute((Event)event, (LevelAccessor)level, pos.x(), pos.y(), pos.z(), entity);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableDepthTest();
        }
    }

    public static void execute(LevelAccessor world, double x, double y, double z, Entity entity) {
        RenderTest7Procedure.execute(null, world, x, y, z, entity);
    }

    private static void execute(@Nullable Event event, LevelAccessor world, double x, double y, double z, Entity entity) {
        ResourceKey resourceKey;
        if (entity == null) {
            return;
        }
        boolean entity_found = false;
        boolean disabled = false;
        double i = 0.0;
        double j = 0.0;
        double k = 0.0;
        double l = 0.0;
        double spheresize = 0.0;
        double col_r = 0.0;
        double col_g = 0.0;
        double col_b = 0.0;
        double negx = 0.0;
        double posx = 0.0;
        double negz = 0.0;
        double posz = 0.0;
        double stretch1 = 0.0;
        double stretch2 = 0.0;
        double pitch_variance = 0.0;
        double distance_scaling_factor = 0.0;
        double yaw_variance = 0.0;
        double convert_yaw = 0.0;
        double ringspan = 0.0;
        double raytrace_distance = 0.0;
        double newpositionz = 0.0;
        double newpositiony = 0.0;
        double ringspin = 0.0;
        double newpositionx = 0.0;
        double pitch_distance_variance = 0.0;
        double distance = 0.0;
        double yaw_distance_variance = 0.0;
        double expand = 0.0;
        double y_offset = 0.0;
        double xfind = 0.0;
        double yfind = 0.0;
        double zfind = 0.0;
        double opacity = 0.0;
        double expandsearch = 0.0;
        double distance_level = 0.0;
        double math_limit = 0.0;
        if (world instanceof Level) {
            Level _lvl = (Level)world;
            resourceKey = _lvl.dimension();
        } else if (world instanceof WorldGenLevel) {
            WorldGenLevel _wgl = (WorldGenLevel)world;
            resourceKey = _wgl.getLevel().dimension();
        } else {
            resourceKey = Level.OVERWORLD;
        }
        if (resourceKey == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"arphex:the_crawling"))) {
            if (RenderTest7Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, true)) {
                RenderTest7Procedure.add(0.5f, 0.0f, -0.5f, -1);
                RenderTest7Procedure.add(0.5f, 0.0f, 0.5f, -1);
                RenderTest7Procedure.add(-0.5f, 0.0f, 0.5f, -1);
                RenderTest7Procedure.add(-0.5f, 0.0f, -0.5f, -1);
                RenderTest7Procedure.end();
            }
            RenderSystem.disableCull();
            if (RenderTest7Procedure.target(2)) {
                RenderSystem.defaultBlendFunc();
                math_limit = Math.floor(100.0 - Math.abs(((ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES)).crawling_color_cycle / 1.0 - 100.0));
                RenderTest7Procedure.renderShape(RenderTest7Procedure.shape(), x, 230.2, z, 0.0f, 0.0f, 0.0f, Minecraft.getInstance().gameRenderer.getRenderDistance() * 2.0f, Minecraft.getInstance().gameRenderer.getRenderDistance() * 2.0f, Minecraft.getInstance().gameRenderer.getRenderDistance() * 2.0f, 0x64000000 | (int)(70.0 + math_limit) << 16 | 0x1400 | 0);
                RenderTest7Procedure.renderShape(RenderTest7Procedure.shape(), x, 120.2, z, 0.0f, 0.0f, 0.0f, Minecraft.getInstance().gameRenderer.getRenderDistance() * 2.0f, Minecraft.getInstance().gameRenderer.getRenderDistance() * 2.0f, Minecraft.getInstance().gameRenderer.getRenderDistance() * 2.0f, 0x64000000 | (int)(70.0 + math_limit) << 16 | 0 | (int)(100.0 - math_limit));
                RenderTest7Procedure.renderShape(RenderTest7Procedure.shape(), x, 60.2, z, 0.0f, 0.0f, 0.0f, Minecraft.getInstance().gameRenderer.getRenderDistance() * 2.0f, Minecraft.getInstance().gameRenderer.getRenderDistance() * 2.0f, Minecraft.getInstance().gameRenderer.getRenderDistance() * 2.0f, 0xDC000000 | (int)Math.floor(math_limit / 4.0) << 16 | (int)Math.floor(math_limit / 4.0) << 8 | (int)Math.floor(math_limit / 4.0));
                RenderTest7Procedure.release();
            }
        }
        if (((ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES)).laser_emitter_near > 0.0) {
            RenderSystem.disableCull();
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            RenderTest7Procedure.system(true);
            negx = -3.0;
            posx = 3.0;
            negz = -3.0;
            posz = 3.0;
            stretch1 = 0.0;
            pitch_distance_variance = 140.0;
            yaw_distance_variance = 40.0;
            distance_scaling_factor = 1.0;
            y_offset = 1.0;
            expandsearch = 200.0;
            if (((ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES)).laser_emitter_near > 6.0) {
                expandsearch = 500.0;
            }
            Vec3 _center = new Vec3(x, y, z);
            List<Entity> _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(expandsearch / 2.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
            for (Entity entityiterator : _entfound) {
                ItemStack itemStack;
                if (entityiterator instanceof Player) {
                    ItemStack itemStack2;
                    if (entityiterator instanceof LivingEntity) {
                        LivingEntity _entUseItem38 = (LivingEntity)entityiterator;
                        itemStack2 = _entUseItem38.getUseItem();
                    } else {
                        itemStack2 = ItemStack.EMPTY;
                    }
                    if (itemStack2.getItem() == ArphexModItems.VISIONARY_SPEAR.get()) {
                        if (RenderTest7Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, false)) {
                            RenderTest7Procedure.add(0.5f, -0.5f, -0.5f, -6250336);
                            RenderTest7Procedure.add(0.5f, -0.5f, 0.5f, -6250336);
                            RenderTest7Procedure.add(-0.5f, -0.5f, 0.5f, -6250336);
                            RenderTest7Procedure.add(-0.5f, -0.5f, -0.5f, -6250336);
                            RenderTest7Procedure.add(0.5f, 0.5f, 0.5f, -1);
                            RenderTest7Procedure.add(0.5f, 0.5f, -0.5f, -1);
                            RenderTest7Procedure.add(-0.5f, 0.5f, -0.5f, -1);
                            RenderTest7Procedure.add(-0.5f, 0.5f, 0.5f, -1);
                            RenderTest7Procedure.add(0.5f, 0.5f, -0.5f, -2039584);
                            RenderTest7Procedure.add(0.5f, -0.5f, -0.5f, -2039584);
                            RenderTest7Procedure.add(-0.5f, -0.5f, -0.5f, -2039584);
                            RenderTest7Procedure.add(-0.5f, 0.5f, -0.5f, -2039584);
                            RenderTest7Procedure.add(-0.5f, 0.5f, 0.5f, -2039584);
                            RenderTest7Procedure.add(-0.5f, -0.5f, 0.5f, -2039584);
                            RenderTest7Procedure.add(0.5f, -0.5f, 0.5f, -2039584);
                            RenderTest7Procedure.add(0.5f, 0.5f, 0.5f, -2039584);
                            RenderTest7Procedure.add(0.5f, 0.5f, 0.5f, -4144960);
                            RenderTest7Procedure.add(0.5f, -0.5f, 0.5f, -4144960);
                            RenderTest7Procedure.add(0.5f, -0.5f, -0.5f, -4144960);
                            RenderTest7Procedure.add(0.5f, 0.5f, -0.5f, -4144960);
                            RenderTest7Procedure.add(-0.5f, 0.5f, -0.5f, -4144960);
                            RenderTest7Procedure.add(-0.5f, -0.5f, -0.5f, -4144960);
                            RenderTest7Procedure.add(-0.5f, -0.5f, 0.5f, -4144960);
                            RenderTest7Procedure.add(-0.5f, 0.5f, 0.5f, -4144960);
                            RenderTest7Procedure.end();
                        }
                        if (RenderTest7Procedure.target(2)) {
                            RenderSystem.defaultBlendFunc();
                            RenderSystem.disableCull();
                            RenderTest7Procedure.renderShape(RenderTest7Procedure.shape(), x, y, z, 0.0f, 0.0f, 0.0f, 4.0f, 4.0f, 4.0f, 335595600);
                            RenderTest7Procedure.release();
                        }
                    }
                }
                if (!(entityiterator instanceof SlowLookTestEntity) && !(entityiterator instanceof TormentorLaserEntity)) {
                    ItemStack itemStack3;
                    if (!(entityiterator instanceof Player)) continue;
                    if (entityiterator instanceof LivingEntity) {
                        LivingEntity _entUseItem98 = (LivingEntity)entityiterator;
                        itemStack3 = _entUseItem98.getUseItem();
                    } else {
                        itemStack3 = ItemStack.EMPTY;
                    }
                    if (itemStack3.getItem() != ArphexModItems.OBLIVION_RAY.get()) continue;
                }
                distance = Math.sqrt((entity.getX() - entityiterator.getX()) * (entity.getX() - entityiterator.getX()) + (entity.getY() - (entityiterator.getY() + y_offset)) * (entity.getY() - (entityiterator.getY() + y_offset)) + (entity.getZ() - entityiterator.getZ()) * (entity.getZ() - entityiterator.getZ()));
                if (entityiterator instanceof TormentorLaserEntity) {
                    RenderSystem.disableCull();
                    if (distance > 170.0) {
                        RenderSystem.enableDepthTest();
                    } else {
                        RenderSystem.disableDepthTest();
                    }
                }
                opacity = 200.0;
                if (entityiterator instanceof LivingEntity) {
                    LivingEntity _entUseItem116 = (LivingEntity)entityiterator;
                    itemStack = _entUseItem116.getUseItem();
                } else {
                    itemStack = ItemStack.EMPTY;
                }
                if (itemStack.getItem() == ArphexModItems.OBLIVION_RAY.get()) {
                    double d;
                    if (entity instanceof LivingEntity) {
                        LivingEntity _entUseTicks118 = (LivingEntity)entity;
                        d = _entUseTicks118.getTicksUsingItem();
                    } else {
                        d = 0.0;
                    }
                    opacity = d;
                }
                spheresize = 1.0;
                pitch_variance = pitch_distance_variance / (distance / 0.7);
                yaw_variance = yaw_distance_variance / (distance / 2.0);
                if (entityiterator instanceof TormentorLaserEntity) {
                    xfind = entityiterator.level().clip(new ClipContext(entityiterator.getEyePosition(1.0f), entityiterator.getEyePosition(1.0f).add(entityiterator.getViewVector(1.0f).scale(300.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityiterator)).getBlockPos().getX();
                    yfind = entityiterator.level().clip(new ClipContext(entityiterator.getEyePosition(1.0f), entityiterator.getEyePosition(1.0f).add(entityiterator.getViewVector(1.0f).scale(300.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityiterator)).getBlockPos().getY();
                    zfind = entityiterator.level().clip(new ClipContext(entityiterator.getEyePosition(1.0f), entityiterator.getEyePosition(1.0f).add(entityiterator.getViewVector(1.0f).scale(300.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityiterator)).getBlockPos().getZ();
                } else {
                    xfind = entityiterator.level().clip(new ClipContext(entityiterator.getEyePosition(1.0f), entityiterator.getEyePosition(1.0f).add(entityiterator.getViewVector(1.0f).scale(100.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityiterator)).getBlockPos().getX();
                    yfind = entityiterator.level().clip(new ClipContext(entityiterator.getEyePosition(1.0f), entityiterator.getEyePosition(1.0f).add(entityiterator.getViewVector(1.0f).scale(100.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityiterator)).getBlockPos().getY();
                    zfind = entityiterator.level().clip(new ClipContext(entityiterator.getEyePosition(1.0f), entityiterator.getEyePosition(1.0f).add(entityiterator.getViewVector(1.0f).scale(100.0)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, entityiterator)).getBlockPos().getZ();
                }
                expand = Math.sqrt((xfind - entityiterator.getX()) * (xfind - entityiterator.getX()) + (yfind - (entityiterator.getY() + y_offset)) * (yfind - (entityiterator.getY() + y_offset)) + (zfind - entityiterator.getZ()) * (zfind - entityiterator.getZ())) + 2.0;
                stretch2 = 0.0 - expand;
                if (entityiterator instanceof TormentorLaserEntity) {
                    int n;
                    double d;
                    TormentorLaserEntity _datEntI;
                    double d2;
                    RandomSource randomSource = RandomSource.create();
                    if (entityiterator instanceof TormentorLaserEntity) {
                        TormentorLaserEntity _datEntI2 = (TormentorLaserEntity)entityiterator;
                        d2 = ((Integer)_datEntI2.getEntityData().get(TormentorLaserEntity.DATA_growspawn)).intValue();
                    } else {
                        d2 = 0.0;
                    }
                    if (entityiterator instanceof TormentorLaserEntity) {
                        _datEntI = (TormentorLaserEntity)entityiterator;
                        d = ((Integer)_datEntI.getEntityData().get(TormentorLaserEntity.DATA_growspawn)).intValue();
                    } else {
                        d = 0.0;
                    }
                    spheresize = Mth.nextDouble((RandomSource)randomSource, (double)d2, (double)d) / 10.0;
                    stretch2 = (0.0 - expand) / 5.0;
                    if (entityiterator instanceof TormentorLaserEntity) {
                        _datEntI = (TormentorLaserEntity)entityiterator;
                        n = (Integer)_datEntI.getEntityData().get(TormentorLaserEntity.DATA_timer);
                    } else {
                        n = 0;
                    }
                    if (n > 30) {
                        RenderSystem.defaultBlendFunc();
                        opacity = 30.0;
                        col_r = 200.0;
                        col_g = 20.0;
                        col_b = 20.0;
                    } else {
                        RenderSystem.defaultBlendFunc();
                        opacity = 80.0;
                        col_r = 230.0;
                        col_g = 100.0;
                        col_b = 100.0;
                    }
                } else {
                    col_r = 255.0;
                    col_g = 120.0;
                    col_b = 120.0;
                    if ("1.21.1".startsWith("1.19.")) {
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
                    } else {
                        RenderSystem.blendFuncSeparate((GlStateManager.SourceFactor)GlStateManager.SourceFactor.DST_COLOR, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
                    }
                }
                if (RenderTest7Procedure.begin(VertexFormat.Mode.QUADS, DefaultVertexFormat.POSITION_COLOR, true)) {
                    RenderTest7Procedure.add((float)posx, (float)stretch2, (float)negz, -1);
                    RenderTest7Procedure.add((float)posx, (float)stretch2, (float)posz, -1);
                    RenderTest7Procedure.add((float)negx, (float)stretch2, (float)posz, -1);
                    RenderTest7Procedure.add((float)negx, (float)stretch2, (float)negz, -1);
                    RenderTest7Procedure.add(0.5f, (float)stretch1, 0.5f, -1);
                    RenderTest7Procedure.add(0.5f, (float)stretch1, -0.5f, -1);
                    RenderTest7Procedure.add(-0.5f, (float)stretch1, -0.5f, -1);
                    RenderTest7Procedure.add(-0.5f, (float)stretch1, 0.5f, -1);
                    RenderTest7Procedure.add(0.5f, (float)stretch1, -0.5f, -1);
                    RenderTest7Procedure.add((float)posx, (float)stretch2, (float)negz, -1);
                    RenderTest7Procedure.add((float)negx, (float)stretch2, (float)negz, -1);
                    RenderTest7Procedure.add(-0.5f, (float)stretch1, -0.5f, -1);
                    RenderTest7Procedure.add(-0.5f, (float)stretch1, 0.5f, -1);
                    RenderTest7Procedure.add((float)negx, (float)stretch2, (float)posz, -1);
                    RenderTest7Procedure.add((float)posx, (float)stretch2, (float)posz, -1);
                    RenderTest7Procedure.add(0.5f, (float)stretch1, 0.5f, -1);
                    RenderTest7Procedure.add(0.5f, (float)stretch1, 0.5f, -1);
                    RenderTest7Procedure.add((float)posx, (float)stretch2, (float)posz, -1);
                    RenderTest7Procedure.add((float)posx, (float)stretch2, (float)negz, -1);
                    RenderTest7Procedure.add(0.5f, (float)stretch1, -0.5f, -1);
                    RenderTest7Procedure.add(-0.5f, (float)stretch1, -0.5f, -1);
                    RenderTest7Procedure.add((float)negx, (float)stretch2, (float)negz, -1);
                    RenderTest7Procedure.add((float)negx, (float)stretch2, (float)posz, -1);
                    RenderTest7Procedure.add(-0.5f, (float)stretch1, 0.5f, -1);
                    RenderTest7Procedure.end();
                }
                if (!RenderTest7Procedure.target(2)) continue;
                RenderTest7Procedure.renderShape(RenderTest7Procedure.shape(), entityiterator.getX(), entityiterator.getY() + y_offset, entityiterator.getZ(), entityiterator.getYRot(), entityiterator.getXRot() - 90.0f, 0.0f, (float)spheresize, (float)spheresize, (float)spheresize, (int)opacity << 24 | (int)col_r << 16 | (int)col_g << 8 | (int)col_b);
                RenderTest7Procedure.release();
            }
        }
    }
}

