/*
 * Decompiled with CFR 0.152.
 */
package net.arphex.procedures;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nullable;
import net.arphex.configuration.ConfigurationSettingsConfiguration;
import net.arphex.entity.TormentorTestEntity;
import net.arphex.init.ArphexModEntities;
import net.arphex.init.ArphexModItems;
import net.arphex.init.ArphexModMobEffects;
import net.arphex.network.ArphexModVariables;
import net.minecraft.client.CameraType;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.multiplayer.ClientLevel;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.block.BlockRenderDispatcher;
import net.minecraft.client.renderer.block.ModelBlockRenderer;
import net.minecraft.client.renderer.blockentity.BlockEntityRenderer;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.ItemRenderer;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.component.DataComponents;
import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.RandomSource;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.component.CustomData;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.ClipContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.WorldGenLevel;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.EntityBlock;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.bus.api.Event;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.capabilities.Capabilities;
import net.neoforged.neoforge.client.event.RenderLevelStageEvent;
import net.neoforged.neoforge.client.model.data.ModelData;
import net.neoforged.neoforge.items.IItemHandler;
import org.joml.Matrix4f;
import org.joml.Vector3f;

@EventBusSubscriber(value={Dist.CLIENT})
public class WorldRenderTestProcedure {
    private static RenderLevelStageEvent provider = null;
    private static Map<EntityType, Entity> data = new HashMap<EntityType, Entity>();

    public static void renderBackground(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        Vec3 pos = provider.getCamera().getPosition();
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, -scale, 1.0f);
        float f = (float)(font.width(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.translate(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.last().pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.drawInBatch(texts, 0.0f, 0.0f, 0, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.SEE_THROUGH, color, 0xF000F0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderBlock(BlockState blockState, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        BlockPos blockPos = BlockPos.containing((double)x, (double)y, (double)z);
        Vec3 pos = provider.getCamera().getPosition();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)Minecraft.getInstance().level, (BlockPos)blockPos);
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, scale, scale);
        poseStack.translate(-0.5f, -0.5f, -0.5f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        WorldRenderTestProcedure.renderBlockModel(blockState, blockPos, poseStack, packedLight);
        WorldRenderTestProcedure.renderBlockEntity(blockState, blockPos, poseStack, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    private static void renderBlockEntity(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        Block block = blockState.getBlock();
        if (block instanceof EntityBlock) {
            BlockEntityRenderer blockEntityRenderer;
            EntityBlock entityBlock = (EntityBlock)block;
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel level = minecraft.level;
            BlockEntity blockEntity = entityBlock.newBlockEntity(blockPos, blockState);
            if (blockEntity != null && (blockEntityRenderer = minecraft.getBlockEntityRenderDispatcher().getRenderer(blockEntity)) != null) {
                MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
                blockEntity.setLevel((Level)level);
                blockEntityRenderer.render(blockEntity, 0.0f, poseStack, (MultiBufferSource)bufferSource, packedLight, OverlayTexture.NO_OVERLAY);
            }
        }
    }

    private static void renderBlockModel(BlockState blockState, BlockPos blockPos, PoseStack poseStack, int packedLight) {
        if (blockState.getRenderShape() == RenderShape.MODEL) {
            Minecraft minecraft = Minecraft.getInstance();
            ClientLevel level = minecraft.level;
            MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
            BlockRenderDispatcher dispatcher = minecraft.getBlockRenderer();
            ModelBlockRenderer renderer = dispatcher.getModelRenderer();
            BakedModel bakedModel = dispatcher.getBlockModel(blockState);
            ModelData modelData = bakedModel.getModelData((BlockAndTintGetter)level, blockPos, blockState, ModelData.builder().build());
            PoseStack.Pose pose = poseStack.last();
            int color = minecraft.getBlockColors().getColor(blockState, (Level)level, blockPos);
            float red = (float)(color >> 16 & 0xFF) / 255.0f;
            float green = (float)(color >> 8 & 0xFF) / 255.0f;
            float blue = (float)(color & 0xFF) / 255.0f;
            for (RenderType renderType : bakedModel.getRenderTypes(blockState, RandomSource.create((long)42L), modelData)) {
                renderer.renderModel(pose, bufferSource.getBuffer(Sheets.translucentCullBlockSheet()), blockState, bakedModel, red, green, blue, packedLight, OverlayTexture.NO_OVERLAY, modelData, renderType);
            }
        }
    }

    public static void renderEntity(EntityType type, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        Entity entity;
        if (type == null) {
            return;
        }
        ClientLevel level = Minecraft.getInstance().level;
        if (data.containsKey(type)) {
            entity = data.get(type);
            if (entity.level() != level) {
                entity = type.create((Level)level);
                data.put(type, entity);
            }
        } else {
            entity = type.create((Level)level);
            data.put(type, entity);
        }
        WorldRenderTestProcedure.renderEntity(entity, 0.0f, x, y, z, yaw, pitch, roll, scale, glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)level, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z)));
    }

    public static void renderEntity(Entity entity, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean glowing) {
        float partialTick = provider.getPartialTick().getGameTimeDeltaPartialTick(false);
        int packedLight = glowing ? 0xF000F0 : Minecraft.getInstance().getEntityRenderDispatcher().getPackedLightCoords(entity, partialTick);
        WorldRenderTestProcedure.renderEntity(entity, partialTick, x, y, z, yaw, pitch, roll, scale, packedLight);
    }

    private static void renderEntity(Entity entity, float partialTick, double x, double y, double z, float yaw, float pitch, float roll, float scale, int packedLight) {
        if (entity == null) {
            return;
        }
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        EntityRenderer renderer = minecraft.getEntityRenderDispatcher().getRenderer(entity);
        Vec3 pos = provider.getCamera().getPosition();
        float offset = entity.getBbHeight() / 2.0f * scale;
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y + (double)offset - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.translate(0.0f, -offset, 0.0f);
        poseStack.scale(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.render(entity, entity.getViewYRot(partialTick), partialTick, poseStack, (MultiBufferSource)bufferSource, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderItem(ItemStack itemStack, double x, double y, double z, float yaw, float pitch, float roll, float scale, boolean flipping, boolean glowing) {
        Minecraft minecraft = Minecraft.getInstance();
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        ItemRenderer renderer = minecraft.getItemRenderer();
        Vec3 pos = provider.getCamera().getPosition();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)minecraft.level, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, scale, scale);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        renderer.renderStatic(null, itemStack, ItemDisplayContext.FIXED, flipping, poseStack, (MultiBufferSource)bufferSource, (Level)minecraft.level, packedLight, OverlayTexture.NO_OVERLAY, 0);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    public static void renderLine(double x1, double y1, double z1, double x2, double y2, double z2, int color) {
        MultiBufferSource.BufferSource bufferSource = Minecraft.getInstance().renderBuffers().bufferSource();
        Vec3 pos = provider.getCamera().getPosition();
        Vector3f normal = new Vec3(x2 - x1, y2 - y1, z2 - z1).normalize().toVector3f();
        Matrix4f matrix4f = provider.getPoseStack().last().pose();
        VertexConsumer vertexConsumer = bufferSource.getBuffer(RenderType.lines());
        vertexConsumer.addVertex(matrix4f, (float)(x1 - pos.x()), (float)(y1 - pos.y()), (float)(z1 - pos.z())).setColor(color).setNormal(normal.x(), normal.y(), normal.z());
        vertexConsumer.addVertex(matrix4f, (float)(x2 - pos.x()), (float)(y2 - pos.y()), (float)(z2 - pos.z())).setColor(color).setNormal(normal.x(), normal.y(), normal.z());
    }

    public static void renderTexts(String texts, double x, double y, double z, float yaw, float pitch, float roll, float scale, int color, boolean glowing) {
        Minecraft minecraft = Minecraft.getInstance();
        Font font = minecraft.font;
        MultiBufferSource.BufferSource bufferSource = minecraft.renderBuffers().bufferSource();
        Vec3 pos = provider.getCamera().getPosition();
        int packedLight = glowing ? 0xF000F0 : LevelRenderer.getLightColor((BlockAndTintGetter)minecraft.level, (BlockPos)BlockPos.containing((double)x, (double)y, (double)z));
        PoseStack poseStack = provider.getPoseStack();
        poseStack.pushPose();
        poseStack.translate(x - pos.x(), y - pos.y(), z - pos.z());
        poseStack.mulPose(Axis.YN.rotationDegrees(yaw));
        poseStack.mulPose(Axis.XP.rotationDegrees(pitch));
        poseStack.mulPose(Axis.ZN.rotationDegrees(roll));
        poseStack.scale(scale, -scale, 1.0f);
        float f = (float)(font.width(texts) - 1) * -0.5f;
        Objects.requireNonNull(font);
        poseStack.translate(f, (float)(9 - 1) * -0.5f, 0.0f);
        Matrix4f matrix4f = poseStack.last().pose();
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        font.drawInBatch(texts, 0.0f, 0.0f, color, false, matrix4f, (MultiBufferSource)bufferSource, Font.DisplayMode.NORMAL, 0, packedLight);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        poseStack.popPose();
    }

    @SubscribeEvent
    public static void renderModels(RenderLevelStageEvent event) {
        provider = event;
        if (provider.getStage() == RenderLevelStageEvent.Stage.AFTER_ENTITIES) {
            ClientLevel level = Minecraft.getInstance().level;
            Entity entity = provider.getCamera().getEntity();
            Vec3 pos = entity.getPosition(provider.getPartialTick().getGameTimeDeltaPartialTick(false));
            RenderSystem.depthMask((boolean)true);
            RenderSystem.enableDepthTest();
            WorldRenderTestProcedure.execute((Event)provider);
            RenderSystem.defaultBlendFunc();
            RenderSystem.disableBlend();
            RenderSystem.enableCull();
            RenderSystem.enableDepthTest();
            RenderSystem.depthMask((boolean)true);
        }
    }

    public static void execute() {
        WorldRenderTestProcedure.execute(null);
    }

    private static void execute(@Nullable Event event) {
        block83: {
            ItemStack itemStack;
            Level world;
            LocalPlayer entity;
            double zcalc;
            double ycalc;
            double xcalc;
            double dists;
            ItemStack warp_wayfinder;
            block86: {
                ItemStack itemStack2;
                ItemStack itemStack3;
                block85: {
                    List<Entity> _entfound;
                    Vec3 _center;
                    double z;
                    double y;
                    double x;
                    double max_mobs;
                    double colb;
                    double colg;
                    double colr;
                    block84: {
                        ItemStack itemStack4;
                        ItemStack itemStack5;
                        LivingEntity _livEnt23;
                        LivingEntity _livEnt19;
                        warp_wayfinder = ItemStack.EMPTY;
                        Entity render_entity = null;
                        Object nearest_render = null;
                        Object immortal_player = null;
                        dists = 0.0;
                        double dist_to_rendered = 0.0;
                        xcalc = 0.0;
                        ycalc = 0.0;
                        zcalc = 0.0;
                        double i = 0.0;
                        double j = 0.0;
                        double k = 0.0;
                        double l = 0.0;
                        colr = 0.0;
                        colg = 0.0;
                        colb = 0.0;
                        max_mobs = 0.0;
                        double col_b = 0.0;
                        double distance = 0.0;
                        double spheresize = 0.0;
                        double rotation_from_tormentor = 0.0;
                        double amplify = 0.0;
                        double max_entities = 0.0;
                        double col_g = 0.0;
                        double col_r = 0.0;
                        double opacity = 0.0;
                        double tormentor_distance = 0.0;
                        double yaw_offset = 0.0;
                        double coolsmooth = 0.0;
                        if (Minecraft.getInstance().player == null) break block83;
                        entity = Minecraft.getInstance().player;
                        x = entity.getX();
                        y = entity.getY();
                        z = entity.getZ();
                        world = entity.level();
                        ResourceKey dimension = entity.level().dimension();
                        if (((ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES)).immortal_near > 0.0) {
                            for (Entity entityiterator : new ArrayList(world.players())) {
                                LivingEntity _livEnt8;
                                ItemStack itemStack6;
                                if (!(Math.abs(entity.getX() - entityiterator.getX()) < 200.0) || !(Math.abs(entity.getY() - entityiterator.getY()) < 200.0) || !(Math.abs(entity.getZ() - entityiterator.getZ()) < 200.0)) continue;
                                render_entity = entityiterator;
                                if (!(((ArphexModVariables.PlayerVariables)render_entity.getData(ArphexModVariables.PLAYER_VARIABLES)).inherent_power_cooldown > 10800.0)) continue;
                                if (render_entity instanceof LivingEntity) {
                                    LivingEntity _entGetArmor = (LivingEntity)render_entity;
                                    itemStack6 = _entGetArmor.getItemBySlot(EquipmentSlot.CHEST);
                                } else {
                                    itemStack6 = ItemStack.EMPTY;
                                }
                                if (itemStack6.getItem() != ArphexModItems.IMMORTAL_CHESTPLATE.get() || render_entity instanceof LivingEntity && (_livEnt8 = (LivingEntity)render_entity).hasEffect(MobEffects.INVISIBILITY) || !(render_entity.getXRot() > -60.0f) || render_entity == (Entity)world.getEntitiesOfClass(Player.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)4.0, (double)4.0, (double)4.0), e -> true).stream().sorted(new Object(){

                                    Comparator<Entity> compareDistOf(double _x, double _y, double _z) {
                                        return Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_x, _y, _z));
                                    }
                                }.compareDistOf(x, y, z)).findFirst().orElse(null) && Minecraft.getInstance().options.getCameraType() != CameraType.THIRD_PERSON_FRONT) continue;
                                coolsmooth = Math.min(1.0, Math.max(0.0, (12000.0 - ((ArphexModVariables.PlayerVariables)render_entity.getData(ArphexModVariables.PLAYER_VARIABLES)).inherent_power_cooldown) / 12.0 / 10.0)) * Math.min(1.0, Math.max(0.0, (100.0 - (12000.0 - ((ArphexModVariables.PlayerVariables)render_entity.getData(ArphexModVariables.PLAYER_VARIABLES)).inherent_power_cooldown) / 12.0) / 10.0));
                                WorldRenderTestProcedure.renderEntity(render_entity, (double)render_entity.level().clip(new ClipContext(render_entity.getEyePosition(1.0f), render_entity.getEyePosition(1.0f).add(render_entity.getViewVector(1.0f).scale(0.0 - 3.0 * coolsmooth)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, render_entity)).getBlockPos().getX(), render_entity.getY(), (double)render_entity.level().clip(new ClipContext(render_entity.getEyePosition(1.0f), render_entity.getEyePosition(1.0f).add(render_entity.getViewVector(1.0f).scale(0.0 - 3.0 * coolsmooth)), ClipContext.Block.COLLIDER, ClipContext.Fluid.NONE, render_entity)).getBlockPos().getZ(), 0.0f, 0.0f, 0.0f, (float)(2.0 * coolsmooth), true);
                            }
                        }
                        if (((Boolean)ConfigurationSettingsConfiguration.SPECIAL_TORMENTOR_RENDERING.get()).booleanValue() && (ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_health > 0.0 || ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_entity_loaded > 0.0 || entity instanceof LivingEntity && (_livEnt19 = (LivingEntity)entity).hasEffect(ArphexModMobEffects.DISPLAY_TORMENTOR_INITIAL) && dimension == Level.OVERWORLD) && (ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_target_dimension.equals(((ArphexModVariables.PlayerVariables)entity.getData(ArphexModVariables.PLAYER_VARIABLES)).player_dimension) || entity instanceof LivingEntity && (_livEnt23 = (LivingEntity)entity).hasEffect(ArphexModMobEffects.DISPLAY_TORMENTOR_INITIAL))) {
                            dists = Math.sqrt((entity.getX() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x) * (entity.getX() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x) + (entity.getY() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_y) * (entity.getY() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_y) + (entity.getZ() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z) * (entity.getZ() - ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z));
                            xcalc = x + (ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x - x) / dists * (double)(Minecraft.getInstance().gameRenderer.getRenderDistance() + 100.0f);
                            ycalc = y + (ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_y - y) / dists * (double)(Minecraft.getInstance().gameRenderer.getRenderDistance() + 100.0f) + dists * 0.0025;
                            zcalc = z + (ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z - z) / dists * (double)(Minecraft.getInstance().gameRenderer.getRenderDistance() + 100.0f);
                            dist_to_rendered = Math.sqrt((entity.getX() - xcalc) * (entity.getX() - xcalc) + (entity.getY() - ycalc) * (entity.getY() - ycalc) + (entity.getZ() - zcalc) * (entity.getZ() - zcalc));
                            if (!world.getEntitiesOfClass(TormentorTestEntity.class, AABB.ofSize((Vec3)new Vec3(x, y, z), (double)100.0, (double)100.0, (double)100.0), e -> true).isEmpty()) {
                                RenderSystem.depthMask((boolean)true);
                                RenderSystem.enableDepthTest();
                                RenderSystem.disableCull();
                                if (dist_to_rendered > dists) {
                                    _center = new Vec3(x, y, z);
                                    _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(50.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                                    for (Entity entityiterator : _entfound) {
                                        Object object;
                                        if (!(entityiterator instanceof TormentorTestEntity)) continue;
                                        String string = entity.getStringUUID();
                                        if (entityiterator instanceof TormentorTestEntity) {
                                            _datEntS = (TormentorTestEntity)entityiterator;
                                            object = _datEntS.getEntityData().get(TormentorTestEntity.DATA_uuid_target);
                                        } else {
                                            object = "";
                                        }
                                        if (!string.equals(object)) continue;
                                        render_entity = entityiterator;
                                        break;
                                    }
                                    if (render_entity != null) {
                                        yaw_offset = ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_rotation;
                                        WorldRenderTestProcedure.renderEntity(render_entity, ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_x, ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_y, ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_z, (float)ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_rotation, 0.0f, 0.0f, 10000.0f, false);
                                    }
                                } else {
                                    _center = new Vec3(x, y, z);
                                    _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(50.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                                    for (Entity entityiterator : _entfound) {
                                        Object object;
                                        if (!(entityiterator instanceof TormentorTestEntity)) continue;
                                        String string = entity.getStringUUID();
                                        if (entityiterator instanceof TormentorTestEntity) {
                                            _datEntS = (TormentorTestEntity)entityiterator;
                                            object = _datEntS.getEntityData().get(TormentorTestEntity.DATA_uuid_target);
                                        } else {
                                            object = "";
                                        }
                                        if (!string.equals(object)) continue;
                                        render_entity = entityiterator;
                                        break;
                                    }
                                    if (render_entity != null) {
                                        yaw_offset = ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_rotation;
                                        WorldRenderTestProcedure.renderEntity(render_entity, xcalc, ycalc, zcalc, (float)ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_rotation, 0.0f, 0.0f, (float)(10000.0 * ((double)(Minecraft.getInstance().gameRenderer.getRenderDistance() + 100.0f) / dists)), false);
                                    }
                                }
                            }
                        }
                        if (!(ArphexModVariables.MapVariables.get((LevelAccessor)world).tormentor_health > 0.0)) {
                            if (entity.level().dimension() == ResourceKey.create((ResourceKey)Registries.DIMENSION, (ResourceLocation)ResourceLocation.parse((String)"arphex:the_crawling"))) {
                                WorldRenderTestProcedure.renderEntity((EntityType)ArphexModEntities.TORMENTOR_LOW_DISPLAY.get(), entity.getX() + 100.0, -300.0, entity.getZ(), 40.0f, 0.0f, 0.0f, 1.0f, false);
                            }
                            if (entity.level().dimension() == Level.OVERWORLD && world.dimensionType().moonPhase(world.dayTime()) == 0 && world.dayTime() > 14000L && world.dayTime() < 22000L) {
                                WorldRenderTestProcedure.renderEntity((EntityType)ArphexModEntities.TORMENTOR_LOW_DISPLAY.get(), entity.getX() + 100.0, entity.getY() + 600.0, entity.getZ(), 40.0f, 0.0f, 0.0f, 0.2f, false);
                            }
                        }
                        if (entity instanceof LivingEntity) {
                            LivingEntity _entGetArmor = (LivingEntity)entity;
                            itemStack5 = _entGetArmor.getItemBySlot(EquipmentSlot.HEAD);
                        } else {
                            itemStack5 = ItemStack.EMPTY;
                        }
                        if (itemStack5.getItem() == ArphexModItems.SPACETIME_HELMET.get()) break block84;
                        if (entity instanceof LivingEntity) {
                            LivingEntity _entGetArmor = (LivingEntity)entity;
                            itemStack4 = _entGetArmor.getItemBySlot(EquipmentSlot.HEAD);
                        } else {
                            itemStack4 = ItemStack.EMPTY;
                        }
                        if (itemStack4.getItem() != ArphexModItems.IMMORTAL_HELMET.get()) break block85;
                    }
                    if (entity.isShiftKeyDown()) {
                        max_mobs = 20.0;
                        _center = new Vec3(x, y, z);
                        _entfound = world.getEntitiesOfClass(Entity.class, new AABB(_center, _center).inflate(25.0), e -> true).stream().sorted(Comparator.comparingDouble(_entcnd -> _entcnd.distanceToSqr(_center))).toList();
                        for (Entity entityiterator : _entfound) {
                            float f;
                            float f2;
                            LivingEntity _livEnt;
                            if (!(max_mobs > 0.0) || entityiterator == entity || !(entityiterator instanceof LivingEntity) || entityiterator instanceof TormentorTestEntity) continue;
                            colr = 255.0;
                            colg = 255.0;
                            colb = 255.0;
                            if (entityiterator instanceof Monster) {
                                colr = 255.0;
                                colg = 0.0;
                                colb = 0.0;
                            }
                            if (entityiterator instanceof TamableAnimal) {
                                TamableAnimal _tamIsTamedBy = (TamableAnimal)entityiterator;
                                if (entity instanceof LivingEntity && _tamIsTamedBy.isOwnedBy(_livEnt = (LivingEntity)entity)) {
                                    colr = 0.0;
                                    colg = 255.0;
                                    colb = 0.0;
                                }
                            }
                            if (entityiterator instanceof Player) {
                                colr = 0.0;
                                colg = 0.0;
                                colb = 255.0;
                            }
                            max_mobs -= 1.0;
                            RenderSystem.depthMask((boolean)false);
                            RenderSystem.disableDepthTest();
                            if (entityiterator instanceof LivingEntity) {
                                _livEnt = (LivingEntity)entityiterator;
                                f2 = _livEnt.getHealth();
                            } else {
                                f2 = -1.0f;
                            }
                            int n = Math.round(f2);
                            if (entityiterator instanceof LivingEntity) {
                                LivingEntity _livEnt2 = (LivingEntity)entityiterator;
                                f = _livEnt2.getMaxHealth();
                            } else {
                                f = -1.0f;
                            }
                            WorldRenderTestProcedure.renderTexts(n + " / " + Math.round(f) + " \u2665", entityiterator.getX(), entityiterator.getY() + (double)entityiterator.getBbHeight() + 0.5, entityiterator.getZ(), (float)(Math.atan2(entity.getZ() - entityiterator.getZ(), entity.getX() - entityiterator.getX()) * 57.29577951308232 - 90.0), 0.0f, 0.0f, 0.025f, 0xFF000000 | (int)colr << 16 | (int)colg << 8 | (int)colb, true);
                        }
                    }
                }
                if (entity instanceof LivingEntity) {
                    LivingEntity _livEnt = (LivingEntity)entity;
                    itemStack3 = _livEnt.getMainHandItem();
                } else {
                    itemStack3 = ItemStack.EMPTY;
                }
                if (itemStack3.getItem() == ArphexModItems.WARP_WAYFINDER.get()) break block86;
                if (entity instanceof LivingEntity) {
                    LivingEntity _livEnt = (LivingEntity)entity;
                    itemStack2 = _livEnt.getOffhandItem();
                } else {
                    itemStack2 = ItemStack.EMPTY;
                }
                if (itemStack2.getItem() != ArphexModItems.WARP_WAYFINDER.get()) break block83;
            }
            if (entity instanceof LivingEntity) {
                LivingEntity _livEnt = (LivingEntity)entity;
                itemStack = _livEnt.getMainHandItem();
            } else {
                itemStack = ItemStack.EMPTY;
            }
            if (itemStack.getItem() == ArphexModItems.WARP_WAYFINDER.get()) {
                ItemStack itemStack7;
                if (entity instanceof LivingEntity) {
                    _livEnt = (LivingEntity)entity;
                    itemStack7 = _livEnt.getMainHandItem();
                } else {
                    itemStack7 = ItemStack.EMPTY;
                }
                warp_wayfinder = itemStack7;
            } else {
                ItemStack itemStack8;
                if (entity instanceof LivingEntity) {
                    _livEnt = (LivingEntity)entity;
                    itemStack8 = _livEnt.getOffhandItem();
                } else {
                    itemStack8 = ItemStack.EMPTY;
                }
                warp_wayfinder = itemStack8;
            }
            RenderSystem.disableCull();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            if (entity.getDeltaMovement().x() == 0.0 && entity.getDeltaMovement().z() == 0.0 && Math.abs(entity.getDeltaMovement().y()) < 0.08) {
                WorldGenLevel _wgl;
                Level _lvl;
                if (new Object(){

                    public ItemStack getItemStack(int sltid, ItemStack _isc) {
                        IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                        if (_itemHandler != null) {
                            return _itemHandler.getStackInSlot(sltid).copy();
                        }
                        return ItemStack.EMPTY;
                    }
                }.getItemStack(0, warp_wayfinder).getItem() != ItemStack.EMPTY.getItem() && (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_x") != 0.0 || ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_y") != 0.0 || ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_z") != 0.0)) {
                    ResourceKey resourceKey;
                    String string = ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("target_1_dimension");
                    if (world instanceof Level) {
                        _lvl = world;
                        resourceKey = _lvl.dimension();
                    } else if (world instanceof WorldGenLevel) {
                        _wgl = (WorldGenLevel)world;
                        resourceKey = _wgl.getLevel().dimension();
                    } else {
                        resourceKey = Level.OVERWORLD;
                    }
                    if (string.equals(String.valueOf(resourceKey))) {
                        dists = Math.sqrt((entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_x")) * (entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_x")) + (entity.getY() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_y")) * (entity.getY() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_y")) + (entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_z")) * (entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_z")));
                        xcalc = entity.getX() + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_x") + 0.5 - entity.getX()) / dists * 1.0;
                        ycalc = entity.getY() + (double)entity.getBbHeight() * 0.9 + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_y") + 0.5 - entity.getY()) / dists * 1.0;
                        zcalc = entity.getZ() + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_z") + 0.5 - entity.getZ()) / dists * 1.0;
                        if (3.0 > dists) {
                            if (new Object(){

                                public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                    IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                    if (_itemHandler != null) {
                                        return _itemHandler.getStackInSlot(sltid).copy();
                                    }
                                    return ItemStack.EMPTY;
                                }
                            }.getItemStack(0, warp_wayfinder).getItem() != Items.NAME_TAG) {
                                WorldRenderTestProcedure.renderItem(new Object(){

                                    public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                        IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                        if (_itemHandler != null) {
                                            return _itemHandler.getStackInSlot(sltid).copy();
                                        }
                                        return ItemStack.EMPTY;
                                    }
                                }.getItemStack(0, warp_wayfinder), ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_x") + 0.5, ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_y") + 2.0, ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_z") + 0.5, (float)(Math.atan2(entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_z"), entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_x")) * 57.29577951308232 - 90.0), 0.0f, 0.0f, 1.0f, false, true);
                            }
                        } else {
                            WorldRenderTestProcedure.renderTexts(new Object(){

                                public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                    IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                    if (_itemHandler != null) {
                                        return _itemHandler.getStackInSlot(sltid).copy();
                                    }
                                    return ItemStack.EMPTY;
                                }
                            }.getItemStack(0, warp_wayfinder).getDisplayName().getString().replace("]", "").replace("[", ""), xcalc, ycalc + 0.1, zcalc, (float)(Math.atan2(entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_z"), entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_x")) * 57.29577951308232 - 90.0), 0.0f, 0.0f, 0.002f, -1, true);
                            if (new Object(){

                                public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                    IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                    if (_itemHandler != null) {
                                        return _itemHandler.getStackInSlot(sltid).copy();
                                    }
                                    return ItemStack.EMPTY;
                                }
                            }.getItemStack(0, warp_wayfinder).getItem() != Items.NAME_TAG) {
                                WorldRenderTestProcedure.renderItem(new Object(){

                                    public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                        IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                        if (_itemHandler != null) {
                                            return _itemHandler.getStackInSlot(sltid).copy();
                                        }
                                        return ItemStack.EMPTY;
                                    }
                                }.getItemStack(0, warp_wayfinder), xcalc, ycalc, zcalc, (float)(Math.atan2(entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_z"), entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_1_x")) * 57.29577951308232 - 90.0), 0.0f, 0.0f, 0.1f, false, true);
                            }
                        }
                    }
                }
                if (new Object(){

                    public ItemStack getItemStack(int sltid, ItemStack _isc) {
                        IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                        if (_itemHandler != null) {
                            return _itemHandler.getStackInSlot(sltid).copy();
                        }
                        return ItemStack.EMPTY;
                    }
                }.getItemStack(1, warp_wayfinder).getItem() != ItemStack.EMPTY.getItem() && (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_x") != 0.0 || ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_y") != 0.0 || ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_z") != 0.0)) {
                    ResourceKey resourceKey;
                    String string = ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("target_2_dimension");
                    if (world instanceof Level) {
                        _lvl = world;
                        resourceKey = _lvl.dimension();
                    } else if (world instanceof WorldGenLevel) {
                        _wgl = (WorldGenLevel)world;
                        resourceKey = _wgl.getLevel().dimension();
                    } else {
                        resourceKey = Level.OVERWORLD;
                    }
                    if (string.equals(String.valueOf(resourceKey))) {
                        dists = Math.sqrt((entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_x")) * (entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_x")) + (entity.getY() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_y")) * (entity.getY() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_y")) + (entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_z")) * (entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_z")));
                        xcalc = entity.getX() + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_x") + 0.5 - entity.getX()) / dists * 1.0;
                        ycalc = entity.getY() + (double)entity.getBbHeight() * 0.9 + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_y") + 0.5 - entity.getY()) / dists * 1.0;
                        zcalc = entity.getZ() + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_z") + 0.5 - entity.getZ()) / dists * 1.0;
                        if (5.0 > dists) {
                            if (new Object(){

                                public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                    IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                    if (_itemHandler != null) {
                                        return _itemHandler.getStackInSlot(sltid).copy();
                                    }
                                    return ItemStack.EMPTY;
                                }
                            }.getItemStack(1, warp_wayfinder).getItem() != Items.NAME_TAG) {
                                WorldRenderTestProcedure.renderItem(new Object(){

                                    public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                        IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                        if (_itemHandler != null) {
                                            return _itemHandler.getStackInSlot(sltid).copy();
                                        }
                                        return ItemStack.EMPTY;
                                    }
                                }.getItemStack(1, warp_wayfinder), ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_x") + 0.5, ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_y") + 2.0, ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_z") + 0.5, (float)(Math.atan2(entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_z"), entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_x")) * 57.29577951308232 - 90.0), 0.0f, 0.0f, 1.0f, false, true);
                            }
                        } else {
                            WorldRenderTestProcedure.renderTexts(new Object(){

                                public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                    IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                    if (_itemHandler != null) {
                                        return _itemHandler.getStackInSlot(sltid).copy();
                                    }
                                    return ItemStack.EMPTY;
                                }
                            }.getItemStack(1, warp_wayfinder).getDisplayName().getString().replace("]", "").replace("[", ""), xcalc, ycalc + 0.1, zcalc, (float)(Math.atan2(entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_z"), entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_x")) * 57.29577951308232 - 90.0), 0.0f, 0.0f, 0.002f, -1, true);
                            if (new Object(){

                                public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                    IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                    if (_itemHandler != null) {
                                        return _itemHandler.getStackInSlot(sltid).copy();
                                    }
                                    return ItemStack.EMPTY;
                                }
                            }.getItemStack(1, warp_wayfinder).getItem() != Items.NAME_TAG) {
                                WorldRenderTestProcedure.renderItem(new Object(){

                                    public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                        IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                        if (_itemHandler != null) {
                                            return _itemHandler.getStackInSlot(sltid).copy();
                                        }
                                        return ItemStack.EMPTY;
                                    }
                                }.getItemStack(1, warp_wayfinder), xcalc, ycalc, zcalc, (float)(Math.atan2(entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_z"), entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_2_x")) * 57.29577951308232 - 90.0), 0.0f, 0.0f, 0.1f, false, true);
                            }
                        }
                    }
                }
                if (new Object(){

                    public ItemStack getItemStack(int sltid, ItemStack _isc) {
                        IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                        if (_itemHandler != null) {
                            return _itemHandler.getStackInSlot(sltid).copy();
                        }
                        return ItemStack.EMPTY;
                    }
                }.getItemStack(2, warp_wayfinder).getItem() != ItemStack.EMPTY.getItem() && (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_x") != 0.0 || ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_y") != 0.0 || ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_z") != 0.0)) {
                    ResourceKey resourceKey;
                    String string = ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getString("target_3_dimension");
                    if (world instanceof Level) {
                        _lvl = world;
                        resourceKey = _lvl.dimension();
                    } else if (world instanceof WorldGenLevel) {
                        _wgl = (WorldGenLevel)world;
                        resourceKey = _wgl.getLevel().dimension();
                    } else {
                        resourceKey = Level.OVERWORLD;
                    }
                    if (string.equals(String.valueOf(resourceKey))) {
                        dists = Math.sqrt((entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_x")) * (entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_x")) + (entity.getY() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_y")) * (entity.getY() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_y")) + (entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_z")) * (entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_z")));
                        xcalc = entity.getX() + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_x") + 0.5 - entity.getX()) / dists * 1.0;
                        ycalc = entity.getY() + (double)entity.getBbHeight() * 0.9 + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_y") + 0.5 - entity.getY()) / dists * 1.0;
                        zcalc = entity.getZ() + (((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_z") + 0.5 - entity.getZ()) / dists * 1.0;
                        if (5.0 > dists) {
                            if (new Object(){

                                public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                    IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                    if (_itemHandler != null) {
                                        return _itemHandler.getStackInSlot(sltid).copy();
                                    }
                                    return ItemStack.EMPTY;
                                }
                            }.getItemStack(2, warp_wayfinder).getItem() != Items.NAME_TAG) {
                                WorldRenderTestProcedure.renderItem(new Object(){

                                    public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                        IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                        if (_itemHandler != null) {
                                            return _itemHandler.getStackInSlot(sltid).copy();
                                        }
                                        return ItemStack.EMPTY;
                                    }
                                }.getItemStack(2, warp_wayfinder), ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_x") + 0.5, ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_y") + 2.0, ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_z") + 0.5, (float)(Math.atan2(entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_z"), entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_x")) * 57.29577951308232 - 90.0), 0.0f, 0.0f, 1.0f, false, true);
                            }
                        } else {
                            WorldRenderTestProcedure.renderTexts(new Object(){

                                public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                    IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                    if (_itemHandler != null) {
                                        return _itemHandler.getStackInSlot(sltid).copy();
                                    }
                                    return ItemStack.EMPTY;
                                }
                            }.getItemStack(2, warp_wayfinder).getDisplayName().getString().replace("]", "").replace("[", ""), xcalc, ycalc + 0.1, zcalc, (float)(Math.atan2(entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_z"), entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_x")) * 57.29577951308232 - 90.0), 0.0f, 0.0f, 0.002f, -1, true);
                            if (new Object(){

                                public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                    IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                    if (_itemHandler != null) {
                                        return _itemHandler.getStackInSlot(sltid).copy();
                                    }
                                    return ItemStack.EMPTY;
                                }
                            }.getItemStack(2, warp_wayfinder).getItem() != Items.NAME_TAG) {
                                WorldRenderTestProcedure.renderItem(new Object(){

                                    public ItemStack getItemStack(int sltid, ItemStack _isc) {
                                        IItemHandler _itemHandler = (IItemHandler)_isc.getCapability(Capabilities.ItemHandler.ITEM, null);
                                        if (_itemHandler != null) {
                                            return _itemHandler.getStackInSlot(sltid).copy();
                                        }
                                        return ItemStack.EMPTY;
                                    }
                                }.getItemStack(2, warp_wayfinder), xcalc, ycalc, zcalc, (float)(Math.atan2(entity.getZ() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_z"), entity.getX() - ((CustomData)warp_wayfinder.getOrDefault(DataComponents.CUSTOM_DATA, (Object)CustomData.EMPTY)).copyTag().getDouble("target_3_x")) * 57.29577951308232 - 90.0), 0.0f, 0.0f, 0.1f, false, true);
                            }
                        }
                    }
                }
            }
        }
    }
}

