/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness;

import com.corosus.coroutil.util.CU;
import com.corosus.zombieawareness.config.ZAConfigClient;
import com.corosus.zombieawareness.config.ZAConfigGeneral;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;

public class EntityScent
extends Entity {
    public boolean isUsed = false;
    private static final EntityDataAccessor<Integer> STRENGTH_PEAK = SynchedEntityData.defineId(EntityScent.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Integer> AGE = SynchedEntityData.defineId(EntityScent.class, (EntityDataSerializer)EntityDataSerializers.INT);
    private static final EntityDataAccessor<Byte> TYPE = SynchedEntityData.defineId(EntityScent.class, (EntityDataSerializer)EntityDataSerializers.BYTE);
    public long lastBuffTime = 0L;
    public float lastMultiply = 1.0f;
    public static int MAX_AGE = 600;

    public EntityScent(EntityType<EntityScent> entityScentEntityType, Level var1) {
        super(entityScentEntityType, var1);
    }

    protected void defineSynchedData(SynchedEntityData.Builder builder) {
        builder.define(STRENGTH_PEAK, (Object)0);
        builder.define(AGE, (Object)0);
        builder.define(TYPE, (Object)0);
    }

    public boolean canBeCollidedWith() {
        return false;
    }

    public boolean isSteppingCarefully() {
        return true;
    }

    public boolean shouldRender(double p_145770_1_, double p_145770_3_, double p_145770_5_) {
        return true;
    }

    public boolean shouldRenderAtSqrDistance(double p_70112_1_) {
        return true;
    }

    public float getRange() {
        float range = (float)this.getStrengthScaled() / 100.0f * (float)ZAConfigGeneral.maxPFRangeSense;
        return range;
    }

    public void setStrengthPeak(int strength) {
        int strTry = strength;
        if (strTry > ZAConfigGeneral.senseMaxStrength) {
            strTry = ZAConfigGeneral.senseMaxStrength;
        }
        this.getEntityData().set(STRENGTH_PEAK, (Object)strTry);
        this.resetAge();
    }

    public void resetAge() {
        this.getEntityData().set(AGE, (Object)MAX_AGE);
    }

    public int getStrengthPeak() {
        return (Integer)this.getEntityData().get(STRENGTH_PEAK);
    }

    public int getStrengthScaled() {
        return (int)((double)((Integer)this.getEntityData().get(STRENGTH_PEAK)).intValue() * this.getAgeScale());
    }

    public double getAgeScale() {
        return (double)((Integer)this.getEntityData().get(AGE)).intValue() / (double)MAX_AGE;
    }

    public void tick() {
        boolean scentDebug;
        int decayRate;
        int age = (Integer)this.getEntityData().get(AGE);
        int n = decayRate = this.level().isRaining() && this.level().canSeeSky(this.blockPosition()) ? 3 : 1;
        if ((age -= decayRate) < 0) {
            age = 0;
        }
        this.getEntityData().set(AGE, (Object)age);
        if (!this.level().isClientSide() && age <= 0) {
            this.kill();
        }
        if ((scentDebug = ZAConfigClient.client_debugSensesVisual) && this.level().isClientSide() && this.level().getGameTime() % 5L == 0L) {
            for (int i = 0; i < this.getStrengthScaled() / 10; ++i) {
                double range = 1.0;
                double x = this.getX() - CU.rand().nextDouble() / 2.0 + CU.rand().nextDouble();
                double y = this.getY() - CU.rand().nextDouble() / 2.0 + CU.rand().nextDouble();
                double z = this.getZ() - CU.rand().nextDouble() / 2.0 + CU.rand().nextDouble();
                if (this.getSenseType() == 0) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.HEART, true, x, y, z, 0.0, 0.0, 0.0);
                    continue;
                }
                if (this.getSenseType() == 1) {
                    this.level().addParticle((ParticleOptions)ParticleTypes.NOTE, true, x, y, z, 0.0, 0.0, 0.0);
                    continue;
                }
                if (this.getSenseType() != 2) continue;
                this.level().addParticle((ParticleOptions)ParticleTypes.ANGRY_VILLAGER, true, x, y, z, 0.0, 0.0, 0.0);
            }
        }
    }

    public int getSenseType() {
        return ((Byte)this.getEntityData().get(TYPE)).byteValue();
    }

    public void setSenseType(int type) {
        this.getEntityData().set(TYPE, (Object)((byte)type));
    }

    protected void addAdditionalSaveData(CompoundTag var1) {
        var1.putInt("age", ((Integer)this.getEntityData().get(AGE)).intValue());
        var1.putInt("strengthpeak", ((Integer)this.getEntityData().get(STRENGTH_PEAK)).intValue());
        var1.putInt("type", this.getSenseType());
    }

    protected void readAdditionalSaveData(CompoundTag var1) {
        this.getEntityData().set(AGE, (Object)var1.getInt("age"));
        this.getEntityData().set(STRENGTH_PEAK, (Object)var1.getInt("strengthpeak"));
        this.getEntityData().set(TYPE, (Object)var1.getByte("type"));
    }
}

