/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness;

import com.corosus.modconfig.CoroConfigRegistry;
import com.corosus.modconfig.IConfigCategory;
import com.corosus.zombieawareness.EntityScent;
import com.corosus.zombieawareness.ZAUtil;
import com.corosus.zombieawareness.config.ZAConfigClient;
import com.corosus.zombieawareness.config.ZAConfigFeatures;
import com.corosus.zombieawareness.config.ZAConfigGeneral;
import com.corosus.zombieawareness.config.ZAConfigPlayerLists;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.players.PlayerList;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;

public abstract class ZombieAwareness {
    public static final String MODID = "zombieawareness";
    private static ZombieAwareness instance;
    public HashMap<String, SoundEvent> lookupStringToEvent = new HashMap();
    public static ResourceLocation SENSE_NAME;
    public static EntityType<EntityScent> SENSE;
    public static HashMap<UUID, CompoundTag> entityData;
    public static HashMap<String, Boolean> unitTest;
    public static List<String> enhanceableMobsList;

    public static ZombieAwareness instance() {
        return instance;
    }

    public static void unitTest(String num) {
    }

    public CompoundTag getPersistentData(Entity ent) {
        if (!entityData.containsKey(ent.getUUID())) {
            entityData.put(ent.getUUID(), new CompoundTag());
        }
        return entityData.get(ent.getUUID());
    }

    public CompoundTag setPersistentData(Entity ent, CompoundTag compoundTag) {
        return entityData.put(ent.getUUID(), compoundTag);
    }

    public ZombieAwareness() {
        instance = this;
        new File("./config/zombieawareness").mkdirs();
        CoroConfigRegistry.instance().addConfigFile(MODID, (IConfigCategory)new ZAConfigGeneral());
        CoroConfigRegistry.instance().addConfigFile(MODID, (IConfigCategory)new ZAConfigClient());
        CoroConfigRegistry.instance().addConfigFile(MODID, (IConfigCategory)new ZAConfigFeatures());
        CoroConfigRegistry.instance().addConfigFile(MODID, (IConfigCategory)new ZAConfigPlayerLists());
        ZombieAwareness.generateEntityTickList();
    }

    public abstract PlayerList getPlayerList();

    public abstract boolean isModInstalled(String var1);

    public static void serverStarting() {
        ZombieAwareness.clearConfigCache();
    }

    public static void clearConfigCache() {
        ZAUtil.lookupTickableEntitiesCache.clear();
    }

    public static void dbg(Object obj) {
        if (ZAConfigGeneral.debugConsole) {
            System.out.println(obj);
        }
    }

    public static boolean canProcessEntity(Entity ent) {
        if (!ZombieAwareness.canEntityBeProcessedOverride(ent)) {
            return false;
        }
        return ZombieAwareness.canProcessEntity(ent.getType(), false);
    }

    public static boolean canProcessEntity(EntityType ent, boolean pregen) {
        String entName = ZombieAwareness.getEntityRegisteredName(ent);
        if (ZAUtil.lookupTickableEntitiesCache.containsKey(ent)) {
            return ZAUtil.lookupTickableEntitiesCache.get(ent);
        }
        boolean result = false;
        if (ZombieAwareness.canConfigEntity(ent)) {
            boolean canProcess = ZombieAwareness.getDefaultForEntity(ent);
            try {
                if (entName != null && !entName.equals("")) {
                    result = canProcess;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
            ZAUtil.lookupTickableEntitiesCache.put(ent, result);
        }
        return result;
    }

    public static boolean canEntityBeProcessedOverride(Entity entity) {
        return true;
    }

    public static boolean canConfigEntity(EntityType ent) {
        return ent.getCategory() == MobCategory.MONSTER;
    }

    public static boolean getDefaultForEntity(EntityType ent) {
        if (ZombieAwareness.canConfigEntity(ent)) {
            return ZombieAwareness.instance().getEnhancedMobs().contains(BuiltInRegistries.ENTITY_TYPE.getKey((Object)ent).toString());
        }
        return false;
    }

    public static List<String> getListFromCSV(String csv) {
        return Stream.of(csv.split(",")).map(String::trim).collect(Collectors.toList());
    }

    public static String getEntityRegisteredName(EntityType ent) {
        try {
            return BuiltInRegistries.ENTITY_TYPE.getKey((Object)ent).toString();
        }
        catch (Exception ex) {
            if (ZAConfigGeneral.debugConsole) {
                ex.printStackTrace();
            }
            return ent.getClass().getSimpleName();
        }
    }

    public static void generateEntityTickList() {
        for (Map.Entry entry : BuiltInRegistries.ENTITY_TYPE.entrySet()) {
            boolean tickEnt = ZombieAwareness.canConfigEntity((EntityType)entry.getValue());
            if (!tickEnt) continue;
            enhanceableMobsList.add(((ResourceKey)entry.getKey()).location().toString());
        }
    }

    public void init() {
        this.register("alert");
        this.register("target");
        this.register("investigate");
    }

    public SoundEvent register(String name) {
        SoundEvent event = SoundEvent.createVariableRangeEvent((ResourceLocation)ResourceLocation.fromNamespaceAndPath((String)MODID, (String)name));
        this.lookupStringToEvent.put(name, event);
        return event;
    }

    public SoundEvent getSound(String soundPath) {
        return this.lookupStringToEvent.get(soundPath);
    }

    public abstract List<? extends String> getEnhancedMobs();

    static {
        SENSE_NAME = ResourceLocation.fromNamespaceAndPath((String)MODID, (String)"scent");
        entityData = new HashMap();
        unitTest = new HashMap();
        enhanceableMobsList = new ArrayList<String>();
    }
}

