/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombieawareness.client;

import com.corosus.zombieawareness.EntityScent;
import com.corosus.zombieawareness.config.ZAConfigClient;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.texture.OverlayTexture;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.VoxelShape;

public class RenderScent
extends EntityRenderer {
    public static ResourceLocation TEXTURE64 = ResourceLocation.fromNamespaceAndPath((String)"zombieawareness", (String)"textures/entities/bloodx64.png");
    private static final RenderType SHADOW_RENDER_TYPE = RenderType.entityShadow((ResourceLocation)TEXTURE64);

    public RenderScent(EntityRendererProvider.Context p_i46179_1_) {
        super(p_i46179_1_);
    }

    public ResourceLocation getTextureLocation(Entity p_110775_1_) {
        return TEXTURE64;
    }

    public void render(Entity pEntity, float pEntityYaw, float pPartialTicks, PoseStack pMatrixStack, MultiBufferSource pBuffer, int pPackedLight) {
        super.render(pEntity, pEntityYaw, pPartialTicks, pMatrixStack, pBuffer, pPackedLight);
        float shadowSize = 1.0f;
        float shadowStrength = 1.0f;
        this.shadowStrength = 1.0f;
        this.shadowRadius = 1.0f;
        if (ZAConfigClient.client_renderBlood && ((EntityScent)pEntity).getSenseType() == 0) {
            float scale = 0.7f + (float)((EntityScent)pEntity).getAgeScale() * 0.3f;
            float alpha = (float)((EntityScent)pEntity).getAgeScale();
            RenderScent.renderBlood(pMatrixStack, pBuffer, pEntity, shadowStrength, pPartialTicks, (LevelReader)pEntity.level(), scale, alpha);
        }
        this.shadowStrength = 0.0f;
        this.shadowRadius = 0.0f;
    }

    private static void renderBlood(PoseStack p_229096_0_, MultiBufferSource p_229096_1_, Entity p_229096_2_, float p_229096_3_, float p_229096_4_, LevelReader p_229096_5_, float p_229096_6_, float alpha) {
        Mob mobentity;
        float f = p_229096_6_;
        if (p_229096_2_ instanceof Mob && (mobentity = (Mob)p_229096_2_).isBaby()) {
            f = p_229096_6_ * 0.5f;
        }
        double d2 = Mth.lerp((double)p_229096_4_, (double)p_229096_2_.xOld, (double)p_229096_2_.getX());
        double d0 = Mth.lerp((double)p_229096_4_, (double)p_229096_2_.yOld, (double)p_229096_2_.getY());
        double d1 = Mth.lerp((double)p_229096_4_, (double)p_229096_2_.zOld, (double)p_229096_2_.getZ());
        int i = Mth.floor((double)(d2 - (double)f));
        int j = Mth.floor((double)(d2 + (double)f));
        int k = Mth.floor((double)(d0 - (double)f));
        int l = Mth.floor((double)d0);
        int i1 = Mth.floor((double)(d1 - (double)f));
        int j1 = Mth.floor((double)(d1 + (double)f));
        PoseStack.Pose matrixstack$entry = p_229096_0_.last();
        VertexConsumer ivertexbuilder = p_229096_1_.getBuffer(SHADOW_RENDER_TYPE);
        Tesselator tessellator = Tesselator.getInstance();
        for (BlockPos blockpos : BlockPos.betweenClosed((BlockPos)new BlockPos(i, k, i1), (BlockPos)new BlockPos(j, l, j1))) {
            RenderScent.renderBlockShadow(matrixstack$entry, ivertexbuilder, p_229096_5_, blockpos, d2, d0, d1, f, p_229096_3_, alpha);
        }
        Camera camera = Minecraft.getInstance().gameRenderer.getMainCamera();
    }

    private static void renderBlockShadow(PoseStack.Pose p_229092_0_, VertexConsumer p_229092_1_, LevelReader p_229092_2_, BlockPos p_229092_3_, double p_229092_4_, double p_229092_6_, double p_229092_8_, float p_229092_10_, float p_229092_11_, float alpha) {
        float f;
        VoxelShape voxelshape;
        BlockPos blockpos = p_229092_3_.below();
        BlockState blockstate = p_229092_2_.getBlockState(blockpos);
        float light = 0.5f;
        if (blockstate.isCollisionShapeFullBlock((BlockGetter)p_229092_2_, blockpos) && !(voxelshape = blockstate.getShape((BlockGetter)p_229092_2_, p_229092_3_.below())).isEmpty() && (f = alpha) >= 0.0f) {
            if (f > 1.0f) {
                f = 1.0f;
            }
            AABB axisalignedbb = voxelshape.bounds();
            double d0 = (double)p_229092_3_.getX() + axisalignedbb.minX;
            double d1 = (double)p_229092_3_.getX() + axisalignedbb.maxX;
            double d2 = (double)p_229092_3_.getY() + axisalignedbb.minY;
            double d3 = (double)p_229092_3_.getZ() + axisalignedbb.minZ;
            double d4 = (double)p_229092_3_.getZ() + axisalignedbb.maxZ;
            float f1 = (float)(d0 - p_229092_4_);
            float f2 = (float)(d1 - p_229092_4_);
            float f3 = (float)(d2 - p_229092_6_);
            float f4 = (float)(d3 - p_229092_8_);
            float f5 = (float)(d4 - p_229092_8_);
            float f6 = -f1 / 2.0f / p_229092_10_ + 0.5f;
            float f7 = -f2 / 2.0f / p_229092_10_ + 0.5f;
            float f8 = -f4 / 2.0f / p_229092_10_ + 0.5f;
            float f9 = -f5 / 2.0f / p_229092_10_ + 0.5f;
            RenderScent.shadowVertex(p_229092_0_, p_229092_1_, f, f1, f3, f4, f6, f8, light);
            RenderScent.shadowVertex(p_229092_0_, p_229092_1_, f, f1, f3, f5, f6, f9, light);
            RenderScent.shadowVertex(p_229092_0_, p_229092_1_, f, f2, f3, f5, f7, f9, light);
            RenderScent.shadowVertex(p_229092_0_, p_229092_1_, f, f2, f3, f4, f7, f8, light);
        }
    }

    private static void shadowVertex(PoseStack.Pose p_229091_0_, VertexConsumer p_229091_1_, float p_229091_2_, float p_229091_3_, float p_229091_4_, float p_229091_5_, float p_229091_6_, float p_229091_7_, float light) {
        p_229091_1_.addVertex(p_229091_0_.pose(), p_229091_3_, p_229091_4_, p_229091_5_).setColor(1.0f * light, 1.0f * light, 1.0f * light, p_229091_2_).setUv(p_229091_6_, p_229091_7_).setOverlay(OverlayTexture.NO_OVERLAY).setLight(0xF000F0).setNormal(p_229091_0_, 0.0f, 1.0f, 0.0f);
    }
}

