/*
 * Decompiled with CFR 0.152.
 */
package fuzs.puzzleslib.api.config.v3.json;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.stream.JsonWriter;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import fuzs.puzzleslib.impl.PuzzlesLib;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.io.Writer;
import java.nio.file.Path;
import java.util.Optional;
import java.util.function.Supplier;
import net.minecraft.util.GsonHelper;

public final class GsonCodecHelper {
    public static final Gson GSON = new GsonBuilder().setPrettyPrinting().disableHtmlEscaping().create();

    private GsonCodecHelper() {
    }

    public static <T> boolean saveIfAbsent(Codec<T> codec, Supplier<T> value, Path path) {
        return !path.toFile().exists() && GsonCodecHelper.save(codec, value.get(), path);
    }

    public static <T> boolean save(Codec<T> codec, T value, Path path) {
        boolean bl;
        path.toFile().getParentFile().mkdirs();
        JsonWriter jsonWriter = new JsonWriter((Writer)new FileWriter(path.toFile()));
        try {
            jsonWriter.setSerializeNulls(false);
            jsonWriter.setIndent("  ");
            JsonElement jsonElement = (JsonElement)codec.encodeStart((DynamicOps)JsonOps.INSTANCE, value).getOrThrow();
            GsonHelper.writeValue((JsonWriter)jsonWriter, (JsonElement)jsonElement, null);
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    jsonWriter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                PuzzlesLib.LOGGER.error("Failed to write file at {}", (Object)path, (Object)e);
                return false;
            }
        }
        jsonWriter.close();
        return bl;
    }

    public static <T> T load(Codec<T> codec, Supplier<T> value, Path path) {
        GsonCodecHelper.saveIfAbsent(codec, value, path);
        return GsonCodecHelper.load(codec, path).orElseGet(value);
    }

    public static <T> Optional<T> load(Codec<T> codec, Path path) {
        Optional optional;
        FileReader fileReader = new FileReader(path.toFile());
        try {
            JsonElement jsonElement = (JsonElement)GsonHelper.fromJson((Gson)GSON, (Reader)fileReader, JsonElement.class);
            optional = codec.parse((DynamicOps)JsonOps.INSTANCE, (Object)jsonElement).resultOrPartial();
        }
        catch (Throwable throwable) {
            try {
                try {
                    fileReader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                PuzzlesLib.LOGGER.error("Failed to read file at {}", (Object)path, (Object)e);
                return Optional.empty();
            }
        }
        fileReader.close();
        return optional;
    }
}

