/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.api.utils;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.scores.PlayerTeam;
import net.minecraft.world.scores.Team;

@ParametersAreNonnullByDefault
public class PlayerUtils {
    public static void resetFloatingState(@Nullable Entity player) {
        if (player instanceof ServerPlayer) {
            ConnectionAccess access = (ConnectionAccess)((ServerPlayer)player).connection;
            access.setClientIsFloating(false);
            access.setAboveGroundTickCount(0);
        }
    }

    public static boolean isAllied(Entity instance, Entity target) {
        OwnableEntity ownable;
        LivingEntity owner;
        if (instance.equals((Object)target)) {
            return true;
        }
        PlayerTeam team = instance.getTeam();
        if (team != null && team.isAlliedTo((Team)target.getTeam())) {
            return true;
        }
        if (target instanceof OwnableEntity && (owner = (ownable = (OwnableEntity)target).getOwner()) != null) {
            if (instance.equals((Object)owner)) {
                return true;
            }
            return team != null && team.isAlliedTo((Team)owner.getTeam());
        }
        return false;
    }

    public static interface ConnectionAccess {
        public void setClientIsFloating(boolean var1);

        public void setAboveGroundTickCount(int var1);
    }
}

