/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.models.obj.callback.block;

import blusunrize.immersiveengineering.api.IEProperties;
import blusunrize.immersiveengineering.api.client.ieobj.BlockCallback;
import blusunrize.immersiveengineering.api.utils.DirectionUtils;
import blusunrize.immersiveengineering.common.blocks.generic.PostBlock;
import blusunrize.immersiveengineering.common.register.IEBlocks;
import java.util.ArrayList;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;

public class PostCallbacks
implements BlockCallback<Key> {
    public static final PostCallbacks INSTANCE = new PostCallbacks();

    @Override
    public Key extractKey(@Nonnull BlockAndTintGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state, BlockEntity blockEntity) {
        int height = (Integer)state.getValue((Property)PostBlock.POST_SLAVE);
        BlockPos centerPos = pos.subtract(((PostBlock.HorizontalOffset)((Object)state.getValue(PostBlock.HORIZONTAL_OFFSET))).getOffset());
        BlockState centerState = level.getBlockState(centerPos);
        EnumSet<Direction> connections = EnumSet.noneOf(Direction.class);
        EnumSet<Direction> downArms = EnumSet.noneOf(Direction.class);
        if (centerState.getBlock() == state.getBlock()) {
            for (Direction f : DirectionUtils.BY_HORIZONTAL_INDEX) {
                BlockPos armPos;
                if (!PostBlock.hasConnection(centerState, f, (BlockGetter)level, centerPos)) continue;
                connections.add(f);
                if (height != 3 || !PostBlock.hasConnection(level.getBlockState(armPos = centerPos.relative(f)), Direction.DOWN, (BlockGetter)level, armPos)) continue;
                downArms.add(f);
            }
        }
        return new Key(state, connections, downArms);
    }

    @Override
    public Key getDefaultKey() {
        return new Key(IEBlocks.WoodenDecoration.TREATED_POST.defaultBlockState(), EnumSet.noneOf(Direction.class), EnumSet.noneOf(Direction.class));
    }

    @Override
    public IEProperties.IEObjState getIEOBJState(Key key) {
        ArrayList<String> visible = new ArrayList<String>();
        visible.add("base");
        int height = (Integer)key.state().getValue((Property)PostBlock.POST_SLAVE);
        for (Direction f : key.connections()) {
            String name = f.getOpposite().getSerializedName();
            if (height == 3) {
                if (key.downArms().contains(f)) {
                    visible.add("arm_" + name + "_down");
                    continue;
                }
                visible.add("arm_" + name + "_up");
                continue;
            }
            visible.add("con_" + (height - 1) + "_" + name);
        }
        return new IEProperties.IEObjState(IEProperties.VisibilityList.show(visible));
    }

    public record Key(BlockState state, EnumSet<Direction> connections, EnumSet<Direction> downArms) {
    }
}

