/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.client.render.entity;

import blusunrize.immersiveengineering.api.IEApi;
import blusunrize.immersiveengineering.api.tool.RailgunHandler;
import blusunrize.immersiveengineering.client.utils.IERenderTypes;
import blusunrize.immersiveengineering.client.utils.TransformingVertexBuilder;
import blusunrize.immersiveengineering.common.entities.RailgunShotEntity;
import com.mojang.blaze3d.vertex.PoseStack;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import org.joml.Quaternionf;

public class RailgunShotRenderer
extends EntityRenderer<RailgunShotEntity> {
    private static final RailgunHandler.RailgunRenderColors DEFAULT_RENDER_COLORS = new RailgunHandler.RailgunRenderColors(0x686868, 0xA4A4A4, 0xA4A4A4, 0xA4A4A4, 0x686868);

    public RailgunShotRenderer(EntityRendererProvider.Context renderManager) {
        super(renderManager);
    }

    public void render(RailgunShotEntity entity, float entityYaw, float partialTicks, PoseStack matrixStackIn, MultiBufferSource bufferIn, int packedLightIn) {
        RailgunHandler.IRailgunProjectile prop;
        double yaw = entity.yRotO + (entity.getYRot() - entity.yRotO) * partialTicks - 90.0f;
        double pitch = entity.xRotO + (entity.getXRot() - entity.xRotO) * partialTicks;
        ItemStack ammo = entity.getAmmo();
        RailgunHandler.RailgunRenderColors colors = DEFAULT_RENDER_COLORS;
        if (!ammo.isEmpty() && (prop = RailgunHandler.getProjectile(ammo)) instanceof RailgunHandler.StandardRailgunProjectile && ((RailgunHandler.StandardRailgunProjectile)prop).getColorMap() != null) {
            colors = ((RailgunHandler.StandardRailgunProjectile)prop).getColorMap();
        }
        RailgunShotRenderer.renderRailgunProjectile(yaw, pitch, colors, matrixStackIn, bufferIn, packedLightIn);
    }

    public static void renderRailgunProjectile(double yaw, double pitch, RailgunHandler.RailgunRenderColors colors, PoseStack matrixStackIn, MultiBufferSource bufferIn, int light) {
        int[] rgb;
        int i;
        matrixStackIn.pushPose();
        matrixStackIn.mulPose(new Quaternionf().rotateY((float)Math.toRadians(yaw)).rotateZ((float)Math.toRadians(pitch)));
        matrixStackIn.scale(0.25f, 0.25f, 0.25f);
        float height = 0.1875f;
        float halfWidth = height / 2.0f;
        float length = 2.0f;
        int colWidth = colors.getGradientLength();
        int colLength = colors.getRingCount();
        float widthStep = height / (float)colWidth;
        float lengthStep = length / (float)colLength;
        matrixStackIn.translate(-length * 0.85f, 0.0f, 0.0f);
        TransformingVertexBuilder builder = new TransformingVertexBuilder(bufferIn, IERenderTypes.POSITION_COLOR_LIGHTMAP, matrixStackIn);
        builder.setDefaultLight(light);
        for (i = 0; i < colWidth; ++i) {
            rgb = colors.getFrontColor(i);
            builder.addVertex(0.0f, height, -halfWidth + widthStep * (float)i).setColor(rgb[0], rgb[1], rgb[2], 255);
            builder.addVertex(0.0f, 0.0f, -halfWidth + widthStep * (float)i).setColor(rgb[0], rgb[1], rgb[2], 255);
            builder.addVertex(0.0f, 0.0f, -halfWidth + widthStep * (float)(i + 1)).setColor(rgb[0], rgb[1], rgb[2], 255);
            builder.addVertex(0.0f, height, -halfWidth + widthStep * (float)(i + 1)).setColor(rgb[0], rgb[1], rgb[2], 255);
            rgb = colors.getBackColor(i);
            builder.addVertex(length, 0.0f, -halfWidth + widthStep * (float)i).setColor(rgb[0], rgb[1], rgb[2], 255);
            builder.addVertex(length, height, -halfWidth + widthStep * (float)i).setColor(rgb[0], rgb[1], rgb[2], 255);
            builder.addVertex(length, height, -halfWidth + widthStep * (float)(i + 1)).setColor(rgb[0], rgb[1], rgb[2], 255);
            builder.addVertex(length, 0.0f, -halfWidth + widthStep * (float)(i + 1)).setColor(rgb[0], rgb[1], rgb[2], 255);
        }
        for (i = 0; i < colLength; ++i) {
            rgb = colors.getRingColor(i, 0);
            builder.addVertex(lengthStep * (float)i, 0.0f, -halfWidth).setColor(rgb[0], rgb[1], rgb[2], 255);
            builder.addVertex(lengthStep * (float)i, height, -halfWidth).setColor(rgb[0], rgb[1], rgb[2], 255);
            builder.addVertex(lengthStep * (float)(i + 1), height, -halfWidth).setColor(rgb[0], rgb[1], rgb[2], 255);
            builder.addVertex(lengthStep * (float)(i + 1), 0.0f, -halfWidth).setColor(rgb[0], rgb[1], rgb[2], 255);
            rgb = colors.getRingColor(i, colWidth - 1);
            builder.addVertex(lengthStep * (float)i, height, halfWidth).setColor(rgb[0], rgb[1], rgb[2], 255);
            builder.addVertex(lengthStep * (float)i, 0.0f, halfWidth).setColor(rgb[0], rgb[1], rgb[2], 255);
            builder.addVertex(lengthStep * (float)(i + 1), 0.0f, halfWidth).setColor(rgb[0], rgb[1], rgb[2], 255);
            builder.addVertex(lengthStep * (float)(i + 1), height, halfWidth).setColor(rgb[0], rgb[1], rgb[2], 255);
        }
        for (i = 0; i < colLength; ++i) {
            for (int j = 0; j < colWidth; ++j) {
                rgb = colors.getRingColor(i, j);
                builder.addVertex(lengthStep * (float)(i + 1), height, -halfWidth + widthStep * (float)j).setColor(rgb[0], rgb[1], rgb[2], 255);
                builder.addVertex(lengthStep * (float)i, height, -halfWidth + widthStep * (float)j).setColor(rgb[0], rgb[1], rgb[2], 255);
                builder.addVertex(lengthStep * (float)i, height, -halfWidth + widthStep * (float)(j + 1)).setColor(rgb[0], rgb[1], rgb[2], 255);
                builder.addVertex(lengthStep * (float)(i + 1), height, -halfWidth + widthStep * (float)(j + 1)).setColor(rgb[0], rgb[1], rgb[2], 255);
                builder.addVertex(lengthStep * (float)i, 0.0f, -halfWidth + widthStep * (float)j).setColor(rgb[0], rgb[1], rgb[2], 255);
                builder.addVertex(lengthStep * (float)(i + 1), 0.0f, -halfWidth + widthStep * (float)j).setColor(rgb[0], rgb[1], rgb[2], 255);
                builder.addVertex(lengthStep * (float)(i + 1), 0.0f, -halfWidth + widthStep * (float)(j + 1)).setColor(rgb[0], rgb[1], rgb[2], 255);
                builder.addVertex(lengthStep * (float)i, 0.0f, -halfWidth + widthStep * (float)(j + 1)).setColor(rgb[0], rgb[1], rgb[2], 255);
            }
        }
        matrixStackIn.popPose();
    }

    public ResourceLocation getTextureLocation(@Nonnull RailgunShotEntity entity) {
        return IEApi.ieLoc("textures/models/white.png");
    }
}

