/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.gui.sync;

import blusunrize.immersiveengineering.api.utils.codec.IEStreamCodecs;
import blusunrize.immersiveengineering.common.blocks.wooden.SorterBlockEntity;
import blusunrize.immersiveengineering.common.gui.ArcFurnaceMenu;
import blusunrize.immersiveengineering.common.gui.ChunkLoaderMenu;
import blusunrize.immersiveengineering.common.gui.MixerMenu;
import blusunrize.immersiveengineering.common.gui.RadioTowerMenu;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.UnaryOperator;
import net.minecraft.core.BlockPos;
import net.minecraft.network.RegistryFriendlyByteBuf;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.neoforged.neoforge.fluids.FluidStack;

public class GenericDataSerializers {
    private static final List<DataSerializer<?>> SERIALIZERS = new ArrayList();
    public static final DataSerializer<Integer> INT32 = GenericDataSerializers.register(ByteBufCodecs.INT);
    public static final DataSerializer<FluidStack> FLUID_STACK = GenericDataSerializers.register(FluidStack.OPTIONAL_STREAM_CODEC, FluidStack::copy, FluidStack::matches);
    public static final DataSerializer<Boolean> BOOLEAN = GenericDataSerializers.register(ByteBufCodecs.BOOL);
    public static final DataSerializer<Float> FLOAT = GenericDataSerializers.register(ByteBufCodecs.FLOAT);
    public static final DataSerializer<Optional<ResourceLocation>> OPTIONAL_RESOURCE_LOCATION = GenericDataSerializers.register(ByteBufCodecs.optional((StreamCodec)ResourceLocation.STREAM_CODEC));
    public static final DataSerializer<List<ArcFurnaceMenu.ProcessSlot>> ARC_PROCESS_SLOTS = GenericDataSerializers.register(ArcFurnaceMenu.ProcessSlot.STREAM_CODEC.apply(ByteBufCodecs.list()));
    public static final DataSerializer<ItemStack> ITEM_STACK = GenericDataSerializers.register(ItemStack.OPTIONAL_STREAM_CODEC, ItemStack::copy, ItemStack::matches);
    public static final DataSerializer<List<ItemStack>> ITEM_STACKS = GenericDataSerializers.register(ItemStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()));
    public static final DataSerializer<byte[]> BYTE_ARRAY = GenericDataSerializers.register(ByteBufCodecs.BYTE_ARRAY, arr -> Arrays.copyOf(arr, ((byte[])arr).length), Arrays::equals);
    public static final DataSerializer<int[]> INT_ARRAY = GenericDataSerializers.register(IEStreamCodecs.VAR_INT_ARRAY_STREAM_CODEC, arr -> Arrays.copyOf(arr, ((int[])arr).length), Arrays::equals);
    public static final DataSerializer<List<FluidStack>> FLUID_STACKS = GenericDataSerializers.register(FluidStack.OPTIONAL_STREAM_CODEC.apply(ByteBufCodecs.list()), l -> l.stream().map(FluidStack::copy).toList(), (l1, l2) -> {
        if (l1.size() != l2.size()) {
            return false;
        }
        for (int i = 0; i < l1.size(); ++i) {
            if (FluidStack.matches((FluidStack)((FluidStack)l1.get(i)), (FluidStack)((FluidStack)l2.get(i)))) continue;
            return false;
        }
        return true;
    });
    public static final DataSerializer<List<MixerMenu.SlotProgress>> MIXER_SLOTS = GenericDataSerializers.register(MixerMenu.SlotProgress.STREAM_CODEC.apply(ByteBufCodecs.list()));
    public static final DataSerializer<List<String>> STRINGS = GenericDataSerializers.register(ByteBufCodecs.stringUtf8((int)512).apply(ByteBufCodecs.list()), ArrayList::new, List::equals);
    public static final DataSerializer<RadioTowerMenu.NearbyComponents> RADIO_TOWER_NEARBY = GenericDataSerializers.register(RadioTowerMenu.NearbyComponents.STREAM_CODEC);
    public static final DataSerializer<SorterBlockEntity.FilterConfig> FILTER_CONFIG = GenericDataSerializers.register(SorterBlockEntity.FilterConfig.CODEC.streamCodec());
    public static final DataSerializer<List<ChunkLoaderMenu.NearbyBlockEntity>> NEARBY_BLOCK_ENTITIES = GenericDataSerializers.register(ChunkLoaderMenu.NearbyBlockEntity.STREAM_CODEC.apply(ByteBufCodecs.list()));
    public static final DataSerializer<BlockPos> BLOCK_POS = GenericDataSerializers.register(BlockPos.STREAM_CODEC);

    private static <T> DataSerializer<T> register(StreamCodec<? super RegistryFriendlyByteBuf, T> codec) {
        return GenericDataSerializers.register(codec, t -> t, Objects::equals);
    }

    private static <T> DataSerializer<T> register(StreamCodec<? super RegistryFriendlyByteBuf, T> codec, UnaryOperator<T> copy, BiPredicate<T, T> equals) {
        DataSerializer<T> serializer = new DataSerializer<T>(codec, copy, equals, SERIALIZERS.size());
        SERIALIZERS.add(serializer);
        return serializer;
    }

    public record DataSerializer<T>(StreamCodec<? super RegistryFriendlyByteBuf, T> codec, UnaryOperator<T> copy, BiPredicate<T, T> equals, int id) {
        private DataPair<T> read(RegistryFriendlyByteBuf from) {
            return new DataPair<Object>(this, this.codec.decode((Object)from));
        }
    }

    public record DataPair<T>(DataSerializer<T> serializer, T data) {
        public static final StreamCodec<RegistryFriendlyByteBuf, DataPair<?>> CODEC = new StreamCodec<RegistryFriendlyByteBuf, DataPair<?>>(){

            public DataPair<?> decode(RegistryFriendlyByteBuf buffer) {
                DataSerializer<?> serializer = SERIALIZERS.get(buffer.readVarInt());
                return serializer.read(buffer);
            }

            public void encode(RegistryFriendlyByteBuf buffer, DataPair<?> data) {
                data.write(buffer);
            }
        };

        private void write(RegistryFriendlyByteBuf to) {
            to.writeVarInt(this.serializer.id());
            this.serializer.codec.encode((Object)to, this.data);
        }
    }
}

