/*
 * Decompiled with CFR 0.152.
 */
package blusunrize.immersiveengineering.common.network;

import blusunrize.immersiveengineering.ImmersiveEngineering;
import blusunrize.immersiveengineering.common.blocks.IEBaseBlockEntity;
import blusunrize.immersiveengineering.common.network.IMessage;
import io.netty.buffer.ByteBuf;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.codec.ByteBufCodecs;
import net.minecraft.network.codec.StreamCodec;
import net.minecraft.network.protocol.common.custom.CustomPacketPayload;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.neoforged.fml.LogicalSide;
import net.neoforged.neoforge.network.handling.IPayloadContext;
import org.jetbrains.annotations.NotNull;

public record MessageBlockEntitySync(BlockPos pos, CompoundTag nbt) implements IMessage
{
    public static final CustomPacketPayload.Type<MessageBlockEntitySync> ID = IMessage.createType("be_sync");
    public static final StreamCodec<ByteBuf, MessageBlockEntitySync> CODEC = StreamCodec.composite((StreamCodec)BlockPos.STREAM_CODEC, MessageBlockEntitySync::pos, (StreamCodec)ByteBufCodecs.COMPOUND_TAG, MessageBlockEntitySync::nbt, MessageBlockEntitySync::new);

    public MessageBlockEntitySync(BlockEntity be, CompoundTag nbt) {
        this(be.getBlockPos(), nbt);
    }

    @Override
    public void process(IPayloadContext context) {
        if (context.flow().getReceptionSide() == LogicalSide.SERVER) {
            context.enqueueWork(() -> {
                BlockEntity tile;
                Level world = context.player().level();
                if (world.isAreaLoaded(this.pos, 1) && (tile = world.getBlockEntity(this.pos)) instanceof IEBaseBlockEntity) {
                    ((IEBaseBlockEntity)tile).receiveMessageFromClient(this.nbt);
                }
            });
        } else {
            context.enqueueWork(() -> {
                BlockEntity tile;
                Level world = ImmersiveEngineering.proxy.getClientWorld();
                if (world != null && (tile = world.getBlockEntity(this.pos)) instanceof IEBaseBlockEntity) {
                    ((IEBaseBlockEntity)tile).receiveMessageFromServer(this.nbt);
                }
            });
        }
    }

    @NotNull
    public CustomPacketPayload.Type<? extends CustomPacketPayload> type() {
        return ID;
    }
}

