/*
 * Decompiled with CFR 0.152.
 */
package dev.protomanly.pmweather.block;

import com.mojang.serialization.MapCodec;
import dev.protomanly.pmweather.block.entity.ModBlockEntities;
import dev.protomanly.pmweather.block.entity.RadarBlockEntity;
import dev.protomanly.pmweather.config.ServerConfig;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RadarBlock
extends BaseEntityBlock {
    public static EnumProperty<Mode> RADAR_MODE = EnumProperty.create((String)"mode", Mode.class);
    public static BooleanProperty ON = BooleanProperty.create((String)"on");
    public static final MapCodec<RadarBlock> CODEC = RadarBlock.simpleCodec(RadarBlock::new);

    protected RadarBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.defaultBlockState().setValue(RADAR_MODE, (Comparable)((Object)Mode.REFLECTIVITY))).setValue((Property)ON, (Comparable)Boolean.valueOf(true)));
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        super.createBlockStateDefinition(builder);
        builder.add(new Property[]{RADAR_MODE});
        builder.add(new Property[]{ON});
    }

    protected RenderShape getRenderShape(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> getTicker(Level level, BlockState state, BlockEntityType<T> blockEntityType) {
        return RadarBlock.createTickerHelper(blockEntityType, ModBlockEntities.RADAR_BE.get(), (level1, blockPos, blockState, blockEntity) -> blockEntity.tick(level1, blockPos, blockState));
    }

    @NotNull
    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltipComponents, TooltipFlag tooltipFlag) {
        super.appendHoverText(stack, context, tooltipComponents, tooltipFlag);
        if (ServerConfig.requireWSR88D) {
            tooltipComponents.add((Component)Component.literal((String)"Requires a completed WSR-88D nearby to function"));
        }
    }

    protected InteractionResult useWithoutItem(BlockState state, Level level, BlockPos pos, Player player, BlockHitResult hitResult) {
        if (!level.isClientSide()) {
            Mode newMode = (Mode)((Object)state.getValue(RADAR_MODE));
            newMode = switch (newMode.ordinal()) {
                case 0 -> Mode.VELOCITY;
                case 1 -> Mode.IR;
                default -> Mode.REFLECTIVITY;
            };
            level.setBlockAndUpdate(pos, (BlockState)state.setValue(RADAR_MODE, (Comparable)((Object)newMode)));
            if (player.isCrouching()) {
                level.setBlockAndUpdate(pos, (BlockState)state.setValue((Property)ON, (Comparable)Boolean.valueOf((Boolean)state.getValue((Property)ON) == false)));
            }
        }
        return InteractionResult.SUCCESS_NO_ITEM_USED;
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos blockPos, BlockState blockState) {
        return new RadarBlockEntity(blockPos, blockState);
    }

    public static enum Mode implements StringRepresentable
    {
        REFLECTIVITY("reflectivity"),
        VELOCITY("velocity"),
        IR("ir");

        private final String mode;

        private Mode(String mode) {
            this.mode = mode;
        }

        @NotNull
        public String getSerializedName() {
            return this.mode;
        }
    }
}

