/*
 * Decompiled with CFR 0.152.
 */
package dev.protomanly.pmweather.util;

import java.awt.Color;
import net.minecraft.util.Mth;

public class ColorTables {
    public static Color getReflectivity(float val, Color startColor) {
        Color color = startColor;
        color = ColorTables.lerp(Math.clamp(val / 19.0f, 0.0f, 1.0f), color, new Color(6069678));
        color = ColorTables.lerp(Math.clamp((val - 19.0f) / 8.0f, 0.0f, 1.0f), color, new Color(746505));
        color = ColorTables.lerp(Math.clamp((val - 27.0f) / 13.0f, 0.0f, 1.0f), color, new Color(12956416));
        if (val >= 40.0f) {
            color = new Color(16421888);
        }
        color = ColorTables.lerp(Math.clamp((val - 40.0f) / 10.0f, 0.0f, 1.0f), color, new Color(11688204));
        if (val >= 50.0f) {
            color = new Color(16327435);
        }
        color = ColorTables.lerp(Math.clamp((val - 50.0f) / 10.0f, 0.0f, 1.0f), color, new Color(0x822820));
        if (val >= 60.0f) {
            color = new Color(13277620);
        }
        color = ColorTables.lerp(Math.clamp((val - 60.0f) / 10.0f, 0.0f, 1.0f), color, new Color(12721266));
        if (val >= 70.0f) {
            color = new Color(0xFFFFFF);
        }
        return color;
    }

    public static Color getIR(float val) {
        Color color = new Color(0, 0, 0);
        color = ColorTables.lerp(Math.clamp(val / 100.0f, 0.0f, 1.0f), color, new Color(255, 255, 255));
        if (val > 100.0f) {
            color = ColorTables.lerp(Math.clamp((val - 100.0f) / 20.0f, 0.0f, 1.0f), color, new Color(0, 16, 116));
            color = ColorTables.lerp(Math.clamp((val - 120.0f) / 20.0f, 0.0f, 1.0f), color, new Color(105, 248, 251));
            color = ColorTables.lerp(Math.clamp((val - 140.0f) / 10.0f, 0.0f, 1.0f), color, new Color(0, 253, 0));
            color = ColorTables.lerp(Math.clamp((val - 150.0f) / 10.0f, 0.0f, 1.0f), color, new Color(253, 251, 71));
            color = ColorTables.lerp(Math.clamp((val - 160.0f) / 20.0f, 0.0f, 1.0f), color, new Color(235, 55, 23));
            color = ColorTables.lerp(Math.clamp((val - 180.0f) / 20.0f, 0.0f, 1.0f), color, new Color(110, 26, 10));
            color = ColorTables.lerp(Math.clamp((val - 200.0f) / 20.0f, 0.0f, 1.0f), color, new Color(0, 0, 0));
            color = ColorTables.lerp(Math.clamp((val - 220.0f) / 40.0f, 0.0f, 1.0f), color, new Color(255, 255, 255));
        }
        return color;
    }

    public static Color getMixedReflectivity(float val) {
        Color color = new Color(255, 255, 255, 0);
        color = ColorTables.lerp(Math.clamp(val / 70.0f, 0.0f, 1.0f), color, new Color(0, 111, 255, 255));
        return color;
    }

    public static Color getSnowReflectivity(float val) {
        Color color = new Color(250, 195, 248, 0);
        color = ColorTables.lerp(Math.clamp(val / 70.0f, 0.0f, 1.0f), color, new Color(210, 0, 210, 255));
        return color;
    }

    public static Color getVelocity(float velocity) {
        Color color = new Color(150, 150, 150);
        if (velocity > 0.0f) {
            color = new Color(9074294);
            color = ColorTables.lerp(Math.clamp(velocity / 12.0f, 0.0f, 1.0f), color, new Color(8665153));
            if (velocity > 12.0f) {
                color = new Color(0x6E0000);
            }
            color = ColorTables.lerp(Math.clamp((velocity - 12.0f) / 27.0f, 0.0f, 1.0f), color, new Color(15925255));
            if (velocity > 39.0f) {
                color = new Color(16398161);
            }
            color = ColorTables.lerp(Math.clamp((velocity - 39.0f) / 30.0f, 0.0f, 1.0f), color, new Color(16771235));
            color = ColorTables.lerp(Math.clamp((velocity - 69.0f) / 71.0f, 0.0f, 1.0f), color, new Color(6751746));
        } else if (velocity < 0.0f) {
            velocity = Mth.abs((float)velocity);
            color = new Color(7505264);
            color = ColorTables.lerp(Math.clamp(velocity / 12.0f, 0.0f, 1.0f), color, new Color(5142860));
            if (velocity > 12.0f) {
                color = new Color(353795);
            }
            color = ColorTables.lerp(Math.clamp((velocity - 12.0f) / 69.0f, 0.0f, 1.0f), color, new Color(0x30E0E3));
            color = ColorTables.lerp(Math.clamp((velocity - 81.0f) / 25.0f, 0.0f, 1.0f), color, new Color(1442457));
            color = ColorTables.lerp(Math.clamp((velocity - 106.0f) / 34.0f, 0.0f, 1.0f), color, new Color(16711812));
        }
        return color;
    }

    public static Color getWindspeed(float val) {
        Color color = new Color(0, 0, 0);
        color = ColorTables.lerp((val - 45.0f) / 20.0f, color, new Color(106, 128, 241));
        color = ColorTables.lerp((val - 65.0f) / 20.0f, color, new Color(117, 243, 224));
        color = ColorTables.lerp((val - 85.0f) / 25.0f, color, new Color(116, 241, 81));
        color = ColorTables.lerp((val - 110.0f) / 25.0f, color, new Color(246, 220, 53));
        color = ColorTables.lerp((val - 135.0f) / 30.0f, color, new Color(246, 127, 53));
        color = ColorTables.lerp((val - 165.0f) / 35.0f, color, new Color(246, 53, 53));
        color = ColorTables.lerp((val - 200.0f) / 50.0f, color, new Color(240, 53, 246));
        color = ColorTables.lerp((val - 250.0f) / 50.0f, color, new Color(255, 255, 255));
        return color;
    }

    public static Color getSST(float val) {
        Color color = new Color(253, 253, 253);
        color = ColorTables.lerp(val / 10.0f, color, new Color(102, 77, 166));
        if (val >= 10.0f) {
            color = new Color(108, 157, 233);
            color = ColorTables.lerp((val - 10.0f) / 10.0f, color, new Color(109, 253, 253));
        }
        if (val >= 20.0f) {
            color = new Color(109, 253, 253);
            color = ColorTables.lerp((val - 20.0f) / 6.0f, color, new Color(11, 163, 50));
        }
        if (val >= 26.0f) {
            color = new Color(253, 253, 0);
            color = ColorTables.lerp((val - 26.0f) / 4.0f, color, new Color(167, 0, 0));
        }
        if (val >= 30.0f) {
            color = new Color(167, 0, 67);
            color = ColorTables.lerp((val - 30.0f) / 3.0f, color, new Color(217, 0, 253));
        }
        return color;
    }

    public static Color getHurricaneWindspeed(float val) {
        Color color = new Color(253, 253, 253);
        color = ColorTables.lerp(val / 39.0f, color, new Color(40, 116, 222));
        if (val >= 39.0f) {
            color = new Color(155, 191, 130);
            color = ColorTables.lerp((val - 39.0f) / 19.0f, color, new Color(118, 163, 87));
        }
        if (val >= 58.0f) {
            color = new Color(69, 114, 42);
            color = ColorTables.lerp((val - 58.0f) / 16.0f, color, new Color(129, 166, 44));
        }
        if (val >= 74.0f) {
            color = new Color(235, 191, 70);
            color = ColorTables.lerp((val - 74.0f) / 22.0f, color, new Color(186, 143, 35));
        }
        if (val >= 96.0f) {
            color = new Color(220, 146, 64);
            color = ColorTables.lerp((val - 96.0f) / 15.0f, color, new Color(171, 97, 22));
        }
        if (val >= 111.0f) {
            color = new Color(190, 38, 0);
            color = ColorTables.lerp((val - 111.0f) / 19.0f, color, new Color(143, 26, 0));
        }
        if (val >= 130.0f) {
            color = new Color(156, 83, 118);
            color = ColorTables.lerp((val - 130.0f) / 27.0f, color, new Color(108, 36, 68));
        }
        if (val >= 157.0f) {
            color = new Color(96, 83, 162);
            color = ColorTables.lerp((val - 157.0f) / 18.0f, color, new Color(47, 36, 113));
        }
        if (val >= 175.0f) {
            color = new Color(28, 23, 74);
            color = ColorTables.lerp((val - 175.0f) / 25.0f, color, new Color(101, 101, 101));
        }
        if (val >= 200.0f) {
            color = new Color(255, 255, 255);
            color = ColorTables.lerp((val - 200.0f) / 100.0f, color, new Color(0, 0, 0));
        }
        return color;
    }

    public static Color lerp(float delta, Color c1, Color c2) {
        delta = Mth.clamp((float)delta, (float)0.0f, (float)1.0f);
        return new Color((int)Mth.lerp((float)delta, (float)c1.getRed(), (float)c2.getRed()), (int)Mth.lerp((float)delta, (float)c1.getGreen(), (float)c2.getGreen()), (int)Mth.lerp((float)delta, (float)c1.getBlue(), (float)c2.getBlue()));
    }
}

