/*
 * Decompiled with CFR 0.152.
 */
package dev.protomanly.pmweather.weather;

import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.util.ShaderCompatibleNoise;
import dev.protomanly.pmweather.weather.Storm;
import dev.protomanly.pmweather.weather.WeatherHandler;
import net.minecraft.util.Mth;
import org.joml.Vector2f;
import org.joml.Vector2fc;
import org.joml.Vector3f;

public class Clouds {
    public static float getCloudDensity(WeatherHandler weatherHandler, Vector2f location, float partialTicks) {
        float c = 0.0f;
        long seed = weatherHandler.seed;
        float worldTime = (float)weatherHandler.getWorld().getGameTime() + (float)seed / 1.0E14f + partialTicks;
        Vector3f noisePos = new Vector3f(location.x + worldTime, (float)ServerConfig.layer0Height, location.y + worldTime);
        Vector3f cloudNoisePos = new Vector3f(location.x + worldTime * 0.5f, (float)ServerConfig.layer0Height, location.y + worldTime * 0.5f);
        float detailNoise = ShaderCompatibleNoise.fbm(noisePos.div(90.0f), 3, 2.0f, 0.5f, 1.0f);
        float densityNoise = Math.min(ShaderCompatibleNoise.noise2D(new Vector2f(cloudNoisePos.x, cloudNoisePos.z).div(400.0f)) + detailNoise * 0.02f, 1.0f);
        float cloudNoise = Math.min(ShaderCompatibleNoise.noise2D(new Vector2f(noisePos.x, noisePos.z).div(30.0f)) + detailNoise * 0.05f, 1.0f);
        float heightNoise = ShaderCompatibleNoise.noise2D(new Vector2f(noisePos.x, noisePos.z).div(90.0f));
        float bgCloudHeight = Mth.lerp((float)Math.clamp((heightNoise + 1.0f) * 0.5f, 0.0f, 1.0f), (float)300.0f, (float)850.0f);
        float v = Math.clamp(densityNoise - (1.0f - (float)ServerConfig.overcastPercent), 0.0f, 1.0f);
        c += (float)Math.max(Math.pow(v, 0.25), 0.0);
        c *= Mth.lerp((float)v, (float)Math.clamp(cloudNoise - 0.1f + v, 0.0f, 1.0f), (float)1.0f);
        c *= 0.9f + detailNoise * 0.1f;
        c = (float)Math.pow(c, 0.5) * 0.5f;
        c *= Mth.lerp((float)((float)Math.sqrt(v)), (float)(bgCloudHeight / 850.0f), (float)1.0f);
        double stormSize = ServerConfig.stormSize;
        for (Storm storm : weatherHandler.getStorms()) {
            Vector2f stormPos = new Vector2f((float)storm.position.x, (float)storm.position.z);
            float dist = stormPos.distance((Vector2fc)location);
            float smoothStage = (float)storm.stage + (float)storm.energy / 100.0f;
            if (storm.stormType == 2) {
                c *= Mth.lerp((float)Math.clamp((float)(storm.windspeed - 65) / 60.0f, 0.0f, 1.0f), (float)1.0f, (float)((float)Math.pow(Math.clamp((double)dist / ((double)storm.maxWidth * 0.1), 0.0, 1.0), 2.0)));
            }
            if (storm.stormType != 0) continue;
            c *= Mth.lerp((float)Math.clamp(smoothStage, 0.0f, 1.0f), (float)1.0f, (float)((float)Math.pow(Math.clamp((double)dist / (stormSize * 4.0), 0.0, 1.0), 1.5)));
        }
        return c * (float)ServerConfig.overcastPercent;
    }
}

