/*
 * Decompiled with CFR 0.152.
 */
package dev.protomanly.pmweather.weather;

import dev.protomanly.pmweather.PMWeather;
import dev.protomanly.pmweather.config.ServerConfig;
import dev.protomanly.pmweather.data.LevelSavedData;
import dev.protomanly.pmweather.interfaces.IWorldData;
import dev.protomanly.pmweather.util.Util;
import dev.protomanly.pmweather.weather.Clouds;
import dev.protomanly.pmweather.weather.Storm;
import dev.protomanly.pmweather.weather.WeatherHandlerServer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.util.Mth;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.Vec2;
import net.minecraft.world.phys.Vec3;
import org.joml.Vector2f;

public abstract class WeatherHandler
implements IWorldData {
    private List<Storm> storms = new ArrayList<Storm>();
    private ResourceKey<Level> dimension;
    public HashMap<Long, Storm> lookupStormByID = new HashMap();
    public long seed;

    public WeatherHandler(ResourceKey<Level> dimension) {
        this.dimension = dimension;
    }

    public void tick() {
        Level level = this.getWorld();
        if (level != null) {
            List<Storm> stormList = this.getStorms();
            for (int i = 0; i < stormList.size(); ++i) {
                Storm storm = stormList.get(i);
                WeatherHandler weatherHandler = this;
                if (weatherHandler instanceof WeatherHandlerServer) {
                    WeatherHandlerServer weatherHandlerServer = (WeatherHandlerServer)weatherHandler;
                    if (storm.dead) {
                        this.removeStorm(storm.ID);
                        weatherHandlerServer.syncStormRemove(storm);
                        continue;
                    }
                }
                if (!storm.dead) {
                    storm.tick();
                    continue;
                }
                this.removeStorm(storm.ID);
            }
        }
    }

    public List<Storm> getStorms() {
        return this.storms;
    }

    public void addStorm(Storm storm) {
        if (!this.lookupStormByID.containsKey(storm.ID)) {
            this.storms.add(storm);
            this.lookupStormByID.put(storm.ID, storm);
        } else {
            PMWeather.LOGGER.warn("Tried to add a storm with existing ID: {}", (Object)storm.ID);
        }
    }

    public void removeStorm(long id) {
        Storm storm = this.lookupStormByID.get(id);
        if (storm != null) {
            storm.remove();
            this.storms.remove(storm);
            this.lookupStormByID.remove(id);
        } else {
            PMWeather.LOGGER.warn("Tried to remove a non-existent storm with ID: {}", (Object)id);
        }
    }

    public float getPrecipitation(Vec3 pos) {
        float precip = 0.0f;
        float cloudDensity = Clouds.getCloudDensity(this, new Vector2f((float)pos.x, (float)pos.z), 0.0f);
        if (cloudDensity > 0.15f) {
            precip += (cloudDensity - 0.15f) * 2.0f;
        }
        for (Storm storm : this.getStorms()) {
            if (storm.visualOnly) continue;
            double dist = pos.distanceTo(new Vec3(storm.position.x, pos.y, storm.position.z));
            double perc = 0.0;
            float smoothStage = (float)storm.stage + (float)storm.energy / 100.0f;
            if (storm.stage == 3) {
                smoothStage = 3.0f;
            }
            if (storm.stormType == 2) {
                Vec3 cPos = storm.position.multiply(1.0, 0.0, 1.0);
                float intensity = (float)Math.pow(Math.clamp((float)storm.windspeed / 65.0f, 0.0f, 1.0f), 0.85f);
                Vec3 relPos = cPos.subtract(pos);
                double d = (float)storm.maxWidth / (3.0f + (float)storm.windspeed / 12.0f);
                double d2 = (float)storm.maxWidth / (1.15f + (float)storm.windspeed / 12.0f);
                double dE = (float)storm.maxWidth * 0.65f / (1.75f + (float)storm.windspeed / 12.0f);
                double fac = 1.0 + Math.max((dist - (double)((float)storm.maxWidth * 0.2f)) / (double)storm.maxWidth, 0.0) * 2.0;
                double angle = Math.atan2(relPos.z, relPos.x) - dist / (d *= fac);
                double angle2 = Math.atan2(relPos.z, relPos.x) - dist / (d2 *= fac);
                double angleE = Math.atan2(relPos.z, relPos.x) - dist / dE;
                float weak = 0.0f;
                float strong = 0.0f;
                float intense = 0.0f;
                float staticBands = (float)Math.sin(angle - 1.5707963267948966);
                staticBands *= (float)Math.pow(Math.clamp(dist / (double)((float)storm.maxWidth * 0.25f), 0.0, 1.0), 0.1f);
                if ((staticBands *= 1.25f * (float)Math.pow(intensity, 0.75)) < 0.0f) {
                    weak += Math.abs(staticBands);
                } else {
                    weak += Math.abs(staticBands) * (float)Math.pow(1.0 - Math.clamp(dist / (double)((float)storm.maxWidth * 0.65f), 0.0, 1.0), 0.5);
                    weak *= Math.clamp(((float)storm.windspeed - 70.0f) / 40.0f, 0.0f, 1.0f);
                }
                float rotatingBands = (float)Math.sin((angle2 + Math.toRadians((float)storm.tickCount / 8.0f)) * 6.0);
                rotatingBands *= (float)Math.pow(Math.clamp(dist / (double)((float)storm.maxWidth * 0.25f), 0.0, 1.0), 0.1f);
                strong += Mth.lerp((float)0.45f, (float)(Math.abs(rotatingBands *= 1.25f * (float)Math.pow(intensity, 0.75)) * 0.3f + 0.7f), (float)weak);
                intense += Mth.lerp((float)0.3f, (float)(Math.abs(rotatingBands) * 0.2f + 0.8f), (float)weak);
                weak = (Math.abs(rotatingBands) * 0.3f + 0.6f) * weak;
                float localRain = 0.0f;
                localRain += Mth.lerp((float)Math.clamp(((float)storm.windspeed - 120.0f) / 60.0f, 0.0f, 1.0f), (float)Mth.lerp((float)Math.clamp(((float)storm.windspeed - 40.0f) / 90.0f, 0.0f, 1.0f), (float)weak, (float)strong), (float)intense);
                float eye = (float)Math.sin((angleE + Math.toRadians((float)storm.tickCount / 4.0f)) * 2.0);
                float efc = Mth.lerp((float)Math.clamp(((float)storm.windspeed - 100.0f) / 50.0f, 0.0f, 1.0f), (float)0.15f, (float)0.4f);
                localRain = Math.max((float)Math.pow(1.0 - Math.clamp(dist / (double)((float)storm.maxWidth * efc), 0.0, 1.0), 0.5) * (Math.abs(eye * 0.1f) + 0.9f) * 1.35f * intensity, localRain);
                localRain *= (float)Math.pow(1.0 - Math.clamp(dist / (double)storm.maxWidth, 0.0, 1.0), 0.5);
                localRain *= Mth.lerp((float)(0.5f + Math.clamp(((float)storm.windspeed - 65.0f) / 40.0f, 0.0f, 1.0f) * 0.5f), (float)1.0f, (float)((float)Math.pow(Math.clamp(dist / (double)((float)storm.maxWidth * 0.1f), 0.0, 1.0), 2.0)));
                if (localRain > 0.6f) {
                    float dif = (localRain - 0.6f) / 2.5f;
                    localRain -= dif;
                }
                precip += Math.max(localRain - 0.15f, 0.0f) * 2.0f;
            }
            if (storm.stormType == 1) {
                Vec2 v2fWorldPos = new Vec2((float)pos.x, (float)pos.z);
                Vec2 stormVel = new Vec2((float)storm.velocity.x, (float)storm.velocity.z);
                Vec2 v2fStormPos = new Vec2((float)storm.position.x, (float)storm.position.z);
                Vec2 right = new Vec2(stormVel.y, -stormVel.x).normalized();
                Vec2 fwd = stormVel.normalized();
                Vec2 le = Util.mulVec2(right, -((float)ServerConfig.stormSize) * 5.0f);
                Vec2 ri = Util.mulVec2(right, (float)ServerConfig.stormSize * 5.0f);
                Vec2 off = Util.mulVec2(fwd, -((float)Math.pow(Mth.clamp((double)(dist / (double)((float)ServerConfig.stormSize * 5.0f)), (double)0.0, (double)1.0), 2.0)) * ((float)ServerConfig.stormSize * 1.5f));
                le = le.add(off);
                ri = ri.add(off);
                float d = Util.minimumDistance(le = le.add(v2fStormPos), ri = ri.add(v2fStormPos), v2fWorldPos);
                if ((double)d > ServerConfig.stormSize * 16.0) continue;
                Vec2 nearPoint = Util.nearestPoint(le, ri, v2fWorldPos);
                Vec2 facing = v2fWorldPos.add(nearPoint.negated());
                float behind = -facing.dot(fwd);
                float sze = (float)ServerConfig.stormSize * 1.5f;
                sze *= Mth.lerp((float)Mth.clamp((float)(smoothStage - 1.0f), (float)0.0f, (float)1.0f), (float)4.0f, (float)12.0f);
                if ((behind += (float)ServerConfig.stormSize / 2.0f) > 0.0f) {
                    float start;
                    float p = Mth.clamp((float)(Math.abs(behind) / sze), (float)0.0f, (float)1.0f);
                    p = p <= (start = 0.06f) ? (p /= start) : 1.0f - (p - start) / (1.0f - start);
                    perc = (float)Math.pow(Mth.clamp((float)p, (float)0.0f, (float)1.0f), 3.0);
                }
                if (storm.stage <= 0) {
                    perc = 0.0;
                } else if (storm.stage == 1) {
                    perc *= (double)((float)storm.energy / 100.0f);
                }
                perc *= (double)Mth.sqrt((float)(1.0f - Mth.clamp((float)(d / sze), (float)0.0f, (float)1.0f)));
            }
            if (storm.stormType == 0) {
                double coreDist = pos.distanceTo(new Vec3(storm.position.x + 2000.0, pos.y, storm.position.z - 900.0));
                if (Math.min(dist, coreDist) > ServerConfig.stormSize * 6.0) continue;
                perc = 1.0 - Math.clamp(dist / ServerConfig.stormSize, 0.0, 1.0);
                if (storm.stage == 0) {
                    perc *= (double)((float)storm.energy / 100.0f);
                }
                if (storm.stage >= 2) {
                    perc *= (double)Mth.lerp((float)Math.clamp(smoothStage - 2.0f, 0.0f, 1.0f), (float)1.0f, (float)(storm.occlusion * 0.5f + 0.5f));
                }
                double p = 1.0 - Math.clamp(coreDist / (ServerConfig.stormSize * 6.0), 0.0, 1.0);
                if (storm.stage <= 1) {
                    p *= 0.0;
                }
                if (storm.stage >= 2) {
                    p *= (double)Math.clamp((smoothStage - 2.0f) / 0.5f, 0.0f, 1.0f);
                }
                perc = Math.max(p, perc);
            }
            precip += (float)perc;
        }
        return Math.clamp(precip * (float)ServerConfig.rainStrength, 0.0f, 1.0f);
    }

    public abstract Level getWorld();

    @Override
    public CompoundTag save(CompoundTag data) {
        PMWeather.LOGGER.debug("WeatherHandler save");
        CompoundTag listStormsNBT = new CompoundTag();
        for (int i = 0; i < this.storms.size(); ++i) {
            Storm storm = this.storms.get(i);
            storm.getNBTCache().setUpdateForced(true);
            storm.write();
            storm.getNBTCache().setUpdateForced(false);
            listStormsNBT.put("storm_" + storm.ID, (Tag)storm.getNBTCache().getNewNBT());
        }
        data.put("stormData", (Tag)listStormsNBT);
        data.putLong("lastUsedIDStorm", Storm.LastUsedStormID);
        return null;
    }

    public void read() {
        LevelSavedData savedData = (LevelSavedData)((ServerLevel)this.getWorld()).getDataStorage().computeIfAbsent(LevelSavedData.factory(), "pmweather_weather_data");
        savedData.setDataHandler(this);
        PMWeather.LOGGER.debug("Weather Data: {}", (Object)savedData.getData());
        CompoundTag data = savedData.getData();
        Storm.LastUsedStormID = data.getLong("lastUsedIDStorm");
        CompoundTag storms = data.getCompound("stormData");
        for (String tagName : storms.getAllKeys()) {
            CompoundTag stormData = storms.getCompound(tagName);
            Storm storm = new Storm(this, this.getWorld(), null, stormData.getInt("stormType"));
            try {
                storm.getNBTCache().setNewNBT(stormData);
                storm.read();
                storm.getNBTCache().updateCacheFromNew();
            }
            catch (Exception e) {
                PMWeather.LOGGER.error(e.getMessage(), (Throwable)e);
            }
            this.addStorm(storm);
        }
    }
}

