/*
 * Decompiled with CFR 0.152.
 */
package net.zoniex.init;

import net.minecraft.core.registries.Registries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.neoforged.bus.api.SubscribeEvent;
import net.neoforged.fml.common.EventBusSubscriber;
import net.neoforged.neoforge.event.entity.EntityAttributeCreationEvent;
import net.neoforged.neoforge.event.entity.RegisterSpawnPlacementsEvent;
import net.neoforged.neoforge.registries.DeferredHolder;
import net.neoforged.neoforge.registries.DeferredRegister;
import net.zoniex.entity.BlockTestEntity;
import net.zoniex.entity.BloodEagleEntity;
import net.zoniex.entity.BloodEagleTamedEntity;
import net.zoniex.entity.BloodProjectileEntity;
import net.zoniex.entity.BrutaliserEntity;
import net.zoniex.entity.DisembowelerEntity;
import net.zoniex.entity.SkinCrawlerEntity;
import net.zoniex.entity.SkinCrawlerSummonEntity;
import net.zoniex.entity.SpineWrencherEntity;
import net.zoniex.entity.TormentedZombieEntity;

@EventBusSubscriber(bus=EventBusSubscriber.Bus.MOD)
public class ZoniexModEntities {
    public static final DeferredRegister<EntityType<?>> REGISTRY = DeferredRegister.create((ResourceKey)Registries.ENTITY_TYPE, (String)"zoniex");
    public static final DeferredHolder<EntityType<?>, EntityType<DisembowelerEntity>> DISEMBOWELER = ZoniexModEntities.register("disemboweler", EntityType.Builder.of(DisembowelerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(256).setUpdateInterval(3).fireImmune().sized(1.4f, 2.45f));
    public static final DeferredHolder<EntityType<?>, EntityType<BloodEagleEntity>> BLOOD_EAGLE = ZoniexModEntities.register("blood_eagle", EntityType.Builder.of(BloodEagleEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(256).setUpdateInterval(3).sized(1.4f, 1.9f));
    public static final DeferredHolder<EntityType<?>, EntityType<BloodProjectileEntity>> BLOOD_PROJECTILE = ZoniexModEntities.register("blood_projectile", EntityType.Builder.of(BloodProjectileEntity::new, (MobCategory)MobCategory.MISC).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(1).sized(0.5f, 0.5f));
    public static final DeferredHolder<EntityType<?>, EntityType<SkinCrawlerEntity>> SKIN_CRAWLER = ZoniexModEntities.register("skin_crawler", EntityType.Builder.of(SkinCrawlerEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(256).setUpdateInterval(3).sized(0.9f, 0.9f));
    public static final DeferredHolder<EntityType<?>, EntityType<BloodEagleTamedEntity>> BLOOD_EAGLE_TAMED = ZoniexModEntities.register("blood_eagle_tamed", EntityType.Builder.of(BloodEagleTamedEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(256).setUpdateInterval(3).sized(1.4f, 1.9f));
    public static final DeferredHolder<EntityType<?>, EntityType<TormentedZombieEntity>> TORMENTED_ZOMBIE = ZoniexModEntities.register("tormented_zombie", EntityType.Builder.of(TormentedZombieEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(100).setUpdateInterval(3).fireImmune().sized(0.7f, 1.8f));
    public static final DeferredHolder<EntityType<?>, EntityType<BlockTestEntity>> BLOCK_TEST = ZoniexModEntities.register("block_test", EntityType.Builder.of(BlockTestEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(64).setUpdateInterval(3).fireImmune().sized(0.5f, 5.0f));
    public static final DeferredHolder<EntityType<?>, EntityType<BrutaliserEntity>> BRUTALISER = ZoniexModEntities.register("brutaliser", EntityType.Builder.of(BrutaliserEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(120).setUpdateInterval(3).fireImmune().sized(2.2f, 4.4f));
    public static final DeferredHolder<EntityType<?>, EntityType<SkinCrawlerSummonEntity>> SKIN_CRAWLER_SUMMON = ZoniexModEntities.register("skin_crawler_summon", EntityType.Builder.of(SkinCrawlerSummonEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(256).setUpdateInterval(3).sized(0.9f, 0.9f));
    public static final DeferredHolder<EntityType<?>, EntityType<SpineWrencherEntity>> SPINE_WRENCHER = ZoniexModEntities.register("spine_wrencher", EntityType.Builder.of(SpineWrencherEntity::new, (MobCategory)MobCategory.MONSTER).setShouldReceiveVelocityUpdates(true).setTrackingRange(100).setUpdateInterval(3).fireImmune().sized(0.7f, 2.45f));

    private static <T extends Entity> DeferredHolder<EntityType<?>, EntityType<T>> register(String registryname, EntityType.Builder<T> entityTypeBuilder) {
        return REGISTRY.register(registryname, () -> entityTypeBuilder.build(registryname));
    }

    @SubscribeEvent
    public static void init(RegisterSpawnPlacementsEvent event) {
        DisembowelerEntity.init(event);
        BloodEagleEntity.init(event);
        SkinCrawlerEntity.init(event);
        BloodEagleTamedEntity.init(event);
        TormentedZombieEntity.init(event);
        BlockTestEntity.init(event);
        BrutaliserEntity.init(event);
        SkinCrawlerSummonEntity.init(event);
        SpineWrencherEntity.init(event);
    }

    @SubscribeEvent
    public static void registerAttributes(EntityAttributeCreationEvent event) {
        event.put((EntityType)DISEMBOWELER.get(), DisembowelerEntity.createAttributes().build());
        event.put((EntityType)BLOOD_EAGLE.get(), BloodEagleEntity.createAttributes().build());
        event.put((EntityType)SKIN_CRAWLER.get(), SkinCrawlerEntity.createAttributes().build());
        event.put((EntityType)BLOOD_EAGLE_TAMED.get(), BloodEagleTamedEntity.createAttributes().build());
        event.put((EntityType)TORMENTED_ZOMBIE.get(), TormentedZombieEntity.createAttributes().build());
        event.put((EntityType)BLOCK_TEST.get(), BlockTestEntity.createAttributes().build());
        event.put((EntityType)BRUTALISER.get(), BrutaliserEntity.createAttributes().build());
        event.put((EntityType)SKIN_CRAWLER_SUMMON.get(), SkinCrawlerSummonEntity.createAttributes().build());
        event.put((EntityType)SPINE_WRENCHER.get(), SpineWrencherEntity.createAttributes().build());
    }
}

