/*
 * Decompiled with CFR 0.152.
 */
package net.zoniex.item;

import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.neoforged.api.distmarker.Dist;
import net.neoforged.api.distmarker.OnlyIn;
import net.zoniex.procedures.StaffOfTheUndyingItemInInventoryTickProcedure;
import net.zoniex.procedures.StaffOfTheUndyingOnPlayerStoppedUsingProcedure;
import net.zoniex.procedures.StaffOfTheUndyingRightclickedProcedure;
import net.zoniex.procedures.StoredSummonsProcedure;

public class StaffOfTheUndyingItem
extends Item {
    public StaffOfTheUndyingItem() {
        super(new Item.Properties().stacksTo(1).fireResistant().rarity(Rarity.EPIC).attributes(ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 6.0, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, -2.4, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build()));
    }

    public UseAnim getUseAnimation(ItemStack itemstack) {
        return UseAnim.BOW;
    }

    public int getUseDuration(ItemStack itemstack, LivingEntity livingEntity) {
        return 20;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean isFoil(ItemStack itemstack) {
        LocalPlayer entity = Minecraft.getInstance().player;
        return StoredSummonsProcedure.execute((Entity)entity);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void appendHoverText(ItemStack itemstack, Item.TooltipContext context, List<Component> list, TooltipFlag flag) {
        super.appendHoverText(itemstack, context, list, flag);
        list.add((Component)Component.literal((String)"Enables you to repulse nearby undead mobs (hold right click), or summon skin crawler minions (hit the ground). Each time you kill an undead mob with this item in your inventory, it stores as a charge used for summoning - stores up to 5 at a time, glows when you have one or more summons. Summoned mobs last for a minute before despawning"));
    }

    public InteractionResultHolder<ItemStack> use(Level world, Player entity, InteractionHand hand) {
        InteractionResultHolder ar = super.use(world, entity, hand);
        entity.startUsingItem(hand);
        return ar;
    }

    public ItemStack finishUsingItem(ItemStack itemstack, Level world, LivingEntity entity) {
        ItemStack retval = super.finishUsingItem(itemstack, world, entity);
        double x = entity.getX();
        double y = entity.getY();
        double z = entity.getZ();
        StaffOfTheUndyingRightclickedProcedure.execute((LevelAccessor)world, x, y, z, (Entity)entity, itemstack);
        return retval;
    }

    public void inventoryTick(ItemStack itemstack, Level world, Entity entity, int slot, boolean selected) {
        super.inventoryTick(itemstack, world, entity, slot, selected);
        StaffOfTheUndyingItemInInventoryTickProcedure.execute(entity);
    }

    public void releaseUsing(ItemStack itemstack, Level world, LivingEntity entity, int time) {
        StaffOfTheUndyingOnPlayerStoppedUsingProcedure.execute();
    }
}

