/*
 * Decompiled with CFR 0.152.
 */
package ru.fewizz.crawl.client.mixin;

import com.llamalad7.mixinextras.injector.ModifyExpressionValue;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelPart;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.HumanoidArm;
import net.minecraft.world.entity.LivingEntity;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ru.fewizz.crawl.client.CrawlClient;
import ru.fewizz.crawl.client.mixininterface.CrawlingState;

@Mixin(value={HumanoidModel.class})
public abstract class HumanoidModelMixin<T extends LivingEntity>
extends EntityModel<T>
implements CrawlingState {
    @Shadow
    @Final
    public ModelPart head;
    @Shadow
    @Final
    public ModelPart hat;
    @Shadow
    @Final
    public ModelPart body;
    @Shadow
    @Final
    public ModelPart rightArm;
    @Shadow
    @Final
    public ModelPart leftArm;
    @Shadow
    @Final
    public ModelPart rightLeg;
    @Shadow
    @Final
    public ModelPart leftLeg;
    @Shadow
    public float swimAmount;
    @Unique
    private boolean crawling = false;

    @Shadow
    private HumanoidArm getAttackArm(LivingEntity livingEntity) {
        return null;
    }

    @Override
    public boolean isCrawling() {
        return this.crawling;
    }

    @Override
    public void setCrawling(boolean v) {
        this.crawling = v;
    }

    HumanoidModelMixin() {
        super(null);
    }

    @ModifyExpressionValue(method={"setupAnim"}, at={@At(value="FIELD", target="Lnet/minecraft/client/model/HumanoidModel;swimAmount:F", ordinal=0)})
    float skipSwimmingRenderingIfNotInWater(float leaningPitch, LivingEntity state) {
        return !CrawlClient.replaceAnimation || state.isVisuallySwimming() ? leaningPitch : 0.0f;
    }

    @Inject(method={"setupAnim"}, at={@At(value="TAIL")})
    void afterSetAngles(LivingEntity state, float walkDist, float f_0, float f_1, float f_2, float f_3, CallbackInfo ci) {
        if (!CrawlClient.replaceAnimation || !this.crawling) {
            return;
        }
        float sa = this.swimAmount;
        float bodyYRotFreq = 6.0f;
        float bodyXRot = 0.0f;
        float bodyYRot = Mth.sin((float)walkDist) / 5.0f;
        float zOffset = 0.0f;
        float yOffset = 0.0f;
        this.head.setPos(0.0f, 0.0f, 0.0f);
        this.head.zRot = 0.0f;
        this.body.setRotation(0.0f, 0.0f, 0.0f);
        this.leftLeg.x = 1.9f;
        this.rightLeg.x = -1.9f;
        this.leftArm.setPos(5.0f, 2.0f, 0.0f);
        this.rightArm.setPos(-5.0f, 2.0f, 0.0f);
        this.lPos(sa, this.leftLeg, this.leftLeg.x + Mth.sin((float)walkDist) / bodyYRotFreq * this.leftLeg.y, this.leftLeg.y + HumanoidModelMixin.magicF0(walkDist - 2.3561945f) * 2.0f - 1.0f + yOffset, HumanoidModelMixin.magicF0(walkDist - 1.5707964f) + zOffset);
        this.lRot(sa, this.leftLeg, -HumanoidModelMixin.magicF1(walkDist + (float)Math.PI) / 6.0f, bodyYRot, 0.0f);
        this.lPos(sa, this.rightLeg, this.rightLeg.x + Mth.sin((float)walkDist) / bodyYRotFreq * this.rightLeg.y, this.rightLeg.y + HumanoidModelMixin.magicF0(walkDist + 0.7853982f) * 2.0f - 1.0f + yOffset, HumanoidModelMixin.magicF0(walkDist + 1.5707964f) + zOffset);
        this.lRot(sa, this.rightLeg, HumanoidModelMixin.magicF1(walkDist) / 6.0f, bodyYRot, 0.0f);
        float bodyHeight = 12.0f;
        this.lPos(sa, this.body, this.body.x, (1.0f - Mth.cos((float)this.la(sa, this.body.xRot, bodyXRot))) * bodyHeight + yOffset, -Mth.sin((float)this.la(sa, this.body.xRot, bodyXRot)) * bodyHeight + zOffset);
        this.lRot(sa, this.body, -Mth.sin((float)walkDist) / bodyYRotFreq, bodyYRot, bodyXRot);
        this.lPos(sa, this.head, this.head.x, this.head.y + yOffset, this.head.z + Mth.cos((float)(walkDist * 2.0f)) / 2.0f + zOffset);
        this.lRot(sa, this.head, -this.head.yRot, 0.0f, this.head.xRot - 1.5707964f);
        this.leftArm.y = this.body.y + 2.0f;
        this.leftArm.z = this.head.z;
        this.rightArm.y = this.body.y + 2.0f;
        this.rightArm.z = this.head.z;
        if (state.isUsingItem() && state.getUsedItemHand() == InteractionHand.OFF_HAND == (state.getMainArm() == HumanoidArm.LEFT) || this.attackTime > 0.0f && this.getAttackArm(state) == HumanoidArm.LEFT) {
            this.lRot(sa, this.leftArm, -this.leftArm.yRot, 0.0f, this.leftArm.xRot - 1.5707964f);
        } else {
            this.lRot(sa, this.leftArm, -1.5707964f + HumanoidModelMixin.magicF0(walkDist + 1.5707964f), this.body.yRot - 1.5707964f, -0.5f);
        }
        if (state.isUsingItem() && state.getUsedItemHand() == InteractionHand.MAIN_HAND == (state.getMainArm() == HumanoidArm.RIGHT) || this.attackTime > 0.0f && this.getAttackArm(state) == HumanoidArm.RIGHT) {
            this.lRot(sa, this.rightArm, -this.rightArm.yRot, 0.0f, this.rightArm.xRot - 1.5707964f);
        } else {
            this.lRot(sa, this.rightArm, 1.5707964f + -HumanoidModelMixin.magicF0(walkDist - 1.5707964f), this.body.yRot + 1.5707964f, -0.5f);
        }
        this.hat.copyFrom(this.head);
    }

    @Unique
    private float l(float leaningPitch, float original, float changed) {
        return Mth.lerp((float)leaningPitch, (float)original, (float)changed);
    }

    @Unique
    private float la(float leaningPitch, float original, float changed) {
        return Mth.rotLerp((float)leaningPitch, (float)(original * 57.295776f), (float)(changed * 57.295776f)) * ((float)Math.PI / 180);
    }

    @Unique
    private void lPos(float lp, ModelPart mp, float x, float y, float z) {
        mp.setPos(this.l(lp, mp.x, x), this.l(lp, mp.y, y), this.l(lp, mp.z, z));
    }

    @Unique
    private void lRot(float lp, ModelPart mp, float roll, float yaw, float pitch) {
        mp.zRot = this.la(lp, mp.zRot, roll);
        mp.yRot = this.la(lp, mp.yRot, yaw);
        mp.xRot = this.la(lp, mp.xRot, pitch);
    }

    @Unique
    private static float magicF0(float rad) {
        if ((rad %= (float)Math.PI * 2) <= 1.5707964f) {
            return Mth.cos((float)(rad * 2.0f));
        }
        return -Mth.cos((float)((rad - 1.5707964f) * 0.6666667f));
    }

    @Unique
    private static float magicF1(float rad) {
        float r = Mth.sin((float)rad) + 1.0f;
        return r * r;
    }
}

