/*
 * Decompiled with CFR 0.152.
 */
package com.github.L_Ender.cataclysm.items;

import com.github.L_Ender.cataclysm.Cataclysm;
import com.github.L_Ender.cataclysm.init.ModParticle;
import com.github.L_Ender.cataclysm.init.ModSounds;
import com.github.L_Ender.cataclysm.util.CMDamageTypes;
import java.util.List;
import java.util.Optional;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.network.chat.Component;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlotGroup;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.UseAnim;
import net.minecraft.world.item.component.ItemAttributeModifiers;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import net.neoforged.neoforge.common.ItemAbilities;

public class Meat_Shredder
extends Item {
    public Meat_Shredder(Item.Properties properties) {
        super(properties);
    }

    public static ItemAttributeModifiers createAttributes() {
        return ItemAttributeModifiers.builder().add(Attributes.ATTACK_DAMAGE, new AttributeModifier(BASE_ATTACK_DAMAGE_ID, 7.5, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).add(Attributes.ATTACK_SPEED, new AttributeModifier(BASE_ATTACK_SPEED_ID, (double)-2.6f, AttributeModifier.Operation.ADD_VALUE), EquipmentSlotGroup.MAINHAND).build();
    }

    public InteractionResultHolder<ItemStack> use(Level p_77659_1_, Player p_77659_2_, InteractionHand p_77659_3_) {
        ItemStack item = p_77659_2_.getItemInHand(p_77659_3_);
        InteractionHand otherhand = p_77659_3_ == InteractionHand.MAIN_HAND ? InteractionHand.OFF_HAND : InteractionHand.MAIN_HAND;
        ItemStack otheritem = p_77659_2_.getItemInHand(otherhand);
        if (otheritem.canPerformAction(ItemAbilities.SHIELD_BLOCK) && !p_77659_2_.getCooldowns().isOnCooldown(otheritem.getItem())) {
            return InteractionResultHolder.fail((Object)item);
        }
        p_77659_2_.startUsingItem(p_77659_3_);
        p_77659_1_.playSound(null, p_77659_2_.getX(), p_77659_2_.getY(), p_77659_2_.getZ(), (SoundEvent)ModSounds.SHREDDER_START.get(), SoundSource.PLAYERS, 1.5f, 1.0f / (p_77659_2_.getRandom().nextFloat() * 0.4f + 0.8f));
        return InteractionResultHolder.consume((Object)item);
    }

    public boolean isEnchantable(ItemStack stack) {
        return true;
    }

    public int getEnchantmentValue() {
        return 16;
    }

    public boolean canAttackBlock(BlockState state, Level worldIn, BlockPos pos, Player player) {
        return !player.isCreative();
    }

    public void onUseTick(Level level, LivingEntity living, ItemStack stack, int count) {
        double range = 2.5;
        Vec3 srcVec = living.getEyePosition();
        Vec3 lookVec = living.getViewVector(1.0f);
        Vec3 destVec = srcVec.add(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range);
        float var9 = 1.0f;
        List possibleList = level.getEntities((Entity)living, living.getBoundingBox().expandTowards(lookVec.x() * range, lookVec.y() * range, lookVec.z() * range).inflate((double)var9, (double)var9, (double)var9));
        boolean flag = false;
        Cataclysm.PROXY.playWorldSound(living, (byte)1);
        for (Entity entity : possibleList) {
            if (!(entity instanceof LivingEntity)) continue;
            float borderSize = 0.5f;
            AABB collisionBB = entity.getBoundingBox().inflate((double)borderSize, (double)borderSize, (double)borderSize);
            Optional interceptPos = collisionBB.clip(srcVec, destVec);
            if (collisionBB.contains(srcVec)) {
                flag = true;
            } else if (interceptPos.isPresent()) {
                flag = true;
            }
            if (!flag) continue;
            if (entity.hurt(CMDamageTypes.causeShredderDamage(living), (float)living.getAttributeValue(Attributes.ATTACK_DAMAGE) / 8.5f)) {
                // empty if block
            }
            double d0 = (double)(level.getRandom().nextFloat() - 0.5f) + entity.getDeltaMovement().x;
            double d1 = (double)(level.getRandom().nextFloat() - 0.5f) + entity.getDeltaMovement().y;
            double d2 = (double)(level.getRandom().nextFloat() - 0.5f) + entity.getDeltaMovement().z;
            double dist = 1.0f + level.getRandom().nextFloat() * 0.2f;
            double d3 = d0 * dist;
            double d4 = d1 * dist;
            double d5 = d2 * dist;
            entity.level().addParticle((ParticleOptions)ModParticle.SPARK.get(), entity.getX(), living.getEyeY() - 0.1 + (entity.getEyePosition().y - living.getEyeY()), entity.getZ(), d3, d4, d5);
        }
    }

    public void releaseUsing(ItemStack stack, Level world, LivingEntity living, int remainingUseTicks) {
        world.playSound(null, living.getX(), living.getY(), living.getZ(), (SoundEvent)ModSounds.SHREDDER_END.get(), SoundSource.PLAYERS, 1.5f, 1.0f / (living.getRandom().nextFloat() * 0.4f + 0.8f));
        Cataclysm.PROXY.clearSoundCacheFor((Entity)living);
    }

    public float getDestroySpeed(ItemStack p_41004_, BlockState p_41005_) {
        float speed = 15.0f;
        return p_41005_.is(BlockTags.MINEABLE_WITH_AXE) ? speed : 1.0f;
    }

    public int getUseDuration(ItemStack p_43419_, LivingEntity p_345001_) {
        return 72000;
    }

    public UseAnim getUseAnimation(ItemStack stack) {
        return UseAnim.BOW;
    }

    public void appendHoverText(ItemStack stack, Item.TooltipContext context, List<Component> tooltips, TooltipFlag flags) {
        tooltips.add((Component)Component.translatable((String)"item.cataclysm.meat_shredder.desc").withStyle(ChatFormatting.DARK_GREEN));
    }
}

