/*
 * Decompiled with CFR 0.152.
 */
package biomesoplenty.block;

import biomesoplenty.block.entity.AnomalyBlockEntity;
import com.mojang.serialization.MapCodec;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.StringRepresentable;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class AnomalyBlock
extends BaseEntityBlock {
    public static final EnumProperty<AnomalyType> ANOMALY_TYPE = EnumProperty.create((String)"type", AnomalyType.class);
    public static final MapCodec<AnomalyBlock> CODEC = AnomalyBlock.simpleCodec(AnomalyBlock::new);

    public AnomalyBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.registerDefaultState((BlockState)((BlockState)this.stateDefinition.any()).setValue(ANOMALY_TYPE, (Comparable)((Object)AnomalyType.STABLE)));
    }

    protected MapCodec<? extends BaseEntityBlock> codec() {
        return CODEC;
    }

    @Nullable
    public BlockState getStateForPlacement(BlockPlaceContext p_49479_) {
        return (BlockState)this.defaultBlockState().setValue(ANOMALY_TYPE, (Comparable)((Object)(switch (p_49479_.getLevel().random.nextInt(4)) {
            default -> AnomalyType.VOLATILE;
            case 1 -> AnomalyType.QUIRKY;
            case 2 -> AnomalyType.UNSTABLE;
            case 3 -> AnomalyType.STABLE;
        })));
    }

    public boolean propagatesSkylightDown(BlockState state, BlockGetter getter, BlockPos pos) {
        return state.getValue(ANOMALY_TYPE) != AnomalyType.STABLE;
    }

    public RenderShape getRenderShape(BlockState state) {
        return state.getValue(ANOMALY_TYPE) == AnomalyType.STABLE ? RenderShape.MODEL : RenderShape.INVISIBLE;
    }

    public VoxelShape getOcclusionShape(BlockState state, BlockGetter getter, BlockPos pos) {
        if (state.getValue(ANOMALY_TYPE) == AnomalyType.STABLE) {
            return Shapes.block();
        }
        return Shapes.empty();
    }

    protected void createBlockStateDefinition(StateDefinition.Builder<Block, BlockState> builder) {
        builder.add(new Property[]{ANOMALY_TYPE});
    }

    @Nullable
    public BlockEntity newBlockEntity(BlockPos pos, BlockState state) {
        return new AnomalyBlockEntity(pos, state);
    }

    public static enum AnomalyType implements StringRepresentable
    {
        VOLATILE("volatile"),
        QUIRKY("quirky"),
        UNSTABLE("unstable"),
        STABLE("stable");

        private final String name;

        private AnomalyType(String $$0) {
            this.name = $$0;
        }

        public String toString() {
            return this.name;
        }

        public String getSerializedName() {
            return this.name;
        }
    }
}

