/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.config;

import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.EnumValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.util.PanelPositioning;

public interface FTBUltimineClientConfig {
    public static final String KEY = "ftbultimine-client";
    public static final SNBTConfig CONFIG = (SNBTConfig)SNBTConfig.create((String)"ftbultimine-client").comment(new String[]{"Client-specific configuration for FTB Ultimine", "Modpack defaults should be defined in <instance>/config/ftbultimine-client.snbt", "  (may be overwritten on modpack update)", "Players may locally override this by copying into <instance>/local/ftbultimine-client.snbt", "  (will NOT be overwritten on modpack update)"});
    public static final SNBTConfig GENERAL = CONFIG.addGroup("general");
    public static final BooleanValue REQUIRE_ULTIMINE_KEY_FOR_CYCLING = (BooleanValue)GENERAL.addBoolean("require_ultimine_key_for_cycling", true).comment(new String[]{"Does the player need to be holding the Ultimine key to cycle through shapes with the keyboard?"});
    public static final SNBTConfig RENDERING = CONFIG.addGroup("rendering");
    public static final IntValue RENDER_OUTLINE = (IntValue)RENDERING.addInt("render_outline", 256).range((Number)0, (Number)Integer.MAX_VALUE).comment(new String[]{"Maximum number of blocks the white outline should be rendered for", "Keep in mind this may get *very* laggy for large amounts of blocks!"});
    public static final IntValue PREVIEW_LINE_ALPHA = (IntValue)RENDERING.addInt("preview_line_alpha", 45, 0, 255).comment(new String[]{"Alpha value (0-255) for dig preview lines which are 'inside' blocks"});
    public static final SNBTConfig OVERLAY = CONFIG.addGroup("overlay");
    public static final IntValue SHAPE_MENU_CONTEXT_LINES = (IntValue)OVERLAY.addInt("shape_menu_context_lines", 2).range((Number)1, (Number)5).comment(new String[]{"When displaying the shape selection menu by holding the Ultimine key", "and sneaking at the same time, the number of shape names to display", "above and below the selected shape"});
    public static final BooleanValue REQUIRE_SNEAK_FOR_MENU = (BooleanValue)OVERLAY.addBoolean("require_sneak_for_menu", true).comment(new String[]{"When holding the Ultimine key, must the player also be sneaking to show the shapes menu?"});
    public static final EnumValue<PanelPositioning> OVERLAY_POS = OVERLAY.addEnum("overlay_pos", PanelPositioning.NAME_MAP, (Object)PanelPositioning.TOP_LEFT);
    public static final IntValue OVERLAY_INSET_X = OVERLAY.addInt("overlay_inset_x", 2);
    public static final IntValue OVERLAY_INSET_Y = OVERLAY.addInt("overlay_inset_y", 2);
}

