/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.core;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.AlmostUnified;
import com.almostreliable.unified.api.AlmostUnifiedRuntime;
import com.almostreliable.unified.api.unification.UnificationEntry;
import com.google.auto.service.AutoService;
import java.util.Collection;
import java.util.Set;
import java.util.stream.Collectors;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.ItemLike;
import org.jetbrains.annotations.Nullable;

@AutoService(value={AlmostUnified.class})
public class AlmostUnifiedImpl
implements AlmostUnified {
    @Override
    public boolean isRuntimeLoaded() {
        return this.getRuntime() != null;
    }

    @Override
    @Nullable
    public AlmostUnifiedRuntime getRuntime() {
        return AlmostUnifiedCommon.getRuntime();
    }

    @Override
    public AlmostUnifiedRuntime getRuntimeOrThrow() {
        AlmostUnifiedRuntime runtime = AlmostUnifiedCommon.getRuntime();
        if (runtime == null) {
            throw new IllegalStateException("runtime is not loaded");
        }
        return runtime;
    }

    @Override
    public Collection<TagKey<Item>> getTags() {
        if (!this.isRuntimeLoaded()) {
            return Set.of();
        }
        return this.getRuntimeOrThrow().getUnificationLookup().getTags();
    }

    @Override
    public Collection<Item> getTagEntries(TagKey<Item> tag) {
        if (!this.isRuntimeLoaded()) {
            return Set.of();
        }
        return this.getRuntimeOrThrow().getUnificationLookup().getTagEntries(tag).stream().map(UnificationEntry::value).collect(Collectors.toSet());
    }

    @Override
    @Nullable
    public TagKey<Item> getRelevantItemTag(ItemLike itemLike) {
        if (!this.isRuntimeLoaded()) {
            return null;
        }
        return this.getRuntimeOrThrow().getUnificationLookup().getRelevantItemTag(itemLike.asItem());
    }

    @Override
    @Nullable
    public Item getVariantItemTarget(ItemLike itemLike) {
        if (!this.isRuntimeLoaded()) {
            return null;
        }
        ResourceLocation id = BuiltInRegistries.ITEM.getKey((Object)itemLike.asItem());
        UnificationEntry<Item> replacement = this.getRuntimeOrThrow().getUnificationLookup().getVariantItemTarget(id);
        return replacement == null ? null : replacement.value();
    }

    @Override
    @Nullable
    public Item getTagTargetItem(TagKey<Item> tag) {
        if (!this.isRuntimeLoaded()) {
            return null;
        }
        UnificationEntry<Item> replacement = this.getRuntimeOrThrow().getUnificationLookup().getTagTargetItem(tag);
        return replacement == null ? null : replacement.value();
    }
}

