/*
 * Decompiled with CFR 0.152.
 */
package de.teamlapen.vampirism_integrations.jade.provider;

import de.teamlapen.vampirism.blockentity.GarlicDiffuserBlockEntity;
import de.teamlapen.vampirism.core.ModItems;
import de.teamlapen.vampirism_integrations.jade.JadePlugin;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import snownee.jade.api.BlockAccessor;
import snownee.jade.api.IBlockComponentProvider;
import snownee.jade.api.IServerDataProvider;
import snownee.jade.api.ITooltip;
import snownee.jade.api.config.IPluginConfig;
import snownee.jade.api.theme.IThemeHelper;
import snownee.jade.api.ui.BoxStyle;
import snownee.jade.api.ui.IElementHelper;

public enum GarlicDiffuserProvider implements IBlockComponentProvider,
IServerDataProvider<BlockAccessor>
{
    INSTANCE;


    public void appendTooltip(ITooltip iTooltip, BlockAccessor blockAccessor, IPluginConfig iPluginConfig) {
        if (blockAccessor.getServerData().contains("garlicDiffuser", 10)) {
            CompoundTag tag = blockAccessor.getServerData().getCompound("garlicDiffuser");
            int fuelTime = tag.getInt("fuelTime");
            float bootProgress = tag.getFloat("bootProgress");
            IElementHelper helper = IElementHelper.get();
            if (bootProgress == 1.0f) {
                iTooltip.add(helper.smallItem(new ItemStack((ItemLike)ModItems.PURIFIED_GARLIC.get())));
                iTooltip.append((Component)IThemeHelper.get().seconds(fuelTime, 20.0f));
            } else {
                iTooltip.add(helper.progress(bootProgress, (Component)Component.translatable((String)"gui.vampirism.garlic_diffuser.startup"), helper.progressStyle().color(0xD0D0FF).textColor(0xFFFFFF), (BoxStyle)BoxStyle.GradientBorder.DEFAULT_NESTED_BOX, false));
            }
        }
    }

    public void appendServerData(CompoundTag tag, BlockAccessor blockAccessor) {
        BlockEntity blockEntity = blockAccessor.getBlockEntity();
        if (blockEntity instanceof GarlicDiffuserBlockEntity) {
            GarlicDiffuserBlockEntity diffuser = (GarlicDiffuserBlockEntity)blockEntity;
            CompoundTag compoundTag = new CompoundTag();
            compoundTag.putInt("fuelTime", diffuser.getFuelTime());
            compoundTag.putFloat("bootProgress", diffuser.getBootProgress());
            tag.put("garlicDiffuser", (Tag)compoundTag);
        }
    }

    public ResourceLocation getUid() {
        return JadePlugin.GARLIC_BEACON;
    }
}

